/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aemds.guide.xfa;

import com.adobe.aemds.guide.service.GuideException;
import com.adobe.aemds.guide.utils.CustomJSONWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XFAJSONWriter
extends CustomJSONWriter {
    public XFAJSONWriter(Writer w) {
        super(w);
    }

    public XFAJSONWriter startObject(String key) throws GuideException {
        if (key != null) {
            this.key(key);
        } else {
            key = "null";
        }
        this.objectStack.push(key);
        return (XFAJSONWriter)this.object();
    }

    public XFAJSONWriter completeObject(String key) throws GuideException {
        String top;
        if (key == null) {
            key = "null";
        }
        if (!key.equals(top = (String)this.objectStack.pop())) {
            throw new GuideException("ending object which was not started " + key);
        }
        return (XFAJSONWriter)this.endObject();
    }

    public XFAJSONWriter writeArray(String[] arr) throws GuideException {
        for (int i = 0; i < arr.length; ++i) {
            this.value(arr[i]);
        }
        return this;
    }

    public XFAJSONWriter writeProperties(Hashtable<String, Object> props) {
        Enumeration<String> propEnum = props.keys();
        while (propEnum.hasMoreElements()) {
            String prop = propEnum.nextElement();
            Object value = props.get(prop);
            if (value instanceof String[]) {
                ((XFAJSONWriter)this.key(prop).array()).writeArray((String[])value).endArray();
                continue;
            }
            this.key(prop).value(value);
        }
        return this;
    }
}

