/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aemfd.wsdl;

import com.adobe.aemfd.wsdl.WSDLInvokerInternalObject;
import com.adobe.aemfd.wsdl.WSDLInvokerParams;
import com.adobe.aemfd.wsdl.WSDLUtils;
import com.ibm.wsdl.extensions.schema.SchemaImpl;
import com.ibm.wsdl.extensions.soap.SOAPBindingImpl;
import com.sun.xml.xsom.XSComplexType;
import com.sun.xml.xsom.XSContentType;
import com.sun.xml.xsom.XSElementDecl;
import com.sun.xml.xsom.XSListSimpleType;
import com.sun.xml.xsom.XSParticle;
import com.sun.xml.xsom.XSRestrictionSimpleType;
import com.sun.xml.xsom.XSSchemaSet;
import com.sun.xml.xsom.XSSimpleType;
import com.sun.xml.xsom.XSTerm;
import com.sun.xml.xsom.XSType;
import com.sun.xml.xsom.XSUnionSimpleType;
import com.sun.xml.xsom.parser.XSOMParser;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Output;
import javax.wsdl.Part;
import javax.wsdl.WSDLException;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPConnectionFactory;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSDLInvoker {
    protected final Logger log = LoggerFactory.getLogger(WSDLInvoker.class);
    final String wsdlStdSchemaNamespace = "http://www.w3.org/2001/XMLSchema";
    final String wsdlName = "name";
    final String wsdlNamespace = "namespace";
    final String wsdlOperationPort = "port";
    final String wsdlOperationInput = "input";
    final String wsdlOperationOutput = "output";
    final String wsdlOperationParams = "params";
    final String wsdlOperationActionUri = "soapActionURI";
    final String wsdlOperationServiceUri = "serviceEndPoint";
    final String wsdlParamType = "type";
    final String wsdlParamPropIsNillable = "isNillable";
    final String wsdlParamPropIsRepeated = "isRepeated";
    final String wsdlParamPropMinOccurs = "minOccurs";
    final String wsdlParamPropMaxOccurs = "maxOccurs";
    final String wsdlSoapHeaderSoapAction = "SOAPAction";
    private String wsdlCurrentOperation = "";
    private boolean arrayErrorLogged = false;

    private String getCurrentOperation() {
        return this.wsdlCurrentOperation;
    }

    private void setCurrentOperation(String operationName) {
        this.wsdlCurrentOperation = operationName;
        this.arrayErrorLogged = false;
    }

    private void fetchWSDL(WSDLInvokerInternalObject wsdlInvokerParam, String endPoint) throws Exception {
        try {
            WSDLFactory wsdlFactory = WSDLFactory.newInstance();
            WSDLReader wsdlReader = wsdlFactory.newWSDLReader();
            wsdlReader.setFeature("javax.wsdl.importDocuments", true);
            Definition definition = wsdlReader.readWSDL(endPoint);
            wsdlInvokerParam.setDefinition(definition);
        }
        catch (WSDLException e) {
            throw new Exception("fetchWSDL");
        }
    }

    private void setEndPoint(WSDLInvokerInternalObject wsdlInvokerParam, String endPoint) throws Exception {
        wsdlInvokerParam.setEndPoint(endPoint);
        StringWriter strWriter = new StringWriter();
        JSONWriter jsonWriter = new JSONWriter((Writer)strWriter);
        wsdlInvokerParam.setStrWriter(strWriter);
        wsdlInvokerParam.setJsonWriter(jsonWriter);
    }

    private InputStream prepareSchema(WSDLInvokerInternalObject wsdlInvokerInternalObject, Element el) throws Exception {
        Map namespaces = wsdlInvokerInternalObject.getDefinition().getNamespaces();
        for (Map.Entry ns : namespaces.entrySet()) {
            if (((String)ns.getKey()).equals("")) continue;
            el.setAttribute("xmlns:" + (String)ns.getKey(), (String)ns.getValue());
        }
        String contextUrl = wsdlInvokerInternalObject.getEndPoint().substring(0, wsdlInvokerInternalObject.getEndPoint().lastIndexOf("/") + 1);
        NodeList imports = el.getElementsByTagNameNS("http://www.w3.org/2001/XMLSchema", "import");
        for (int i = 0; i < imports.getLength(); ++i) {
            Element currentImport = (Element)imports.item(i);
            String location = currentImport.getAttribute("schemaLocation");
            boolean isAbsolute = location.startsWith("http");
            if (isAbsolute) continue;
            currentImport.setAttribute("schemaLocation", contextUrl + location);
        }
        TransformerFactory tFactory = TransformerFactory.newInstance();
        Transformer transformer = tFactory.newTransformer();
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        DOMSource source = new DOMSource(el);
        StreamResult result = new StreamResult(os);
        transformer.transform(source, result);
        String temp = ((Object)os).toString();
        return new ByteArrayInputStream(temp.getBytes());
    }

    private void expandBuiltInType(WSDLInvokerInternalObject wsdlInvokerInternalObject, XSElementDecl element, boolean isNillable, boolean isRepeated, int minOccurs, int maxOccurs) throws Exception {
        try {
            XSType type = element.getType();
            JSONWriter jsonWriter = wsdlInvokerInternalObject.getJsonWriter();
            jsonWriter.object();
            jsonWriter.key("name").value((Object)element.getName());
            jsonWriter.key("type").value((Object)element.getType().getName());
            if (WSDLUtils.enableDebugging) {
                // empty if block
            }
            jsonWriter.endObject();
        }
        catch (JSONException e) {
            throw new Exception("expandBuiltInType");
        }
    }

    private void expandSimpleType(WSDLInvokerInternalObject wsdlInvokerInternalObject, XSElementDecl element, XSSimpleType simpleType) throws Exception {
        XSRestrictionSimpleType restrictions = simpleType.asRestriction();
        XSListSimpleType lists = simpleType.asList();
        XSComplexType complex = simpleType.asComplexType();
        XSUnionSimpleType union = simpleType.asUnion();
        if (lists != null || complex != null || union != null) {
            throw new Exception("Unsupported Simple Type");
        }
        if (restrictions != null) {
            XSType baseType = restrictions.getBaseType();
            JSONWriter jsonWriter = wsdlInvokerInternalObject.getJsonWriter();
            jsonWriter.object();
            jsonWriter.key("name").value((Object)element.getName());
            jsonWriter.key("type").value((Object)baseType.getName());
            jsonWriter.key("namespace").value((Object)element.getTargetNamespace());
            jsonWriter.endObject();
        }
    }

    private void addElementAttribute(JSONWriter jsonWriter, Map<String, Object> attrMap) throws JSONException {
        jsonWriter.object();
        jsonWriter.key("__attr");
        jsonWriter.object();
        for (Map.Entry<String, Object> entry : attrMap.entrySet()) {
            jsonWriter.key(entry.getKey()).value(entry.getValue());
        }
        jsonWriter.endObject();
        jsonWriter.endObject();
    }

    private void expandCompositeTypeElement(WSDLInvokerInternalObject wsdlInvokerInternalObject, XSElementDecl element, Stack<String> elementNameChain) throws Exception {
        block10: {
            XSType type = element.getType();
            assert (type instanceof XSComplexType);
            try {
                if (type instanceof XSSimpleType) {
                    this.expandSimpleType(wsdlInvokerInternalObject, element, (XSSimpleType)type);
                    break block10;
                }
                if (type instanceof XSComplexType) {
                    XSTerm term;
                    XSContentType content = ((XSComplexType)type).getContentType();
                    XSParticle xsParticle = content.asParticle();
                    if (xsParticle != null && (term = xsParticle.getTerm()).isModelGroup()) {
                        XSParticle[] particles;
                        for (XSParticle particle : particles = term.asModelGroup().getChildren()) {
                            int index;
                            int maxOccurs;
                            XSTerm pterm = particle.getTerm();
                            if (!pterm.isElementDecl()) continue;
                            XSElementDecl innerElement = pterm.asElementDecl();
                            XSType xsType = innerElement.getType();
                            boolean isNillable = innerElement.isNillable();
                            boolean isRepeated = particle.isRepeated();
                            int minOccurs = particle.getMinOccurs() != null ? particle.getMinOccurs().intValue() : 1;
                            int n = maxOccurs = particle.getMaxOccurs() != null ? particle.getMaxOccurs().intValue() : 1;
                            if (xsType instanceof XSSimpleType) {
                                if (xsType.getTargetNamespace().compareToIgnoreCase("http://www.w3.org/2001/XMLSchema") == 0) {
                                    this.expandBuiltInType(wsdlInvokerInternalObject, innerElement, isNillable, isRepeated, minOccurs, maxOccurs);
                                    continue;
                                }
                                this.expandCompositeTypeElement(wsdlInvokerInternalObject, innerElement, elementNameChain);
                                continue;
                            }
                            if (!(xsType instanceof XSComplexType) || (index = elementNameChain.search(innerElement.getName())) != -1) continue;
                            JSONWriter jsonWriter = wsdlInvokerInternalObject.getJsonWriter();
                            jsonWriter.object();
                            jsonWriter.key(innerElement.getName());
                            jsonWriter.array();
                            if (maxOccurs > 1 || maxOccurs == -1) {
                                HashMap<String, Object> attrMap = new HashMap<String, Object>();
                                attrMap.put("minOccurs", minOccurs);
                                attrMap.put("maxOccurs", maxOccurs);
                                this.addElementAttribute(jsonWriter, attrMap);
                            }
                            elementNameChain.push(innerElement.getName());
                            this.expandCompositeTypeElement(wsdlInvokerInternalObject, innerElement, elementNameChain);
                            elementNameChain.pop();
                            jsonWriter.endArray();
                            jsonWriter.endObject();
                        }
                    }
                    break block10;
                }
                throw new Exception("Unable to handle content type");
            }
            catch (JSONException e) {
                throw new Exception("expandCompositeTypeElement");
            }
        }
    }

    private void expandElement(WSDLInvokerInternalObject wsdlInvokerInternalObject, XSElementDecl element) throws Exception {
        try {
            boolean i = false;
            if (!(element.getType() instanceof XSComplexType) && !(element.getType() instanceof XSSimpleType)) {
                throw new JSONException("expandElement: Unsupported type");
            }
            JSONWriter jsonWriter = wsdlInvokerInternalObject.getJsonWriter();
            jsonWriter.key(element.getName());
            jsonWriter.object();
            jsonWriter.key("namespace").value((Object)element.getTargetNamespace());
            jsonWriter.key("params");
            jsonWriter.array();
            Stack<String> elementNames = new Stack<String>();
            elementNames.push(element.getName());
            this.expandCompositeTypeElement(wsdlInvokerInternalObject, element, elementNames);
            jsonWriter.endArray();
            jsonWriter.endObject();
        }
        catch (JSONException e) {
            throw new Exception("expandElement");
        }
    }

    private void expandPart(WSDLInvokerInternalObject wsdlInvokerInternalObject, Part part) throws Exception {
        try {
            JSONWriter jsonWriter = wsdlInvokerInternalObject.getJsonWriter();
            jsonWriter.object();
            QName elementName = part.getElementName();
            QName typeName = part.getTypeName();
            if (typeName != null) {
                jsonWriter.key(part.getName());
                jsonWriter.value((Object)typeName.toString());
            }
            if (elementName != null) {
                XSElementDecl element = wsdlInvokerInternalObject.getSchemaObject().getElementDecl(elementName.getLocalPart());
                this.expandElement(wsdlInvokerInternalObject, element);
            }
            jsonWriter.endObject();
        }
        catch (JSONException e) {
            throw new Exception("expandPart");
        }
    }

    private void expandMessage(WSDLInvokerInternalObject wsdlInvokerInternalObject, Message message) throws Exception {
        try {
            Map msgParts = message.getParts();
            JSONWriter jsonWriter = wsdlInvokerInternalObject.getJsonWriter();
            jsonWriter.array();
            for (Part part : msgParts.values()) {
                this.expandPart(wsdlInvokerInternalObject, part);
            }
            jsonWriter.endArray();
        }
        catch (TransformerException e) {
            throw new Exception("expandMessage: TransformerException");
        }
        catch (SAXException e) {
            throw new Exception("expandMessage: SAXException");
        }
        catch (JSONException e) {
            throw new Exception("expandMessage: JSONException");
        }
    }

    private void expandOperation(WSDLInvokerInternalObject wsdlInvokerInternalObject, Operation op, Binding binding, String soapAction) throws Exception {
        try {
            JSONWriter jsonWriter = wsdlInvokerInternalObject.getJsonWriter();
            jsonWriter.object();
            jsonWriter.key("name").value((Object)op.getName());
            this.setCurrentOperation(op.getName());
            jsonWriter.key("soapActionURI").value((Object)soapAction);
            String port = WSDLUtils.getPortFromBinding(wsdlInvokerInternalObject.getDefinition(), binding.toString());
            jsonWriter.key("port").value((Object)port);
            String serviceEndPoint = WSDLUtils.getServiceEndPointFromPort(wsdlInvokerInternalObject.getDefinition(), port);
            jsonWriter.key("serviceEndPoint").value((Object)serviceEndPoint);
            Input input = op.getInput();
            jsonWriter.key("input");
            this.expandMessage(wsdlInvokerInternalObject, input.getMessage());
            Output output = op.getOutput();
            jsonWriter.key("output");
            this.expandMessage(wsdlInvokerInternalObject, output.getMessage());
            jsonWriter.endObject();
        }
        catch (IOException e) {
            throw new Exception("expandOperation: IOException");
        }
        catch (JSONException e) {
            throw new Exception("expandOperation: JSONException");
        }
    }

    private void parseSchemas(WSDLInvokerInternalObject wsdlInvokerInternalObject) throws Exception {
        if (wsdlInvokerInternalObject.getSchemaObject() != null) {
            return;
        }
        if (wsdlInvokerInternalObject.getDefinition() == null) {
            this.fetchWSDL(wsdlInvokerInternalObject, wsdlInvokerInternalObject.getEndPoint());
        }
        XSOMParser parser = new XSOMParser();
        parser.setErrorHandler((ErrorHandler)new DOMErrorHandler());
        Definition wsdlDefinition = wsdlInvokerInternalObject.getDefinition();
        List list = wsdlDefinition.getTypes().getExtensibilityElements();
        for (int index = 0; index < list.size(); ++index) {
            SchemaImpl schema = (SchemaImpl)wsdlDefinition.getTypes().getExtensibilityElements().get(index);
            Element el = schema.getElement();
            InputStream is = this.prepareSchema(wsdlInvokerInternalObject, el);
            parser.parse(is);
        }
        String targetNamespace = wsdlDefinition.getTargetNamespace();
        XSSchemaSet schemaSet = parser.getResult();
        wsdlInvokerInternalObject.setSchemaObject(schemaSet.getSchema(targetNamespace));
    }

    public String expandAllOperations(String endPoint, WSDLInvokerInternalObject wsdlInvokerInternalObject) throws Exception {
        if (wsdlInvokerInternalObject == null) {
            wsdlInvokerInternalObject = new WSDLInvokerInternalObject();
        }
        if (wsdlInvokerInternalObject.getParams() == null) {
            wsdlInvokerInternalObject.setParams(new WSDLInvokerParams());
        }
        String jsonOutput = null;
        this.setEndPoint(wsdlInvokerInternalObject, endPoint);
        this.parseSchemas(wsdlInvokerInternalObject);
        JSONWriter jsonWriter = wsdlInvokerInternalObject.getJsonWriter();
        jsonWriter.array();
        Map allBindings = wsdlInvokerInternalObject.getDefinition().getAllBindings();
        for (Binding binding : allBindings.values()) {
            List list = binding.getExtensibilityElements();
            int length = list.size();
            for (int index = 0; index < length; ++index) {
                if (!(list.get(index) instanceof SOAPBindingImpl)) continue;
                int soapOperationCount = binding.getBindingOperations().size();
                for (int soapOpIndex = 0; soapOpIndex < soapOperationCount; ++soapOpIndex) {
                    BindingOperation bindingOp = (BindingOperation)binding.getBindingOperations().get(soapOpIndex);
                    Operation op = bindingOp.getOperation();
                    String soapAction = WSDLUtils.getSoapActionURI(bindingOp);
                    this.expandOperation(wsdlInvokerInternalObject, op, binding, soapAction);
                }
            }
        }
        jsonWriter.endArray();
        jsonOutput = wsdlInvokerInternalObject.getStrWriter().getBuffer().toString();
        return jsonOutput;
    }

    private void createSOAPParam(SOAPElement inElement, Object object, String namespace) throws Exception {
        block6: {
            try {
                if (object instanceof String) {
                    String paramValue = (String)object;
                    inElement.addTextNode(paramValue);
                    break block6;
                }
                if (object instanceof Number) {
                    Number paramValue = (Number)object;
                    inElement.addTextNode(paramValue.toString());
                    break block6;
                }
                if (object instanceof JSONObject) {
                    JSONObject jsonObject = (JSONObject)object;
                    Iterator keys = jsonObject.keys();
                    while (keys.hasNext()) {
                        String paramName = (String)keys.next();
                        SOAPElement innerElement = inElement.addChildElement(paramName, "", namespace);
                        this.createSOAPParam(innerElement, jsonObject.get(paramName), namespace);
                    }
                    break block6;
                }
                throw new Exception("createSOAPParam: Invalid Params");
            }
            catch (JSONException e) {
                throw new Exception("createSOAPParam: JSONException");
            }
        }
    }

    private void createSOAPMessage(WSDLInvokerInternalObject wsdlInvokerInternalObject, String operationName, String opSoapActionURI, String namespace, JSONObject inputObject) throws Exception {
        SOAPMessage soapMessage;
        try {
            MessageFactory messageFactory = MessageFactory.newInstance();
            soapMessage = wsdlInvokerInternalObject.getMessage();
            soapMessage = messageFactory.createMessage();
            SOAPPart soapPart = soapMessage.getSOAPPart();
            SOAPEnvelope envelope = soapPart.getEnvelope();
            SOAPBody soapBody = envelope.getBody();
            String inputRoot = null;
            String inputRootParam = wsdlInvokerInternalObject.getParams().getOpInputRoot();
            inputRoot = inputRootParam != null && !inputRootParam.isEmpty() ? inputRootParam : operationName;
            SOAPElement soapBodyElem = soapBody.addChildElement(inputRoot, "", namespace);
            this.createSOAPParam(soapBodyElem, inputObject, namespace);
            MimeHeaders headers = soapMessage.getMimeHeaders();
            headers.addHeader("SOAPAction", opSoapActionURI);
            soapMessage.saveChanges();
        }
        catch (SOAPException e) {
            throw new Exception("createSOAPMessage: SOAPException");
        }
        catch (JSONException e) {
            throw new Exception("createSOAPMessage: JSONException");
        }
        if (this.log.isTraceEnabled()) {
            try {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                soapMessage.writeTo((OutputStream)out);
                String strSOAPMessage = new String(out.toByteArray());
                this.log.trace("SOAPMessage: " + strSOAPMessage);
                String dummy = "";
            }
            catch (IOException e) {
            }
            catch (SOAPException e) {
                // empty catch block
            }
        }
        wsdlInvokerInternalObject.setMessage(soapMessage);
    }

    private boolean hasRepeatedSibling(String elementName, Node sibling) {
        return sibling != null && sibling instanceof Element && elementName.equals(sibling.getNodeName());
    }

    private void convertElementToJSON(WSDLInvokerInternalObject wsdlInvokerInternalObject, Element element) throws Exception {
        Node prevSibling = element.getPreviousSibling();
        Node nextSibling = element.getNextSibling();
        if (element.hasChildNodes()) {
            Node child;
            JSONWriter jsonWriter = wsdlInvokerInternalObject.getJsonWriter();
            String keyName = element.getNodeName();
            String trimmedKeyName = keyName.substring(keyName.indexOf(":") + 1);
            if (!this.hasRepeatedSibling(keyName, prevSibling)) {
                jsonWriter.key(trimmedKeyName);
            }
            for (child = element.getFirstChild(); child != null && !(child instanceof Element); child = child.getNextSibling()) {
            }
            if (child != null) {
                if (!this.hasRepeatedSibling(keyName, prevSibling) && this.hasRepeatedSibling(keyName, nextSibling)) {
                    jsonWriter.array();
                }
                jsonWriter.object();
                this.convertElementToJSON(wsdlInvokerInternalObject, (Element)child);
                jsonWriter.endObject();
                if (this.hasRepeatedSibling(keyName, prevSibling) && !this.hasRepeatedSibling(keyName, nextSibling)) {
                    jsonWriter.endArray();
                }
            } else {
                jsonWriter.value((Object)element.getTextContent());
            }
        }
        while (nextSibling != null && !(nextSibling instanceof Element)) {
            nextSibling = nextSibling.getNextSibling();
        }
        if (nextSibling != null && nextSibling instanceof Element) {
            this.convertElementToJSON(wsdlInvokerInternalObject, (Element)nextSibling);
        }
    }

    private String convertSOAPMessageToJSON(WSDLInvokerInternalObject wsdlInvokerInternalObject, SOAPMessage message) throws Exception {
        String jsonStream = null;
        SOAPPart part = message.getSOAPPart();
        SOAPEnvelope envelope = part.getEnvelope();
        SOAPBody body = envelope.getBody();
        Iterator allElements = body.getChildElements();
        JSONWriter jsonWriter = wsdlInvokerInternalObject.getJsonWriter();
        jsonWriter.object();
        while (allElements.hasNext()) {
            Object item = allElements.next();
            if (!(item instanceof Element)) continue;
            this.convertElementToJSON(wsdlInvokerInternalObject, (Element)item);
        }
        jsonWriter.endObject();
        jsonStream = wsdlInvokerInternalObject.getStrWriter().getBuffer().toString();
        return jsonStream;
    }

    private String executeOperationInternal(WSDLInvokerInternalObject wsdlInvokerInternalObject) throws Exception {
        SOAPMessage soapMessage = wsdlInvokerInternalObject.getMessage();
        String wsdlEndPoint = wsdlInvokerInternalObject.getEndPoint();
        String serviceEndPoint = wsdlInvokerInternalObject.getParams().getServiceEndPoint();
        if (soapMessage == null || wsdlEndPoint == null || wsdlEndPoint.isEmpty()) {
            throw new Exception("executeOperationInternal: Invalid Arguments");
        }
        SOAPConnectionFactory soapConnectionFactory = SOAPConnectionFactory.newInstance();
        SOAPConnection soapConnection = soapConnectionFactory.createConnection();
        SOAPMessage soapResponse = soapConnection.call(soapMessage, (Object)serviceEndPoint);
        String jsonOutput = this.convertSOAPMessageToJSON(wsdlInvokerInternalObject, soapResponse);
        if (this.log.isTraceEnabled()) {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            Source sourceContent = soapResponse.getSOAPPart().getContent();
            StringWriter writer = new StringWriter();
            StreamResult result = new StreamResult(writer);
            transformer.transform(sourceContent, result);
            String strMessage = writer.getBuffer().toString();
            this.log.trace("soapResponse: " + strMessage);
        }
        return jsonOutput;
    }

    private boolean getPortIfRequired(WSDLInvokerInternalObject wsdlInvokerInternalObject, String operation) throws Exception {
        String port = wsdlInvokerInternalObject.getParams().getPort();
        if (port == null || port.isEmpty()) {
            port = WSDLUtils.getPortIfUnique(wsdlInvokerInternalObject.getDefinition(), operation);
        }
        boolean result = false;
        if (port != null && !port.isEmpty()) {
            result = true;
        }
        wsdlInvokerInternalObject.getParams().setPort(port);
        return result;
    }

    public String executeOperation(WSDLInvokerInternalObject wsdlInvokerInternalObject, String serverEndPoint, String operation, String jsonInput) throws Exception {
        if (wsdlInvokerInternalObject == null) {
            wsdlInvokerInternalObject = new WSDLInvokerInternalObject();
        }
        if (wsdlInvokerInternalObject.getParams() == null) {
            wsdlInvokerInternalObject.setParams(new WSDLInvokerParams());
        }
        String jsonOutput = null;
        try {
            String namespace;
            String serviceEndPoint;
            this.setEndPoint(wsdlInvokerInternalObject, serverEndPoint);
            String soapActionUri = wsdlInvokerInternalObject.getParams().getOpSoapUri();
            if (soapActionUri == null || soapActionUri.isEmpty()) {
                this.parseSchemas(wsdlInvokerInternalObject);
                if (!this.getPortIfRequired(wsdlInvokerInternalObject, operation)) {
                    throw new Exception("Invalid arguments: Either of soapActionUri or port is required");
                }
                soapActionUri = WSDLUtils.getSoapActionURI(wsdlInvokerInternalObject.getDefinition(), wsdlInvokerInternalObject.getParams().getPort(), operation);
                wsdlInvokerInternalObject.getParams().setOpSoapUri(soapActionUri);
            }
            if ((serviceEndPoint = wsdlInvokerInternalObject.getParams().getServiceEndPoint()) == null || serviceEndPoint.isEmpty()) {
                this.parseSchemas(wsdlInvokerInternalObject);
                if (!this.getPortIfRequired(wsdlInvokerInternalObject, operation)) {
                    throw new Exception("Invalid arguments: Either of serviceEndPoint or port is required");
                }
                serviceEndPoint = WSDLUtils.getServiceEndPointFromPort(wsdlInvokerInternalObject.getDefinition(), wsdlInvokerInternalObject.getParams().getPort());
                wsdlInvokerInternalObject.getParams().setServiceEndPoint(serviceEndPoint);
            }
            if ((namespace = wsdlInvokerInternalObject.getParams().getNamespace()) == null || namespace.isEmpty()) {
                this.parseSchemas(wsdlInvokerInternalObject);
                if (!this.getPortIfRequired(wsdlInvokerInternalObject, operation)) {
                    throw new Exception("Invalid arguments: Either of soapActionUri or port is required");
                }
                namespace = WSDLUtils.getOperationNamespace(wsdlInvokerInternalObject.getDefinition(), wsdlInvokerInternalObject.getSchemaObject(), wsdlInvokerInternalObject.getParams().getPort(), operation);
                wsdlInvokerInternalObject.getParams().setNamespace(namespace);
            }
            JSONObject jsonInputObject = new JSONObject(jsonInput);
            this.createSOAPMessage(wsdlInvokerInternalObject, operation, wsdlInvokerInternalObject.getParams().getOpSoapUri(), wsdlInvokerInternalObject.getParams().getNamespace(), jsonInputObject);
            jsonOutput = this.executeOperationInternal(wsdlInvokerInternalObject);
        }
        catch (SOAPException e) {
            throw new Exception("executeOperation: SOAPException");
        }
        catch (TransformerConfigurationException e) {
            throw new Exception("executeOperation: TransformerConfigurationException");
        }
        catch (TransformerException e) {
            throw new Exception("executeOperation: TransformerException");
        }
        return jsonOutput;
    }

    private class DOMErrorHandler
    implements ErrorHandler {
        private DOMErrorHandler() {
        }

        public void fatalError(SAXParseException exception) throws SAXException {
            boolean dummy = false;
        }

        public void error(SAXParseException exception) throws SAXException {
            boolean dummy = false;
        }

        public void warning(SAXParseException exception) throws SAXException {
            boolean dummy = false;
        }
    }
}

