/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aemfd.wsdl;

import com.adobe.aemfd.wsdl.WSDLInvokerParams;
import com.adobe.aemfd.wsdl.WSDLInvokerService;
import java.io.IOException;
import java.io.PrintWriter;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.apache.sling.commons.json.JSONException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=true, immediate=true, label="Forms WSDL Servlet", description="Servlet for providing WSDL support in Forms")
@Service
@Properties(value={@Property(name="sling.servlet.resourceTypes", value={"fd/af/components/guideContainer"}), @Property(name="sling.servlet.selectors", value={"af.wsdl"}), @Property(name="sling.servlet.methods", value={"POST"})})
public class WSDLInvokerServlet
extends SlingAllMethodsServlet {
    @Reference(referenceInterface=WSDLInvokerService.class)
    private WSDLInvokerService wsdlInvokerService;
    private static final long serialVersionUID = 193653482338551669L;
    private final Logger logger = LoggerFactory.getLogger(WSDLInvokerServlet.class);
    private final String paramFunc = "functionToExecute";
    private final String paramFuncGetAllOperations = "getAllOperations";
    private final String paramFuncInvoke = "invoke";
    private final String paramWSDLEndPoint = "wsdlEndPoint";
    private final String paramOperationName = "operationName";
    private final String paramPORT = "port";
    private final String paramSOAPURI = "soapActionURI";
    private final String paramServiceEndPoint = "serviceEndPoint";
    private final String paramGuideNodePath = "guideNodePath";
    private final String paramOperationInput = "input";
    private final String paramNamespace = "namespace";
    private final String paramInputRoot = "inputRoot";

    private void writeResult(SlingHttpServletResponse response, String output) throws IOException, JSONException {
        PrintWriter writer = response.getWriter();
        writer.write(output);
        writer.close();
    }

    private void getAllOperations(SlingHttpServletRequest request, SlingHttpServletResponse response) throws Exception {
        try {
            String serverEndPoint = request.getParameter("wsdlEndPoint");
            if (serverEndPoint.isEmpty()) {
                throw new UnsupportedOperationException("Invalid Param: wsdlEndPoint empty");
            }
            String jsonOutput = null;
            WSDLInvokerParams params = new WSDLInvokerParams();
            jsonOutput = this.wsdlInvokerService.expandAllOperations(serverEndPoint, params);
            this.writeResult(response, jsonOutput);
        }
        catch (IOException e) {
            throw new Exception("getAllOperations: IOException", e);
        }
        catch (JSONException e) {
            throw new Exception("getAllOperations: JSONException", e);
        }
        catch (Exception e) {
            this.logger.error("Error getAllOperations:", (Throwable)e);
            throw new Exception("getAllOperations: ", e);
        }
    }

    private boolean validateWebServiceEndPoint(SlingHttpServletRequest request, String guideNodePath, String webServiceEndPoint) {
        if (webServiceEndPoint == null || webServiceEndPoint.isEmpty() || guideNodePath == null || guideNodePath.isEmpty()) {
            return false;
        }
        String[] eventProperties = new String[]{"calcExp", "visibleExp", "initScript", "clickExp", "valueCommitScript", "enabledExp", "validateExp", "completionExp", "summaryExp", "optionsExp", "navigationChangeExp"};
        Resource guideContainerResource = request.getResourceResolver().getResource(guideNodePath);
        ValueMap valueMap = ResourceUtil.getValueMap(guideContainerResource);
        String requiredWSDLKeyValueStr = "\"wsdlEndPoint\":\"" + webServiceEndPoint + "\"";
        boolean whiteListed = false;
        for (int index = 0; !whiteListed && index < eventProperties.length; ++index) {
            String scriptWithoutSpaces;
            String finalScript;
            String script = (String)valueMap.get(eventProperties[index]);
            if (script == null || script.isEmpty() || (finalScript = (scriptWithoutSpaces = script.replaceAll("\\s", "")).replaceAll("\\\\", "")) == null || finalScript.isEmpty()) continue;
            whiteListed = finalScript.contains(requiredWSDLKeyValueStr);
        }
        return whiteListed;
    }

    private void invoke(SlingHttpServletRequest request, SlingHttpServletResponse response) throws Exception {
        String serverEndPoint = request.getParameter("wsdlEndPoint");
        if (serverEndPoint.isEmpty()) {
            throw new UnsupportedOperationException("Invalid Param: wsdlEndPoint empty");
        }
        String operationName = request.getParameter("operationName");
        if (operationName.isEmpty()) {
            throw new UnsupportedOperationException("Invalid Param: " + operationName + " empty");
        }
        String operationInput = request.getParameter("input");
        if (operationInput.isEmpty()) {
            throw new UnsupportedOperationException("Invalid Param: input empty");
        }
        String operationSoapURI = request.getParameter("soapActionURI");
        String namespace = request.getParameter("namespace");
        String port = request.getParameter("port");
        String inputRoot = request.getParameter("inputRoot");
        String serviceEndPoint = request.getParameter("serviceEndPoint");
        String guideNodePath = request.getParameter("guideNodePath");
        if (!this.validateWebServiceEndPoint(request, guideNodePath, serverEndPoint)) {
            throw new UnsupportedOperationException("Invalid Param");
        }
        WSDLInvokerParams params = new WSDLInvokerParams();
        params.setPort(port);
        params.setOpSoapUri(operationSoapURI);
        params.setNamespace(namespace);
        params.setOpInputRoot(inputRoot);
        params.setServiceEndPoint(serviceEndPoint);
        String jsonOutput = this.wsdlInvokerService.executeOperation(serverEndPoint, operationName, operationInput, params);
        this.writeResult(response, jsonOutput);
    }

    public void doPost(SlingHttpServletRequest request, SlingHttpServletResponse response) {
        try {
            String functionToExecute = request.getParameter("functionToExecute");
            if (functionToExecute.isEmpty()) {
                throw new Exception("doPost: Invalid Param");
            }
            if (functionToExecute.compareToIgnoreCase("getAllOperations") == 0) {
                this.getAllOperations(request, response);
            } else if (functionToExecute.compareToIgnoreCase("invoke") == 0) {
                this.invoke(request, response);
            }
        }
        catch (Exception e) {
            this.logger.error("Error while making web service related call");
        }
    }

    public void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) {
        throw new UnsupportedOperationException("GET is not supported on this endpoint");
    }

    protected void bindWsdlInvokerService(WSDLInvokerService wSDLInvokerService) {
        this.wsdlInvokerService = wSDLInvokerService;
    }

    protected void unbindWsdlInvokerService(WSDLInvokerService wSDLInvokerService) {
        if (this.wsdlInvokerService == wSDLInvokerService) {
            this.wsdlInvokerService = null;
        }
    }
}

