/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.commerce.common;

import aQute.bnd.annotation.ConsumerType;
import com.adobe.cq.commerce.api.CommerceException;
import com.adobe.cq.commerce.api.CommerceService;
import com.adobe.cq.commerce.api.Product;
import com.adobe.cq.commerce.api.VariantFilter;
import com.adobe.cq.commerce.api.asset.ProductAssetManager;
import com.day.cq.commons.ImageResource;
import com.day.cq.commons.inherit.ComponentInheritanceValueMap;
import com.day.cq.commons.inherit.HierarchyNodeInheritanceValueMap;
import com.day.cq.commons.inherit.InheritanceValueMap;
import com.day.cq.dam.api.Asset;
import com.day.cq.dam.commons.util.DamUtil;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.net.URLCodec;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.adapter.SlingAdaptable;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ConsumerType
public abstract class AbstractJcrProduct
extends SlingAdaptable
implements Product {
    private static final String[] IMG_MIME_TYPES = new String[]{"image/png", "image/jpeg", "image/tiff", "image/png", "image/bmp", "image/gif", "image/pipeg", "image/x-portable-anymap", "image/x-portable-bitmap", "image/x-portable-graymap", "image/x-portable-pixmap", "image/x-rgb", "image/x-xbitmap", "image/x-xpixmap", "image/x-icon", "image/photoshop", "image/x-photoshop", "image/psd", "application/photoshop", "application/psd", "image/vnd.adobe.photoshop"};
    private static final List<String> IMG_MIME_TYPE = Arrays.asList(IMG_MIME_TYPES);
    protected static final String PN_PRODUCT_TYPE = "cq:commerceType";
    protected static final String PN_PRODUCT_VARIANT_AXES = "cq:productVariantAxes";
    protected static final String PN_PRODUCT_DATA = "productData";
    protected static final String PN_PRODUCT_TITLE = "jcr:title";
    protected static final String PN_PRODUCT_DESCRIPTION = "jcr:description";
    protected static final String PN_PRODUCT_ASSET_CATEGORY = "assetCategory";
    protected static final Logger log = LoggerFactory.getLogger(AbstractJcrProduct.class);
    protected Resource resource;
    protected Product baseProduct;
    protected ProductAssetManager productAssetManager;

    public AbstractJcrProduct(Resource resource) {
        this.resource = resource;
        this.productAssetManager = resource.getResourceResolver().adaptTo(ProductAssetManager.class);
    }

    @Override
    public String getPath() {
        return this.resource.getPath();
    }

    @Override
    public String getPagePath() {
        PageManager pm = this.resource.getResourceResolver().adaptTo(PageManager.class);
        Page page = pm.getContainingPage(this.resource);
        return page != null ? page.getPath() + ".html#" + this.getSKU() : null;
    }

    @Override
    public String getTitle() {
        return this.getProperty(PN_PRODUCT_TITLE, String.class);
    }

    @Override
    public String getTitle(String selectorString) {
        return this.getProperty(PN_PRODUCT_TITLE, selectorString, String.class);
    }

    @Override
    public String getDescription() {
        return this.getProperty(PN_PRODUCT_DESCRIPTION, String.class);
    }

    @Override
    public String getDescription(String selectorString) {
        return this.getProperty(PN_PRODUCT_DESCRIPTION, selectorString, String.class);
    }

    @Override
    @Deprecated
    public String getImagePath() {
        ImageResource image = this.getImage();
        if (image != null) {
            return image.getPath();
        }
        return "";
    }

    @Override
    @Deprecated
    public String getImageUrl() {
        return this.getImagePath();
    }

    @Override
    @Deprecated
    public ImageResource getThumbnail() {
        ImageResource thumbnail = this.getImage();
        if (thumbnail != null) {
            thumbnail.setSelector(".thumbnail");
        }
        return thumbnail;
    }

    @Override
    public String getThumbnailUrl() {
        return this.getThumbnailUrl("");
    }

    @Override
    public String getThumbnailUrl(int width) {
        String selector = Integer.toString(width);
        return this.getThumbnailUrl(selector);
    }

    @Override
    public String getThumbnailUrl(String selectorString) {
        String[] stringArray;
        if (selectorString != null) {
            stringArray = selectorString.split("\\.");
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "";
        }
        String[] selectors = stringArray;
        Resource assetRes = Arrays.asList(selectors).contains("image") ? this.getImage() : this.getAsset();
        return assetRes == null ? null : this.productAssetManager.getThumbnailUrl(assetRes.getPath(), selectorString);
    }

    @Override
    public ImageResource getImage() {
        Resource image = this.getAsset(IMG_MIME_TYPE);
        if (image != null) {
            return new ImageResource(image);
        }
        return null;
    }

    @Override
    public Resource getAsset() {
        return this.getAsset(null);
    }

    protected Resource getAsset(List<String> mimeTypes) {
        List<Resource> assets = this.getAssets(mimeTypes);
        if (assets.size() == 1) {
            return assets.get(0);
        }
        if (assets.size() > 1) {
            PageManager pm;
            Page page;
            String assetCategoryToDisplay = (String)((Object)this.resource.getValueMap().get(PN_PRODUCT_ASSET_CATEGORY, String.class));
            if (StringUtils.isEmpty((String)assetCategoryToDisplay) && AbstractJcrProduct.isAVariant(this.resource)) {
                try {
                    this.baseProduct = this.getBaseProduct();
                    if (this.baseProduct != null) {
                        assetCategoryToDisplay = this.baseProduct.getProperty(PN_PRODUCT_ASSET_CATEGORY, String.class);
                    }
                }
                catch (CommerceException e) {
                    log.error("Error while retrieving the base product.", (Throwable)e);
                }
            }
            if (StringUtils.isEmpty((String)assetCategoryToDisplay) && (page = (pm = this.resource.getResourceResolver().adaptTo(PageManager.class)).getContainingPage(this.resource)) != null) {
                Resource pageContent = page.getContentResource();
                HierarchyNodeInheritanceValueMap dataMap = new HierarchyNodeInheritanceValueMap(pageContent);
                assetCategoryToDisplay = (String)((Object)dataMap.getInherited(PN_PRODUCT_ASSET_CATEGORY, String.class));
            }
            if (StringUtils.isEmpty((String)assetCategoryToDisplay)) {
                assetCategoryToDisplay = this.getProperty(PN_PRODUCT_ASSET_CATEGORY, String.class);
            }
            for (Resource asset : assets) {
                String category = (String)((Object)asset.getValueMap().get(PN_PRODUCT_ASSET_CATEGORY, String.class));
                if (!StringUtils.isNotEmpty((String)category) || !category.equals(assetCategoryToDisplay)) continue;
                return asset;
            }
            return assets.get(0);
        }
        return null;
    }

    @Override
    public List<ImageResource> getImages() {
        ArrayList<ImageResource> result = new ArrayList<ImageResource>();
        List<Resource> images = this.getAssets(IMG_MIME_TYPE);
        if (images == null || images.isEmpty()) {
            return result;
        }
        for (Resource assetRes : images) {
            result.add(new ImageResource(assetRes));
        }
        return result;
    }

    @Override
    public List<Resource> getAssets() {
        Resource ancestor;
        List<Resource> assets = this.getAssets(this.resource);
        if (assets.size() > 0) {
            return assets;
        }
        String productDataPath = (String)((Object)this.resource.getValueMap().get(PN_PRODUCT_DATA, String.class));
        if (StringUtils.isNotEmpty((String)productDataPath)) {
            ancestor = this.resource.getResourceResolver().getResource(productDataPath);
            if (ancestor == null) {
                log.warn("Product data not found at [{}].", (Object)productDataPath);
                return Collections.emptyList();
            }
        } else {
            ancestor = this.resource.getParent();
        }
        while (ancestor != null && AbstractJcrProduct.isAProductOrVariant(ancestor)) {
            assets = this.getAssets(ancestor);
            if (assets.size() > 0) {
                return assets;
            }
            ancestor = ancestor.getParent();
        }
        return Collections.emptyList();
    }

    public List<Resource> getAssets(List<String> mimeTypes) {
        List<Resource> assets = this.getAssets();
        return this.filterResources(assets, mimeTypes);
    }

    protected List<Resource> getAssets(Resource resource) {
        Resource assetsResource;
        ArrayList<Resource> result = new ArrayList<Resource>();
        Resource legacyImageResource = resource.getChild("image");
        if (legacyImageResource != null) {
            result.add(legacyImageResource);
        }
        if ((assetsResource = resource.getChild("assets")) != null) {
            Iterator<Resource> assets = assetsResource.listChildren();
            while (assets.hasNext()) {
                result.add(assets.next());
            }
        }
        return result;
    }

    protected List<Resource> getAssets(Resource resource, List<String> mimeTypes) {
        List<Resource> assets = this.getAssets(resource);
        return this.filterResources(assets, mimeTypes);
    }

    private List<Resource> filterResources(List<Resource> assetResources, List<String> mimeTypes) {
        ArrayList<Resource> result = new ArrayList<Resource>();
        if (assetResources == null || assetResources.isEmpty()) {
            return result;
        }
        if (mimeTypes == null || mimeTypes.isEmpty()) {
            return assetResources;
        }
        for (Resource assetRes : assetResources) {
            String assetReference = this.productAssetManager.getReferencedAsset(assetRes.getPath());
            Asset asset = this.mapToAsset(assetReference);
            if (asset == null || !mimeTypes.contains(asset.getMimeType())) continue;
            result.add(assetRes);
        }
        return result;
    }

    private Asset mapToAsset(String assetReference) {
        if (StringUtils.isEmpty((String)assetReference)) {
            return null;
        }
        try {
            assetReference = new URLCodec().decode(assetReference);
        }
        catch (DecoderException e) {
            log.error("Error while decoding fileReference: {}", (Object)assetReference);
        }
        Resource assetRes = this.resource.getResourceResolver().getResource(assetReference);
        if (assetRes == null) {
            return null;
        }
        return DamUtil.resolveToAsset(assetRes);
    }

    protected List<ImageResource> getImages(Resource resource) {
        ArrayList<ImageResource> result = new ArrayList<ImageResource>();
        List<Resource> images = this.getAssets(resource, IMG_MIME_TYPE);
        if (images == null || images.isEmpty()) {
            return result;
        }
        for (Resource assetRes : images) {
            result.add(new ImageResource(assetRes));
        }
        return result;
    }

    @Override
    public <T> T getProperty(String name, Class<T> type) {
        Resource ancestor;
        ValueMap properties = this.resource.getValueMap();
        if (properties.containsKey(name)) {
            return (T)properties.get(name, type);
        }
        if (properties.containsKey(PN_PRODUCT_DATA)) {
            String productDataPath = (String)((Object)properties.get(PN_PRODUCT_DATA, String.class));
            ancestor = this.resource.getResourceResolver().getResource(productDataPath);
            if (ancestor == null) {
                log.warn("Product data not found at [{}].", (Object)productDataPath);
                return null;
            }
        } else {
            ancestor = this.resource.getParent();
        }
        return (T)new ComponentInheritanceValueMap(ancestor).getInherited(name, type);
    }

    @Override
    public <T> T getProperty(String name, String selectorString, Class<T> type) {
        T selectorSpecificValue;
        if (StringUtils.isNotEmpty((String)selectorString) && (selectorSpecificValue = this.getProperty(name + "." + selectorString, type)) != null) {
            return selectorSpecificValue;
        }
        return this.getProperty(name, type);
    }

    @Override
    public Iterator<Product> getVariants() throws CommerceException {
        return this.getVariants(null);
    }

    @Override
    public boolean axisIsVariant(String axis) {
        Iterator<String> axes = this.getVariantAxes();
        while (axes.hasNext()) {
            if (!axes.next().equals(axis)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator<Product> getVariants(VariantFilter filter) throws CommerceException {
        ArrayList<Product> variants = new ArrayList<Product>();
        this.collectVariants(this.getBaseProduct(), filter, variants);
        return variants.iterator();
    }

    @Override
    public Iterator<String> getVariantAxes() {
        String[] axes = this.getProperty(PN_PRODUCT_VARIANT_AXES, String[].class);
        if (axes != null) {
            return Arrays.asList(axes).iterator();
        }
        return new ArrayList().iterator();
    }

    @Override
    public Product getBaseProduct() throws CommerceException {
        if (this.baseProduct == null) {
            if (!AbstractJcrProduct.isAProductOrVariant(this.resource)) {
                log.error("Node isn't a product: " + this.resource.getPath());
                return null;
            }
            Resource tempResource = this.resource;
            while (AbstractJcrProduct.isAVariant(tempResource)) {
                tempResource = tempResource.getParent();
            }
            if (AbstractJcrProduct.isABaseProduct(tempResource)) {
                CommerceService service = tempResource.adaptTo(CommerceService.class);
                this.baseProduct = service.getProduct(tempResource.getPath());
            } else {
                log.error("Variant product node [{}] didn't have a product parent.", (Object)this.resource.getPath());
                return null;
            }
        }
        return this.baseProduct;
    }

    @Override
    public Product getPIMProduct() throws CommerceException {
        String productDataPath = (String)((Object)this.resource.getValueMap().get(PN_PRODUCT_DATA, String.class));
        if (StringUtils.isNotEmpty((String)productDataPath)) {
            Resource productData = this.resource.getResourceResolver().getResource(productDataPath);
            if (productData == null) {
                log.warn("Product data not found at [{}].", (Object)productDataPath);
                return null;
            }
            return productData.adaptTo(Product.class);
        }
        return null;
    }

    public static boolean isAVariant(Resource resource) {
        return resource.getValueMap().get(PN_PRODUCT_TYPE, "").equals("variant");
    }

    public static boolean isABaseProduct(Resource resource) {
        return resource.getValueMap().get(PN_PRODUCT_TYPE, "").equals("product");
    }

    public static boolean isAProductOrVariant(Resource resource) {
        String commerceType = resource.getValueMap().get(PN_PRODUCT_TYPE, "");
        return commerceType.equals("product") || commerceType.equals("variant");
    }

    protected void collectVariants(Product p, VariantFilter filter, List<Product> variants) {
        boolean isLeaf = true;
        Iterator<Resource> i = this.resource.getResourceResolver().listChildren(p.adaptTo(Resource.class));
        while (i != null && i.hasNext()) {
            Resource child = i.next();
            if (!AbstractJcrProduct.isAVariant(child)) continue;
            isLeaf = false;
            this.collectVariants(child.adaptTo(Product.class), filter, variants);
        }
        if (isLeaf && (filter == null || filter.includes(p))) {
            variants.add(p);
        }
    }

    @Override
    public <AdapterType> AdapterType adaptTo(Class<AdapterType> type) {
        if (type == Resource.class) {
            return (AdapterType)this.resource;
        }
        if (type == InheritanceValueMap.class) {
            return (AdapterType)new ComponentInheritanceValueMap(this.resource);
        }
        AdapterType ret = super.adaptTo(type);
        if (ret == null) {
            ret = this.resource.adaptTo(type);
        }
        return ret;
    }

    public boolean equals(Object obj) {
        return obj instanceof Product && ((Product)obj).getPath().equals(this.getPath());
    }

    public int hashCode() {
        return this.getPath().hashCode();
    }
}

