/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.commerce.common;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.net.URLCodec;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpMethod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CookieUtil {
    private static final Logger log = LoggerFactory.getLogger(CookieUtil.class);
    private static final URLCodec urlCodec = new URLCodec();
    private static final String HTTP_HEADER_SET_COOKIE = "Set-Cookie";
    private static final String URL_HOST_REGEX = "https?://([\\w\\d_\\.\\-]*)(:\\d+)?(/.*)?";
    public static final String SESSION_COOKIE = "JSESSIONID";
    public static final boolean HTTP_ONLY = true;

    public static void setCookie(HttpServletRequest request, HttpServletResponse response, String name, String value, int maxAge, boolean httpOnly) {
        StringBuilder header = new StringBuilder();
        header.append(name).append("=").append(value);
        String contextPath = request.getContextPath();
        String cookiePath = contextPath == null || contextPath.length() == 0 ? "/" : contextPath;
        header.append("; Path=").append(cookiePath);
        if (maxAge >= 0) {
            header.append("; Max-Age=").append(maxAge);
        }
        if (httpOnly) {
            header.append("; HttpOnly");
        }
        if (request.isSecure()) {
            header.append("; Secure");
        }
        response.addHeader(HTTP_HEADER_SET_COOKIE, header.toString());
    }

    public static String hostFromUrl(String url) {
        Matcher matcher = Pattern.compile(URL_HOST_REGEX).matcher(url);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return null;
    }

    @Deprecated
    public static List<Cookie> getSessionCookies(HttpServletRequest request, String prefix, String remoteHost) {
        javax.servlet.http.Cookie[] requestCookies = request.getCookies();
        ArrayList<Cookie> cookies = new ArrayList<Cookie>();
        try {
            if (requestCookies != null) {
                for (javax.servlet.http.Cookie c : requestCookies) {
                    if (!c.getName().startsWith(prefix)) continue;
                    String[] values = urlCodec.decode(c.getValue()).split(";");
                    cookies.add(new Cookie(remoteHost, SESSION_COOKIE, values[0], values[1], c.getMaxAge(), c.getSecure()));
                }
            }
        }
        catch (Exception e) {
            log.error("Could not get jcrSession cookies from request: ", (Throwable)e);
            return new ArrayList<Cookie>();
        }
        return cookies;
    }

    @Deprecated
    public static void setSessionCookies(HttpServletResponse response, String prefix, List<Cookie> cookies) {
        try {
            for (Cookie c : cookies) {
                String value = urlCodec.encode(c.getValue() + ";" + c.getPath());
                javax.servlet.http.Cookie cookie = new javax.servlet.http.Cookie(prefix + c.getPath().substring(1), value);
                cookie.setPath("/");
                response.addCookie(cookie);
            }
        }
        catch (Exception e) {
            log.error("Could not set jcrSession cookies on response: ", (Throwable)e);
        }
    }

    @Deprecated
    public static boolean hasUpdatedSessionCookies(HttpMethod method) {
        if (method.hasBeenUsed()) {
            Header[] headers = method.getResponseHeaders(HTTP_HEADER_SET_COOKIE);
            for (int i = 0; i < headers.length; ++i) {
                if (!headers[i].getValue().contains(SESSION_COOKIE)) continue;
                return true;
            }
        }
        return false;
    }

    @Deprecated
    public static boolean hasSessionCookie(List<Cookie> cookies) {
        for (Cookie c : cookies) {
            if (!c.getName().equals(SESSION_COOKIE)) continue;
            return true;
        }
        return false;
    }
}

