/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.commerce.common;

import com.adobe.cq.commerce.api.CommerceException;
import com.adobe.cq.commerce.api.CommerceSession;
import com.adobe.cq.commerce.api.PriceInfo;
import com.adobe.cq.commerce.api.Product;
import com.adobe.cq.commerce.common.PriceFilter;
import com.adobe.cq.commerce.common.ValueMapDecorator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.sling.api.resource.ValueMap;

public class DefaultJcrCartEntry
implements CommerceSession.CartEntry {
    private int index;
    private Product product;
    private int quantity;
    private List<PriceInfo> prices;
    private ValueMap properties;

    public DefaultJcrCartEntry(int index, Product product, int quantity) {
        this.index = index;
        this.product = product;
        this.quantity = quantity;
        this.properties = new ValueMapDecorator(new HashMap<String, Object>());
    }

    @Override
    public int getEntryIndex() {
        return this.index;
    }

    public void setEntryIndex(int index) {
        this.index = index;
    }

    @Override
    public Product getProduct() throws CommerceException {
        return this.product;
    }

    @Override
    public int getQuantity() {
        return this.quantity;
    }

    public void setQuantity(int quantity) {
        this.quantity = quantity;
    }

    @Override
    public List<PriceInfo> getPriceInfo(Predicate filter) throws CommerceException {
        if (filter != null) {
            ArrayList<PriceInfo> filtered = new ArrayList<PriceInfo>();
            CollectionUtils.select(this.prices, (Predicate)filter, filtered);
            return filtered;
        }
        return this.prices;
    }

    @Override
    public String getPrice(Predicate filter) throws CommerceException {
        List<PriceInfo> filtered = this.getPriceInfo(filter);
        if (filtered != null && filtered.size() > 0) {
            return filtered.get(0).getFormattedString();
        }
        return "";
    }

    public void setPrice(PriceInfo priceInfo, String ... types) {
        if (this.prices == null) {
            this.prices = new ArrayList<PriceInfo>();
        }
        ArrayList<String> typeList = new ArrayList<String>(Arrays.asList(types));
        typeList.add(priceInfo.getCurrency().getCurrencyCode());
        int index = this.prices.size();
        for (int i = 0; i < this.prices.size(); ++i) {
            PriceInfo price = this.prices.get(i);
            Set priceTypes = (Set)price.get("com.adobe.cq.commerce.common.PriceFilter.types");
            if (!CollectionUtils.isEqualCollection((Collection)priceTypes, typeList)) continue;
            index = i;
            break;
        }
        priceInfo.put("com.adobe.cq.commerce.common.PriceFilter.types", (Object)new HashSet<String>(typeList));
        if (index == this.prices.size()) {
            this.prices.add(priceInfo);
        } else {
            this.prices.set(index, priceInfo);
        }
    }

    @Override
    public <T> T getProperty(String name, Class<T> type) {
        return (T)(this.properties == null ? null : this.properties.get(name, type));
    }

    protected void updateProperties(Map<String, Object> propertyMap) {
        Object value;
        String key;
        if (propertyMap == null) {
            return;
        }
        HashMap<String, Object> internalMap = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : propertyMap.entrySet()) {
            key = entry.getKey();
            value = entry.getValue();
            if ("quantity".equals(key)) {
                if (value == null) {
                    this.setQuantity(0);
                    continue;
                }
                if (value instanceof Number) {
                    this.setQuantity(((Number)value).intValue());
                    continue;
                }
                try {
                    this.setQuantity(Double.valueOf(String.valueOf(value)).intValue());
                }
                catch (NumberFormatException x) {}
                continue;
            }
            if (key == null) continue;
            internalMap.put(key, value);
        }
        if (internalMap.isEmpty()) {
            return;
        }
        if (this.properties.isEmpty()) {
            this.properties = new ValueMapDecorator(internalMap);
        } else {
            for (Map.Entry<String, Object> entry : internalMap.entrySet()) {
                key = entry.getKey();
                value = entry.getValue();
                if (value == null) {
                    this.properties.remove(key);
                    continue;
                }
                this.properties.put(key, value);
            }
        }
    }

    public ValueMap getProperties() {
        return this.properties;
    }

    @Override
    @Deprecated
    public String getUnitPrice() {
        try {
            return this.getPriceInfo(new PriceFilter("UNIT")).get(0).getFormattedString();
        }
        catch (CommerceException e) {
            return "";
        }
    }

    @Override
    @Deprecated
    public String getPreTaxPrice() {
        try {
            return this.getPriceInfo(new PriceFilter("LINE", "PRE_TAX")).get(0).getFormattedString();
        }
        catch (CommerceException e) {
            return "";
        }
    }

    @Override
    @Deprecated
    public String getTax() {
        try {
            return this.getPriceInfo(new PriceFilter("LINE", "TAX")).get(0).getFormattedString();
        }
        catch (CommerceException e) {
            return "";
        }
    }

    @Override
    @Deprecated
    public String getTotalPrice() {
        try {
            return this.getPriceInfo(new PriceFilter("LINE", "POST_TAX")).get(0).getFormattedString();
        }
        catch (CommerceException e) {
            return "";
        }
    }
}

