/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.commerce.pim.common;

import aQute.bnd.annotation.ConsumerType;
import com.adobe.cq.commerce.pim.api.ProductImporter;
import com.adobe.cq.commerce.pim.common.AbstractImporter;
import com.day.cq.commons.jcr.JcrUtil;
import java.io.IOException;
import java.util.Calendar;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.servlet.ServletException;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.jackrabbit.util.Text;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(componentAbstract=true, metatype=true)
@Service
@ConsumerType
public abstract class AbstractProductImporter
extends AbstractImporter
implements ProductImporter {
    private static final Logger log = LoggerFactory.getLogger(AbstractProductImporter.class);
    protected String basePath = "/etc/commerce/products";
    private int BUCKET_MAX;
    private static final int DEFAULT_BUCKET_SIZE = 500;
    @Property(label="Bucket Size", description="Maximum products per section before bucketing, and maximum in each bucket", intValue={500})
    public static final String BUCKET_SIZE_PROP_NAME = "cq.commerce.productimporter.bucketsize";
    protected String NN_BUCKET = "bucket";
    protected String NT_BUCKET = "sling:Folder";
    private int productCount;
    private int variationCount;

    @Override
    @Activate
    protected void activate(ComponentContext ctx) throws Exception {
        super.activate(ctx);
        this.BUCKET_MAX = PropertiesUtil.toInteger(ctx.getProperties().get(BUCKET_SIZE_PROP_NAME), 500);
    }

    @Override
    public void importProducts(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        long startTime = System.currentTimeMillis();
        if (!this.validateInput(request, response)) {
            return;
        }
        ResourceResolver resourceResolver = request.getResourceResolver();
        Session session = resourceResolver.adaptTo(Session.class);
        String storeName = request.getParameter("storeName");
        String storePath = request.getParameter("storePath");
        String provider = request.getParameter("provider");
        this.initTicker(request.getParameter("tickertoken"), session);
        Boolean incrementalImport = false;
        if (request.getParameter("incrementalImport") != null) {
            incrementalImport = true;
        }
        this.productCount = 0;
        this.variationCount = 0;
        this.run(resourceResolver, storePath != null ? storePath : this.basePath, storeName, incrementalImport, provider);
        long millis = System.currentTimeMillis() - startTime;
        long seconds = millis / 1000L;
        if (seconds > 120L) {
            log.info("Imported " + this.productCount + " products in " + seconds / 60L + " minutes.");
        } else {
            log.info("Imported " + this.productCount + " products in " + seconds + " seconds.");
        }
        String summary = this.productCount + " products and " + this.variationCount + " variants created/updated.";
        if (this.getErrorCount() > 0) {
            summary = summary + " " + this.getErrorCount() + " errors encountered.";
        }
        this.respondWithMessages(response, summary);
    }

    protected abstract boolean validateInput(SlingHttpServletRequest var1, SlingHttpServletResponse var2) throws IOException;

    private void demoteProductChildrenToBucket(Node parent, Session session) throws RepositoryException {
        Node bucket = JcrUtil.createUniqueNode(parent, this.NN_BUCKET, this.NT_BUCKET, session);
        NodeIterator children = parent.getNodes();
        long productCount = 0L;
        while (children.hasNext()) {
            Node child = (Node)children.next();
            if (!child.hasProperty("cq:commerceType") || !child.getProperty("cq:commerceType").getString().equals("product")) continue;
            String oldPath = child.getPath();
            String newPath = JcrUtil.copy(child, bucket, child.getName()).getPath();
            child.remove();
            this.updateLoggedEvents(oldPath, newPath);
            ++productCount;
        }
        bucket.setProperty("cq:importCount", productCount);
        parent.setProperty("cq:importCount", (Value)null);
    }

    protected Node createProduct(String path, Session session) throws RepositoryException {
        long count;
        String parentPath = Text.getRelativeParent(path, 1);
        Node parent = JcrUtil.createPath(parentPath, false, "sling:Folder", "sling:Folder", session, false);
        boolean bucketing = false;
        if (parent.hasProperty("cq:importBucket")) {
            parent = parent.getNode(parent.getProperty("cq:importBucket").getString());
            bucketing = true;
        }
        long l = count = parent.hasProperty("cq:importCount") ? parent.getProperty("cq:importCount").getLong() + 1L : 1L;
        if (count > (long)this.BUCKET_MAX) {
            if (!bucketing) {
                this.demoteProductChildrenToBucket(parent, session);
            } else {
                parent = parent.getParent();
            }
            Node bucket = JcrUtil.createUniqueNode(parent, this.NN_BUCKET, this.NT_BUCKET, session);
            parent.setProperty("cq:importBucket", bucket.getName());
            parent = bucket;
            count = 1L;
        }
        parent.setProperty("cq:importCount", count);
        Node product = JcrUtil.createUniqueNode(parent, Text.getName(path), "nt:unstructured", session);
        product.setProperty("cq:commerceType", "product");
        product.setProperty("sling:resourceType", "commerce/components/product");
        product.setProperty("jcr:lastModified", Calendar.getInstance());
        ++this.productCount;
        this.logEvent("com/adobe/cq/commerce/pim/PRODUCT_ADDED", product.getPath());
        this.logMessage("Created product   " + product.getPath(), false);
        this.updateTicker(this.makeTickerMessage());
        this.checkpoint(session, false);
        return product;
    }

    protected String makeTickerMessage() {
        return this.productCount + " products imported/updated";
    }

    protected void productUpdated(Node product) throws RepositoryException {
        ++this.productCount;
        this.logEvent("com/adobe/cq/commerce/pim/PRODUCT_MODIFIED", product.getPath());
        this.logMessage("Updated product   " + product.getPath(), false);
        this.updateTicker(this.makeTickerMessage());
        this.checkpoint(product.getSession(), false);
    }

    protected void productDeleted(Node product) throws RepositoryException {
        this.logEvent("com/adobe/cq/commerce/pim/PRODUCT_DELETED", product.getPath());
        this.logMessage("Deleted product " + product.getPath(), false);
        this.updateTicker(this.makeTickerMessage());
        this.checkpoint(product.getSession(), false);
    }

    protected Node createVariant(Node parentProduct, String name) throws RepositoryException {
        Node variant = JcrUtil.createUniqueNode(parentProduct, name, "nt:unstructured", parentProduct.getSession());
        variant.setProperty("cq:commerceType", "variant");
        variant.setProperty("sling:resourceType", "commerce/components/product");
        variant.setProperty("jcr:lastModified", Calendar.getInstance());
        ++this.variationCount;
        Node baseProduct = this.getBaseProduct(parentProduct);
        if (baseProduct != null) {
            this.logEvent("com/adobe/cq/commerce/pim/PRODUCT_MODIFIED", baseProduct.getPath());
        }
        this.logMessage("Created variation " + variant.getPath(), false);
        this.checkpoint(parentProduct.getSession(), false);
        return variant;
    }

    protected void variantUpdated(Node variant) throws RepositoryException {
        ++this.variationCount;
        Node baseProduct = this.getBaseProduct(variant);
        if (baseProduct != null) {
            this.logEvent("com/adobe/cq/commerce/pim/PRODUCT_MODIFIED", baseProduct.getPath());
        }
        this.logMessage("Updated variation " + variant.getPath(), false);
        this.updateTicker(this.makeTickerMessage());
        this.checkpoint(variant.getSession(), false);
    }

    protected Node createImage(Node product) throws RepositoryException {
        Node image = product.addNode("image", "nt:unstructured");
        image.setProperty("sling:resourceType", "commerce/components/product/image");
        image.setProperty("jcr:lastModified", Calendar.getInstance());
        Node baseProduct = this.getBaseProduct(product);
        if (baseProduct != null) {
            this.logEvent("com/adobe/cq/commerce/pim/PRODUCT_MODIFIED", baseProduct.getPath());
        }
        this.logMessage("Created image     " + image.getPath(), false);
        this.checkpoint(product.getSession(), false);
        return image;
    }

    protected Node getBaseProduct(Node node) throws RepositoryException {
        while (node != null && !node.getProperty("cq:commerceType").getString().equals("product")) {
            node = node.getParent();
        }
        return node;
    }
}

