/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.contentinsight;

import com.day.cq.personalization.TargetedContentManager;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.api.resource.AbstractResourceVisitor;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.commons.json.JSONArray;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActivityResourceVisitor
extends AbstractResourceVisitor {
    private static final Logger log = LoggerFactory.getLogger(ActivityResourceVisitor.class);
    private static final String PN_PUBLISH_CAMPAIGN_ID = "publishCampaignId";
    private static final String TARGET_COMPONENT = "cq/personalization/components/target";
    private List<Resource> activities = new ArrayList<Resource>();
    private String pagePath = "";
    private TargetedContentManager targetedContentManager;

    public ActivityResourceVisitor(String pagePath, TargetedContentManager targetedContentManager) {
        if (!pagePath.endsWith("jcr:content")) {
            pagePath = pagePath + "/jcr:content";
        }
        this.pagePath = pagePath;
        this.targetedContentManager = targetedContentManager;
        if (targetedContentManager == null) {
            log.warn("No TargetedContentManager available, will not be able to determine campaigns used on the current page!");
        }
    }

    @Override
    protected void visit(Resource res) {
        ValueMap properties = ResourceUtil.getValueMap(res);
        if (ResourceUtil.isA(res, "cq/personalization/components/campaignpage") && properties.get(PN_PUBLISH_CAMPAIGN_ID, String.class) != null && this.matchesPage(res)) {
            this.activities.add(res);
        }
    }

    public List<Resource> getActivityResources() {
        return this.activities;
    }

    private boolean matchesPage(Resource campaignResource) {
        boolean matchesPage = false;
        ResourceResolver resolver = campaignResource.getResourceResolver();
        Resource pageRes = resolver.getResource(this.pagePath);
        if (pageRes != null && campaignResource != null) {
            String campaignPathPrefix = campaignResource.getParent().getPath() + "/";
            List<Resource> targetResources = this.getTargetComponents(pageRes, null);
            try {
                block2: for (Resource targetResource : targetResources) {
                    ValueMap targetResProps = targetResource.adaptTo(ValueMap.class);
                    String locationProp = targetResProps.get("location", null);
                    String locationID = StringUtils.isNotBlank((String)locationProp) ? locationProp : targetResource.getPath();
                    JSONObject teaserInfo = this.targetedContentManager.getTeaserInfo(resolver, null, locationID);
                    JSONArray allTeasers = teaserInfo.getJSONArray("allTeasers");
                    for (int i = 0; i < allTeasers.length(); ++i) {
                        JSONObject teaser = allTeasers.getJSONObject(i);
                        if (!teaser.getString("path").startsWith(campaignPathPrefix)) continue;
                        matchesPage = true;
                        continue block2;
                    }
                }
            }
            catch (JSONException e) {
                log.error("Could not determine if page {} uses campaign {}!", new Object[]{pageRes.getPath(), campaignResource.getPath()});
                log.error("", (Throwable)e);
            }
        }
        return matchesPage;
    }

    private List<Resource> getTargetComponents(Resource rootResource, List<Resource> resList) {
        if (resList == null) {
            resList = new ArrayList<Resource>();
        }
        for (Resource child : rootResource.getChildren()) {
            if (child.isResourceType(TARGET_COMPONENT)) {
                resList.add(child);
                continue;
            }
            this.getTargetComponents(child, resList);
        }
        return resList;
    }
}

