/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.dam.index.bootstrap;

import com.adobe.cq.dam.index.builder.AggregationRule;
import com.adobe.cq.dam.index.builder.IndexRule;
import com.adobe.cq.dam.index.builder.LuceneIndexDefinition;
import com.adobe.cq.dam.index.builder.OakPropertyIndexDefinition;
import com.adobe.cq.dam.index.builder.OrderedPropertyDefinition;
import com.adobe.cq.dam.index.builder.SimplePropertyDefinition;
import com.adobe.cq.dam.index.helper.IndexHelper;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
public class DamIndexBootstrap {
    private static final Logger log = LoggerFactory.getLogger(DamIndexBootstrap.class);
    @Reference(policy=ReferencePolicy.STATIC)
    private ResourceResolverFactory jcrResolverFactory;
    private static String[] disableIndexList = new String[]{"dcFormat", "videoCodec", "damFileSize", "damSha1", "xmpMMDocumentId", "xmpMMInstanceId"};
    private static String[] depriortiseIndexList = new String[]{"cqTags", "damStatus", "offTime", "onTime"};
    private static final String INDEX_ROOT_PATH = "/oak:index";

    protected void activate(ComponentContext context) {
        try {
            ResourceResolver resolver = this.jcrResolverFactory.getAdministrativeResourceResolver(null);
            this.disableDefaultIndex(resolver);
            this.depriortiseIndex(resolver);
            this.createDefaultIndex(resolver);
        }
        catch (LoginException e) {
            log.error("Error while setting up dam index", (Throwable)e);
        }
    }

    private void disableDefaultIndex(ResourceResolver resolver) {
        for (String path : disableIndexList) {
            Resource indexRsc = resolver.getResource("/oak:index/" + path);
            if (indexRsc == null) continue;
            IndexHelper.disableIndex(indexRsc);
        }
    }

    private void depriortiseIndex(ResourceResolver resolver) {
        for (String path : depriortiseIndexList) {
            Resource indexRsc = resolver.getResource("/oak:index/" + path);
            if (indexRsc == null) continue;
            IndexHelper.deprioritiseIndex(indexRsc);
        }
    }

    private void createDefaultIndex(ResourceResolver resolver) {
        Resource indexRootRsc = resolver.getResource("/");
        LuceneIndexDefinition indexDef = new LuceneIndexDefinition("damAssetLucene", DamIndexBootstrap.createAggregationRules(), DamIndexBootstrap.createIndexRules());
        if (IndexHelper.getReIndexCount(indexRootRsc.getChild("oak:index/damAssetLucene")) <= 0L) {
            if (indexDef.build(indexRootRsc, true)) {
                log.debug("IndexDefinition created successfully at {}", (Object)indexRootRsc.getPath());
            } else {
                log.debug("IndexDefinition creation failed");
            }
        }
        OakPropertyIndexDefinition oakPropertyIndexDefProcProf = new OakPropertyIndexDefinition(new String[]{"processingProfile"}, "processingProfile");
        if (IndexHelper.getReIndexCount(indexRootRsc.getChild("oak:index/processingProfile")) <= 0L) {
            oakPropertyIndexDefProcProf.build(indexRootRsc, true);
        }
        OakPropertyIndexDefinition oakPropertyIndexDefRefExp = new OakPropertyIndexDefinition(new String[]{"refExpired"}, "refExpired");
        if (IndexHelper.getReIndexCount(indexRootRsc.getChild("oak:index/refExpired")) <= 0L) {
            oakPropertyIndexDefRefExp.build(indexRootRsc, true);
        }
        OakPropertyIndexDefinition oakPropertyIndexDefSubType = new OakPropertyIndexDefinition(new String[]{"subType"}, "subType");
        if (IndexHelper.getReIndexCount(indexRootRsc.getChild("oak:index/subType")) <= 0L) {
            oakPropertyIndexDefSubType.build(indexRootRsc, true);
        }
        OakPropertyIndexDefinition profileIndexDef = new OakPropertyIndexDefinition(new String[]{"metadataProfile", "videoProfile", "imageProfile"}, "profiles");
        if (IndexHelper.getReIndexCount(indexRootRsc.getChild("oak:index/profiles")) <= 0L) {
            profileIndexDef.build(indexRootRsc, true);
        }
    }

    public static List<AggregationRule> createAggregationRules() {
        return ImmutableList.of(new AggregationRule("dam:Asset", ImmutableList.of("jcr:content", "jcr:content/metadata", "jcr:content/metadata/*", "jcr:content/renditions", "jcr:content/renditions/original", "jcr:content/renditions/original/jcr:content", "jcr:content/comments", "jcr:content/comments/*", "jcr:content/usages")));
    }

    public static List<IndexRule> createIndexRules() {
        return ImmutableList.of(new IndexRule("dam:Asset", ImmutableList.of(new SimplePropertyDefinition("jcr:content/metadata/cq:tags", "cqTags", 1.0f, false, true, true), new SimplePropertyDefinition("jcr:content/metadata/dc:format", "dcFormat", 1.0f, true), new SimplePropertyDefinition("jcr:content/metadata/dam:status", "damStatus"), new SimplePropertyDefinition("jcr:content/metadata/videoCodec", "videoCodec"), new SimplePropertyDefinition("jcr:content/metadata/audioCodec", "audioCodec"), new SimplePropertyDefinition("jcr:content/metadata/dc:title", "dcTitle", 2.0f, false, true, true), new SimplePropertyDefinition("jcr:content/metadata/dc:description", "dcDescription", 1.0f, false, true, true), new SimplePropertyDefinition("jcr:content/metadata/xmpMM:InstanceID", "xmpMMInstanceId"), new SimplePropertyDefinition("jcr:content/metadata/xmpMM:DocumentID", "xmpMMDocumentId"), new SimplePropertyDefinition("jcr:content/metadata/dam:sha1", "damSha1"), new SimplePropertyDefinition("jcr:content/hasValidMetadata", "hasValidMetadata", "Boolean"), new SimplePropertyDefinition("jcr:content/metadata/videoBitrate", "videoBitrate"), new SimplePropertyDefinition[]{new SimplePropertyDefinition("jcr:content/metadata/audioBitrate", "audioBitRate"), new SimplePropertyDefinition("jcr:content/usages/usedBy", "usedBy"), new OrderedPropertyDefinition("jcr:content/jcr:lastModified", "jcrLastModified", "Date"), new OrderedPropertyDefinition("jcr:content/metadata/prism:expirationDate", "expirationDate", "Date"), new OrderedPropertyDefinition("jcr:content/onTime", "onTime", "Date"), new OrderedPropertyDefinition("jcr:content/offTime", "offTime", "Date"), new OrderedPropertyDefinition("jcr:content/metadata/dam:size", "damSize", "Long"), new OrderedPropertyDefinition("jcr:content/averageRating", "averageRating", "Double"), new OrderedPropertyDefinition("jcr:content/metadata/tiff:ImageWidth", "tiffImageWidth", "Long"), new OrderedPropertyDefinition("jcr:content/metadata/tiff:ImageLength", "tiffImageLength", "Long"), new OrderedPropertyDefinition("jcr:content/usages/dam:score", "score", "Long")})));
    }

    protected void bindJcrResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.jcrResolverFactory = resourceResolverFactory;
    }

    protected void unbindJcrResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.jcrResolverFactory == resourceResolverFactory) {
            this.jcrResolverFactory = null;
        }
    }
}

