/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.dam.index.builder;

import com.adobe.cq.dam.index.builder.api.PropertyDefinition;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.List;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;

public class IndexRule {
    String primaryType;
    List<? extends PropertyDefinition> propertyDefinitions;

    public IndexRule(String primaryType, List<? extends PropertyDefinition> propDef) {
        this.primaryType = primaryType;
        this.propertyDefinitions = propDef;
    }

    public String primaryType() {
        return this.primaryType;
    }

    public List<? extends PropertyDefinition> propertyDefinition() {
        return this.propertyDefinitions;
    }

    public void build(Resource resource) throws PersistenceException {
        ResourceResolver resolver = resource.getResourceResolver();
        Resource primaryTypeNode = resolver.create(resource, this.primaryType, new HashMap<String, Object>());
        Resource propertiesNode = resolver.create(primaryTypeNode, "properties", ImmutableMap.of("jcr:primaryType", "nt:unstructured"));
        for (PropertyDefinition propertyDefinition : this.propertyDefinitions) {
            propertyDefinition.build(propertiesNode);
        }
    }
}

