/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.dam.index.helper;

import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexHelper {
    private static Logger log = LoggerFactory.getLogger(IndexHelper.class);
    private static final String DISABLED_INDEX_TYPE = "disabled";

    public static boolean deprioritiseIndex(Resource resource) {
        if (IndexHelper.isValidIndexDef(resource)) {
            ModifiableValueMap vm = resource.adaptTo(ModifiableValueMap.class);
            vm.put("entryCount", Long.MAX_VALUE);
            try {
                resource.getResourceResolver().commit();
                return true;
            }
            catch (PersistenceException e) {
                log.error("Error while disabling index.", (Throwable)e);
                return false;
            }
        }
        return false;
    }

    public static boolean disableIndex(Resource resource) {
        if (IndexHelper.isValidIndexDef(resource)) {
            ModifiableValueMap vm = resource.adaptTo(ModifiableValueMap.class);
            vm.put("type", DISABLED_INDEX_TYPE);
            try {
                resource.getResourceResolver().commit();
                return true;
            }
            catch (PersistenceException e) {
                log.error("Error while disabling index.", (Throwable)e);
                return false;
            }
        }
        return false;
    }

    public static boolean reIndex(Resource resource) {
        if (IndexHelper.isValidIndexDef(resource)) {
            ModifiableValueMap vm = resource.adaptTo(ModifiableValueMap.class);
            vm.put("reindex", true);
            try {
                resource.getResourceResolver().commit();
                return true;
            }
            catch (PersistenceException e) {
                log.error("Error while initiating reindexing.", (Throwable)e);
                return false;
            }
        }
        return false;
    }

    public static long getReIndexCount(Resource resource) {
        if (IndexHelper.isValidIndexDef(resource)) {
            ValueMap vm = resource.adaptTo(ValueMap.class);
            return vm.containsKey("reindexCount") ? (Long)vm.get("reindexCount") : 0L;
        }
        return -1L;
    }

    private static boolean isValidIndexDef(Resource resource) {
        if (resource == null) {
            return false;
        }
        ValueMap vm = resource.adaptTo(ValueMap.class);
        return "oak:QueryIndexDefinition".equals(vm.get("jcr:primaryType"));
    }
}

