/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.mcm.salesforce;

import com.adobe.cq.mcm.salesforce.SalesforceException;
import com.adobe.cq.mcm.salesforce.SalesforceResponse;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.HttpClientUtils;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.apache.sling.commons.json.JSONArray;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SalesforceClient {
    public static final String INVALID_CLIENT_ID = "invalid_client_id";
    public static final String INVALID_CLIENT = "invalid_client";
    public static final String CLIENT_ID = "client_id";
    public static final String CLIENT_SECRET = "client_secret";
    public static final String REFRESH_ACCESS_TOKEN_ENDPOINT = "/services/oauth2/token";
    public static final String APPLICATION_FORMURL_ENCODED = "application/x-www-form-urlencoded";
    public static final String GRANT_TYPE = "grant_type";
    public static final String REFRESH_TOKEN = "refresh_token";
    protected final int HTTP_CODE_REFRESH_TOKEN_SUCCESS = 200;
    protected String clientId = "";
    protected String clientSecret = "";
    protected String instanceURL = "";
    protected String path = "";
    protected String accessToken = "";
    protected String refreshToken = "";
    protected String contentType = "";
    protected String data = "";
    protected AvailableMethods method;
    protected HashMap<String, String> parameters = new HashMap();
    private final Logger logger = LoggerFactory.getLogger(SalesforceClient.class);

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
        if (!this.data.contains(CLIENT_ID)) {
            this.addData(CLIENT_ID, clientId);
        }
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
        if (!this.data.contains(CLIENT_SECRET)) {
            this.addData(CLIENT_SECRET, clientSecret);
        }
    }

    public String getData() {
        return this.data;
    }

    public void addData(String key, String value) {
        this.addData(key, value, true);
    }

    public void addData(String key, String value, boolean encode) {
        if (!this.data.equals("")) {
            this.data = this.data + "&";
        }
        try {
            this.data = this.data + key + "=" + (encode ? URLEncoder.encode(value, "UTF-8") : value);
        }
        catch (UnsupportedEncodingException e) {
            this.logger.error("Exception in adding data to Salesforce Client: " + e.getMessage());
        }
    }

    public void setData(Map<String, String> data) {
        this.data = "";
        Iterator<Map.Entry<String, String>> it = data.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, String> pairs = it.next();
            try {
                this.data = this.data + pairs.getKey() + "=" + URLEncoder.encode(pairs.getValue(), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                this.logger.error("Exception in adding data to Salesforce Client: " + e.getMessage());
            }
            if (!it.hasNext()) continue;
            this.data = this.data + "&";
        }
    }

    public void setData(String data) {
        this.data = data;
    }

    public String getInstanceURL() {
        return this.instanceURL;
    }

    public void setInstanceURL(String instanceURL) {
        this.instanceURL = instanceURL;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public void setRefreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public AvailableMethods getMethod() {
        return this.method;
    }

    public void setMethod(AvailableMethods method) {
        this.method = method;
    }

    public void setStringMethod(String method) {
        if (method.equals("GET")) {
            this.setMethod(AvailableMethods.GET);
        } else if (method.equals("POST")) {
            this.setMethod(AvailableMethods.POST);
        } else if (method.equals("PATCH")) {
            this.setMethod(AvailableMethods.PATCH);
        }
    }

    public void addParameter(String key, String value) {
        this.parameters.put(key, value);
    }

    public HashMap<String, String> getParameters() {
        return this.parameters;
    }

    public void setParameters(HashMap<String, String> parameters) {
        this.parameters = parameters;
    }

    public SalesforceResponse executeRequest() throws SalesforceException {
        if (this.method == AvailableMethods.GET) {
            return this.executeGetRequest();
        }
        if (this.method == AvailableMethods.POST || this.method == AvailableMethods.PATCH) {
            return this.executeDataRequest();
        }
        throw new SalesforceException("Unavailable HTTP Method");
    }

    public SalesforceResponse executeGetRequest() throws SalesforceException {
        SalesforceResponse response = new SalesforceResponse();
        try {
            response = this.doExecuteGetRequest();
            if (this.isAccessTokenExpired(response)) {
                SalesforceResponse refreshResponse = this.refreshAccessToken();
                response = this.doExecuteGetRequest();
                response.setAccessTokenUpdated(refreshResponse.getAccessTokenUpdated());
            }
        }
        catch (IOException e) {
            this.logger.error("Transport Error while executing a GET Request ", (Throwable)e);
            throw new SalesforceException("Transport Error while executing a GET Request ", e);
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SalesforceResponse doExecuteGetRequest() throws IOException, SalesforceException {
        CloseableHttpClient client = HttpClients.createDefault();
        SalesforceResponse response = new SalesforceResponse();
        try {
            String uri = this.instanceURL + this.path + "?";
            for (Map.Entry<String, String> pairs : this.parameters.entrySet()) {
                uri = uri + pairs.getKey() + "=" + URLEncoder.encode(pairs.getValue(), "UTF-8");
            }
            HttpGet method = new HttpGet(uri);
            if (!this.contentType.isEmpty()) {
                method.setHeader("Content-Type", this.contentType);
            }
            if (!this.accessToken.isEmpty()) {
                method.removeHeaders("Authorization");
                method.setHeader("Authorization", "OAuth " + this.accessToken);
            }
            HttpResponse httpResponse = client.execute((HttpUriRequest)method);
            try {
                response.setCode(httpResponse.getStatusLine().getStatusCode());
                HttpEntity httpEntity = httpResponse.getEntity();
                if (httpEntity != null) {
                    String body = EntityUtils.toString((HttpEntity)httpResponse.getEntity());
                    response.setBody(body);
                }
            }
            finally {
                HttpClientUtils.closeQuietly((HttpResponse)httpResponse);
            }
        }
        catch (Exception e) {
            this.logger.error("Error while Executing GET Request to Salesforce.com: ", (Throwable)e);
            throw new SalesforceException("Error while Executing GET Request to Salesforce.com: ", e);
        }
        finally {
            HttpClientUtils.closeQuietly((HttpClient)client);
        }
        return response;
    }

    public SalesforceResponse executeDataRequest() throws SalesforceException {
        SalesforceResponse response = new SalesforceResponse();
        try {
            response = this.doExecuteDataRequest();
            if (this.isAccessTokenExpired(response)) {
                SalesforceResponse refreshResponse = this.refreshAccessToken();
                response = this.doExecuteDataRequest();
                response.setAccessTokenUpdated(refreshResponse.getAccessTokenUpdated());
            }
        }
        catch (IOException e) {
            this.logger.error("Transport Error while executing a GET Request ", (Throwable)e);
            throw new SalesforceException("Transport Error while executing a GET Request ", e);
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SalesforceResponse doExecuteDataRequest() throws IOException, SalesforceException {
        HttpPost method = null;
        if (this.method == AvailableMethods.POST) {
            method = new HttpPost(this.instanceURL + this.path);
        } else if (this.method == AvailableMethods.PATCH) {
            method = new HttpPatch(this.instanceURL + this.path);
        }
        SalesforceResponse response = new SalesforceResponse();
        CloseableHttpClient client = HttpClients.createDefault();
        try {
            if (!this.contentType.isEmpty()) {
                method.setHeader("Content-Type", this.contentType);
            }
            if (!this.accessToken.isEmpty()) {
                method.removeHeaders("Authorization");
                method.setHeader("Authorization", "OAuth " + this.accessToken);
            }
            method.setEntity((HttpEntity)new StringEntity(this.data, ContentType.create((String)this.contentType, (String)"UTF-8")));
            HttpResponse httpResponse = client.execute((HttpUriRequest)method);
            try {
                response.setCode(httpResponse.getStatusLine().getStatusCode());
                HttpEntity httpEntity = httpResponse.getEntity();
                if (httpEntity != null) {
                    String body = EntityUtils.toString((HttpEntity)httpResponse.getEntity());
                    response.setBody(body);
                }
            }
            finally {
                HttpClientUtils.closeQuietly((HttpResponse)httpResponse);
            }
        }
        catch (Exception e) {
            this.logger.error("Error while Executing POST/PUT Request to Salesforce.com: ", (Throwable)e);
            throw new SalesforceException("Error while Executing POST/PUT Request to Salesforce.com: ", e);
        }
        finally {
            method.releaseConnection();
        }
        return response;
    }

    public SalesforceResponse refreshAccessToken() throws SalesforceException {
        SalesforceClient salesforceRefreshClient = new SalesforceClient();
        salesforceRefreshClient.setRefreshToken(this.refreshToken);
        salesforceRefreshClient.setPath(REFRESH_ACCESS_TOKEN_ENDPOINT);
        salesforceRefreshClient.setInstanceURL(this.instanceURL);
        salesforceRefreshClient.setContentType(APPLICATION_FORMURL_ENCODED);
        salesforceRefreshClient.addData(GRANT_TYPE, REFRESH_TOKEN);
        salesforceRefreshClient.addData(CLIENT_ID, this.clientId);
        salesforceRefreshClient.addData(CLIENT_SECRET, this.clientSecret);
        salesforceRefreshClient.addData(REFRESH_TOKEN, this.refreshToken);
        salesforceRefreshClient.setMethod(AvailableMethods.POST);
        SalesforceResponse response = salesforceRefreshClient.executeRequest();
        try {
            if (response.getCode() != 200) {
                String errorMessage = "";
                JSONObject errorJSON = response.getBodyAsJSON();
                errorMessage = errorJSON.get("error").equals(INVALID_CLIENT_ID) ? "Can't refresh access token due to Invalid Customer Key " : (errorJSON.get("error").equals(INVALID_CLIENT) ? "Can't refresh access token due to Invalid Customer Secret " : "Can't refresh access token due to some unknown error. Please contact Administrator ");
                this.logger.error("Can't refresh access token. Response: " + response.getBody());
                throw new SalesforceException(errorMessage);
            }
            JSONObject responseJson = new JSONObject(response.getBody());
            this.setInstanceURL(responseJson.getString("instance_url"));
            this.setAccessToken(responseJson.getString("access_token"));
            response.setAccessTokenUpdated(true);
        }
        catch (JSONException e) {
            this.logger.error("JSON Exception while refreshing the Access Token. Response: " + response.getBody() + " Exception: " + e.getMessage());
            throw new SalesforceException("JSON Exception while refreshing the Access Token. Response: " + response.getBody() + " Exception: " + e.getMessage());
        }
        return response;
    }

    public boolean isAccessTokenExpired(SalesforceResponse salesforceResponse) throws SalesforceException {
        if (salesforceResponse.getBody() != null && !"".equals(salesforceResponse.getBody())) {
            try {
                String responseBody = salesforceResponse.getBody();
                if (responseBody.charAt(0) != '[' && responseBody.charAt(responseBody.length() - 1) != ']') {
                    responseBody = '[' + responseBody + ']';
                }
                JSONArray salesforceResponseJson = new JSONArray(responseBody);
                return salesforceResponseJson.getJSONObject(0).getString("errorCode").equals("INVALID_SESSION_ID");
            }
            catch (JSONException e) {
                this.logger.info("ErrorCode not found meaning success hence ignoring exception ");
            }
        }
        return false;
    }

    public static enum AvailableMethods {
        GET,
        POST,
        PATCH;

    }
}

