/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.mobile.dps;

import com.day.cq.wcm.api.Page;
import javax.jcr.RepositoryException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MediaUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(MediaUtil.class);

    private MediaUtil() {
    }

    public static String getMediaImageSelector(Resource imageResource) throws RepositoryException {
        String selector = ".img";
        if (MediaUtil.isOriginalImageRequested(imageResource)) {
            selector = ".img.original";
        } else if (MediaUtil.isImageScalingEnabled(imageResource)) {
            String adaptiveSelector = ".img";
            String adaptiveWidth = String.valueOf(MediaUtil.getImageWidthSelector(imageResource));
            String adaptiveQuality = MediaUtil.getImageQualitySelector(imageResource);
            selector = adaptiveSelector + "." + adaptiveWidth + "." + adaptiveQuality;
        } else {
            LOGGER.info("Media: Scaling disabled. Image will not be scaled, default rendering will be used");
        }
        return selector;
    }

    private static boolean isOriginalImageRequested(Resource imageResource) {
        return MediaUtil.isBooleanPropertyTrue(imageResource, "useOriginalImage");
    }

    private static boolean isImageScalingEnabled(Resource imageResource) {
        return MediaUtil.isBooleanPropertyTrue(imageResource, "scalingEnabled");
    }

    private static boolean isBooleanPropertyTrue(Resource imageResource, String propertyName) {
        ValueMap properties = ResourceUtil.getValueMap(imageResource);
        boolean isBooleanPropertyTrue = false;
        if (properties.containsKey(propertyName)) {
            isBooleanPropertyTrue = (Boolean)((Object)properties.get(propertyName, Boolean.class));
        }
        return isBooleanPropertyTrue;
    }

    private static String getImageWidthSelector(Resource imageResource) {
        ValueMap properties = ResourceUtil.getValueMap(imageResource);
        String targetWidth = "full";
        String setWidthOverride = (String)((Object)properties.get("scalewidth", String.class));
        if (setWidthOverride != null) {
            targetWidth = setWidthOverride;
        }
        return targetWidth;
    }

    private static String getImageQualitySelector(Resource imageResource) {
        ValueMap properties = ResourceUtil.getValueMap(imageResource);
        return properties.get("quality", "full");
    }

    private static Page getParentPage(Resource resource) {
        Resource parentResource = resource.getParent();
        if (parentResource != null) {
            if (ResourceUtil.isA(parentResource, "cq:Page")) {
                return parentResource.adaptTo(Page.class);
            }
            return MediaUtil.getParentPage(parentResource);
        }
        return null;
    }
}

