/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.mobile.dps;

import java.util.HashMap;
import java.util.Map;

public enum ProtectedAccess {
    PROTECTED("protected"),
    CLOSED("Closed"),
    METERED("metered"),
    OPEN("Open"),
    FREE("free");

    private static final String METERED_OPEN = "Open";
    private static final String PROTECTED_CLOSED = "Closed";
    private static Map<String, ProtectedAccess> ENUM_BY_VALUE;
    private String value;

    private ProtectedAccess(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public static final boolean isProtectedAccess(String value) {
        return ProtectedAccess.getProtectedAccess(value) != null;
    }

    public static final ProtectedAccess getProtectedAccess(String value) {
        ProtectedAccess protectedAccess = null;
        if (value != null && (protectedAccess = ENUM_BY_VALUE.get(value = value.toLowerCase())) == null) {
            if (value.equals(METERED_OPEN.toLowerCase())) {
                protectedAccess = METERED;
            } else if (value.equals(PROTECTED_CLOSED.toLowerCase())) {
                protectedAccess = PROTECTED;
            }
        }
        return protectedAccess;
    }

    static {
        ENUM_BY_VALUE = new HashMap<String, ProtectedAccess>(ProtectedAccess.values().length);
        for (ProtectedAccess enumValue : ProtectedAccess.values()) {
            if (enumValue.equals((Object)CLOSED) || enumValue.equals((Object)OPEN)) continue;
            ENUM_BY_VALUE.put(enumValue.getValue().toLowerCase(), enumValue);
        }
    }
}

