/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.searchcollections.lucene;

import com.adobe.cq.searchcollections.lucene.JCRDirectory;
import java.io.IOException;
import org.apache.lucene.store.IndexOutput;

class JCRIndexOutput
extends IndexOutput {
    private final JCRDirectory directory;
    private final String name;
    private byte[] data;
    private int length;
    private int position = 0;
    private boolean dirty = false;

    public JCRIndexOutput(JCRDirectory directory, String name) throws IOException {
        this.directory = directory;
        this.name = name;
        this.data = directory.readFile(name);
        if (this.data != null) {
            this.length = this.data.length;
        } else {
            this.data = new byte[1024];
            this.length = 0;
        }
    }

    private synchronized void grow(int n) {
        if (this.position + n > this.data.length) {
            byte[] buffer = new byte[Math.max(this.position + n, this.data.length * 2)];
            System.arraycopy(this.data, 0, buffer, 0, this.length);
            this.data = buffer;
        }
        if (this.position + n > this.length) {
            this.length = this.position + n;
        }
    }

    @Override
    public synchronized void writeByte(byte b) throws IOException {
        this.grow(1);
        this.data[this.position++] = b;
        this.dirty = true;
    }

    @Override
    public synchronized void writeBytes(byte[] b, int offset, int length) throws IOException {
        this.grow(length);
        System.arraycopy(b, offset, this.data, this.position, length);
        this.position += length;
        this.dirty = true;
    }

    @Override
    public synchronized void flush() throws IOException {
        if (this.dirty) {
            byte[] buffer = this.data;
            if (this.length != this.data.length) {
                buffer = new byte[this.length];
                System.arraycopy(this.data, 0, buffer, 0, this.length);
            }
            this.directory.writeFile(this.name, buffer);
            this.dirty = false;
        }
    }

    @Override
    public synchronized void close() throws IOException {
        this.flush();
    }

    @Override
    public synchronized long getFilePointer() {
        return this.position;
    }

    @Override
    public synchronized void seek(long pos) throws IOException {
        if (0L > pos || pos >= (long)this.length) {
            throw new IOException();
        }
        this.position = (int)pos;
    }

    @Override
    public synchronized long length() throws IOException {
        return this.length;
    }
}

