/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.searchcollections.lucene;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;

class LuceneSearchCollectionConfig {
    private static final String PROPERTY_INCLUDES = "includes";
    private static final String PROPERTY_EXCLUDES = "excludes";
    private final List<String> includes;
    private final List<String> excludes;

    LuceneSearchCollectionConfig(Node directory) throws RepositoryException {
        this.includes = LuceneSearchCollectionConfig.getOrElse(directory, PROPERTY_INCLUDES, null);
        this.excludes = LuceneSearchCollectionConfig.getOrElse(directory, PROPERTY_EXCLUDES, null);
    }

    public boolean shouldInclude(String path) {
        return this.matchesIncludes(path) && !this.matchesExcludes(path);
    }

    private boolean matchesIncludes(String path) {
        return this.matches(this.includes, path);
    }

    private boolean matchesExcludes(String path) {
        return this.matches(this.excludes, path);
    }

    private boolean matches(List<String> rules, String path) {
        if (rules == null || rules.isEmpty() || path == null) {
            return false;
        }
        for (String r : rules) {
            if (!path.startsWith(r)) continue;
            return true;
        }
        return false;
    }

    private static List<String> getOrElse(Node node, String property, String defVal) throws RepositoryException {
        String[] vs;
        String v = null;
        try {
            v = node.getProperty(property).getString();
        }
        catch (PathNotFoundException e) {
            // empty catch block
        }
        if (v == null) {
            return null;
        }
        ArrayList<String> retval = new ArrayList<String>();
        for (String val : vs = v.split(",")) {
            if (val.trim().length() <= 0) continue;
            retval.add(val.trim());
        }
        return retval;
    }
}

