/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.searchcollections.qom;

import javax.jcr.NodeIterator;
import javax.jcr.RangeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.query.QueryResult;
import javax.jcr.query.Row;
import javax.jcr.query.RowIterator;
import org.apache.jackrabbit.commons.iterator.NodeIteratorAdapter;

public class SimpleQueryResult
implements QueryResult {
    private final String[] columnNames;
    private final String[] selectorNames;
    private RowIterator rowIterator;
    private long totalNumberOfResults;

    public SimpleQueryResult(String[] columnNames, String[] selectorNames, RowIterator rowIterator, long totalNumberOfResults) {
        assert (columnNames != null);
        assert (selectorNames != null && selectorNames.length >= 1);
        assert (rowIterator != null);
        this.columnNames = columnNames;
        this.selectorNames = selectorNames;
        this.rowIterator = rowIterator;
        this.totalNumberOfResults = totalNumberOfResults;
    }

    public long getTotalNumberOfResults() {
        return this.totalNumberOfResults;
    }

    public String[] getColumnNames() {
        return this.columnNames;
    }

    public String[] getSelectorNames() {
        return this.selectorNames;
    }

    public synchronized RowIterator getRows() throws RepositoryException {
        if (this.rowIterator != null) {
            RowIterator iterator = this.rowIterator;
            this.rowIterator = null;
            return iterator;
        }
        throw new RepositoryException("This query result has already been iterated through");
    }

    public NodeIterator getNodes() throws RepositoryException {
        if (this.selectorNames.length == 1) {
            return new NodeIteratorAdapter((RangeIterator)this.getRows()){

                @Override
                public Object next() {
                    Row row = (Row)super.next();
                    try {
                        return row.getNode();
                    }
                    catch (RepositoryException e) {
                        throw new RuntimeException("Unable to access the node in " + row, e);
                    }
                }
            };
        }
        throw new RepositoryException("This query result contains more than one selector");
    }
}

