/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.sightly;

import aQute.bnd.annotation.ProviderType;
import com.adobe.cq.sightly.SightlyWCMMode;
import com.adobe.cq.sightly.WCMResourceOptions;
import com.adobe.cq.sightly.internal.PrintWriterResponseWrapper;
import com.day.cq.wcm.api.WCMMode;
import com.day.cq.wcm.api.components.ComponentContext;
import com.day.cq.wcm.api.components.IncludeOptions;
import com.day.cq.wcm.commons.WCMUtils;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.request.RequestDispatcherOptions;
import org.apache.sling.api.resource.NonExistingResource;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.SyntheticResource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.scripting.SlingScriptHelper;
import org.apache.sling.api.servlets.ServletResolver;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.apache.sling.scripting.sightly.SightlyException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ProviderType
public class WCMScriptHelper {
    private final Logger log = LoggerFactory.getLogger(WCMScriptHelper.class);
    private SlingScriptHelper slingHelper;
    private SlingHttpServletRequest request;
    private SlingHttpServletResponse response;
    private SightlyWCMMode mode;

    public WCMScriptHelper(SlingScriptHelper sling) {
        this.slingHelper = sling;
        this.request = sling.getRequest();
        this.response = sling.getResponse();
        this.mode = new SightlyWCMMode(this.request);
    }

    public void includeResource(PrintWriter out, String script, String dispatcherOptions, String resourceType, WCMResourceOptions wcmResourceOptions) {
        PrintWriterResponseWrapper customResponse = new PrintWriterResponseWrapper(out, this.response);
        this.includeResource((SlingHttpServletResponse)customResponse, script, dispatcherOptions, resourceType, wcmResourceOptions);
    }

    public void includeResource(SlingHttpServletResponse customResponse, String script, String dispatcherOptions, String resourceType, WCMResourceOptions wcmResourceOptions) {
        this.includeResource(customResponse, script, dispatcherOptions, resourceType, wcmResourceOptions, Collections.EMPTY_MAP);
    }

    public void includeResource(SlingHttpServletResponse response, String script, String dispatcherOptions, String resourceType, WCMResourceOptions wcmResourceOptions, Map<String, Object> resourceProperties) {
        if (StringUtils.isEmpty((CharSequence)script)) {
            this.log.error("Script path cannot be empty.");
        } else {
            script = this.normalizePath(script);
            WCMMode currentMode = (WCMMode)((Object)this.request.getAttribute(WCMMode.REQUEST_ATTRIBUTE_NAME));
            try {
                RequestDispatcher dispatcher;
                WCMMode mode = wcmResourceOptions.getWCMMode();
                if (mode != null) {
                    this.request.setAttribute(WCMMode.REQUEST_ATTRIBUTE_NAME, (Object)mode);
                }
                IncludeOptions includeOptions = IncludeOptions.getOptions((ServletRequest)this.request, true);
                String decorationTag = wcmResourceOptions.getDecorationTagName();
                if (decorationTag == null) {
                    ComponentContext componentContext = WCMUtils.getComponentContext((ServletRequest)this.request);
                    decorationTag = componentContext.getDecorationTagName();
                }
                includeOptions.setDecorationTagName(decorationTag);
                String cssClassName = wcmResourceOptions.getCssClassName();
                if (StringUtils.isNotEmpty((CharSequence)cssClassName)) {
                    includeOptions.getCssClassNames().addAll(this.expandClassName(cssClassName));
                }
                RequestDispatcherOptions requestDispatcherOptions = new RequestDispatcherOptions(dispatcherOptions);
                if (StringUtils.isNotEmpty((CharSequence)resourceType)) {
                    requestDispatcherOptions.setForceResourceType(resourceType);
                }
                if (resourceProperties != null && resourceProperties.size() > 0) {
                    SyntheticResourceWithProperties includedResource = new SyntheticResourceWithProperties(this.request.getResourceResolver(), script, resourceType, resourceProperties);
                    dispatcher = this.request.getRequestDispatcher(includedResource, requestDispatcherOptions);
                } else {
                    Resource includedResource = this.request.getResourceResolver().resolve(script);
                    if ((includedResource instanceof NonExistingResource || includedResource.isResourceType("sling:nonexisting")) && resourceType != null) {
                        includedResource = new SyntheticResource(this.request.getResourceResolver(), script, resourceType);
                        dispatcher = this.request.getRequestDispatcher(includedResource, requestDispatcherOptions);
                        requestDispatcherOptions.remove("forceResourceType");
                    } else {
                        dispatcher = this.request.getRequestDispatcher(script, requestDispatcherOptions);
                    }
                }
                dispatcher.include((ServletRequest)this.request, (ServletResponse)response);
            }
            catch (Exception e) {
                if (e instanceof SightlyException) {
                    throw (SightlyException)e;
                }
                throw new SightlyException(e);
            }
            finally {
                if (currentMode == null) {
                    this.request.removeAttribute(WCMMode.REQUEST_ATTRIBUTE_NAME);
                } else {
                    this.request.setAttribute(WCMMode.REQUEST_ATTRIBUTE_NAME, (Object)currentMode);
                }
            }
        }
    }

    public void includeScript(String script, String wcmMode, PrintWriter out) {
        if (StringUtils.isEmpty((CharSequence)script)) {
            this.log.error("Script path cannot be empty.");
        } else {
            ServletResolver servletResolver;
            WCMMode mode;
            WCMMode currentMode = (WCMMode)((Object)this.request.getAttribute(WCMMode.REQUEST_ATTRIBUTE_NAME));
            if (StringUtils.isNotEmpty((CharSequence)wcmMode) && (mode = WCMMode.valueOf(wcmMode.toUpperCase())) != null) {
                this.request.setAttribute(WCMMode.REQUEST_ATTRIBUTE_NAME, (Object)mode);
            }
            if ((servletResolver = this.slingHelper.getService(ServletResolver.class)) != null) {
                Servlet servlet = servletResolver.resolveServlet(this.request.getResource(), script);
                if (servlet != null) {
                    try {
                        PrintWriterResponseWrapper resWrapper = new PrintWriterResponseWrapper(out, this.response);
                        servlet.service((ServletRequest)this.request, (ServletResponse)resWrapper);
                    }
                    catch (Exception e) {
                        if (e instanceof SightlyException) {
                            throw (SightlyException)e;
                        }
                        throw new SightlyException(e);
                    }
                } else {
                    this.log.error("Failed to locate script {}.", (Object)script);
                }
            } else {
                this.log.error("Sling ServletResolver service is unavailable, failed to include {}.", (Object)script);
            }
            if (currentMode == null) {
                this.request.removeAttribute(WCMMode.REQUEST_ATTRIBUTE_NAME);
            } else {
                this.request.setAttribute(WCMMode.REQUEST_ATTRIBUTE_NAME, (Object)currentMode);
            }
        }
    }

    public SightlyWCMMode getMode() {
        return this.mode;
    }

    private String normalizePath(String path) {
        if (!path.startsWith("/")) {
            path = this.request.getResource().getPath() + "/" + path;
        }
        return ResourceUtil.normalize(path);
    }

    private List<String> expandClassName(String classesString) {
        String[] classesArray = classesString.split("\\s");
        ArrayList<String> classes = new ArrayList<String>();
        for (int i = 0; i < classesArray.length; ++i) {
            String c = classesArray[i].trim();
            if (!StringUtils.isNotEmpty((CharSequence)c)) continue;
            classes.add(c);
        }
        return classes;
    }

    private class SyntheticResourceWithProperties
    extends SyntheticResource {
        private Map<String, Object> properties;

        SyntheticResourceWithProperties(ResourceResolver resourceResolver, String path, String resourceType, Map<String, Object> properties) {
            super(resourceResolver, path, resourceType);
            this.properties = properties;
        }

        @Override
        public <AdapterType> AdapterType adaptTo(Class<AdapterType> type) {
            if (type == ValueMap.class) {
                return (AdapterType)new ValueMapDecorator(this.properties);
            }
            return super.adaptTo(type);
        }
    }
}

