/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.activitystreams.listener.api;

import com.adobe.cq.social.activitystreams.api.SocialActivityManager;
import com.adobe.cq.social.activitystreams.impl.Activator;
import com.adobe.cq.social.activitystreams.listener.api.ActivityStreamProvider;
import com.adobe.cq.social.serviceusers.internal.ServiceUserWrapper;
import com.adobe.granite.activitystreams.Activity;
import com.adobe.granite.activitystreams.ActivityException;
import com.adobe.granite.activitystreams.ActivityStream;
import java.util.Collections;
import java.util.HashMap;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.jcr.api.SlingRepository;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(componentAbstract=true, label="%abstractactivitystreamprovider.name")
public abstract class AbstractActivityStreamProvider
implements ActivityStreamProvider {
    protected static final String UGC_WRITER = "ugc-writer";
    protected static final String SLING_SERVICE_SUBSERVICE = "sling.service.subservice";
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractActivityStreamProvider.class);
    @Reference
    protected ResourceResolverFactory resourceResolverFactory;
    @Reference
    protected SocialActivityManager activityManager;
    @Reference
    protected final SlingRepository repository = null;
    private ServiceUserWrapper serviceUserWrapper;
    private ResourceResolverFactory privateResourceResolverFactory;

    public ServiceUserWrapper getServiceUserWrapper() {
        if (this.serviceUserWrapper == null) {
            this.serviceUserWrapper = (ServiceUserWrapper)Activator.getService(ServiceUserWrapper.class);
        }
        return this.serviceUserWrapper;
    }

    public ResourceResolverFactory getPrivateResourceResolverFactory() {
        if (this.privateResourceResolverFactory == null) {
            this.privateResourceResolverFactory = (ResourceResolverFactory)Activator.getService(ResourceResolverFactory.class);
        }
        return this.privateResourceResolverFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void append(Activity activity) throws ActivityException {
        if (this.activityManager == null) {
            return;
        }
        ResourceResolver ugcResolver = null;
        try {
            ugcResolver = this.getServiceUserWrapper().getServiceResourceResolver(this.getPrivateResourceResolverFactory(), Collections.singletonMap(SLING_SERVICE_SUBSERVICE, UGC_WRITER));
            ActivityStream stream = this.getStream(activity, ugcResolver);
            if (stream != null) {
                stream.append(activity);
            }
        }
        catch (LoginException le) {
            LOGGER.error("Can't obtain resolver for service user", (Throwable)le);
            return;
        }
        finally {
            if (ugcResolver != null && ugcResolver.isLive()) {
                ugcResolver.close();
            }
        }
    }

    protected abstract ActivityStream getStream(Activity var1, ResourceResolver var2) throws ActivityException;

    protected abstract Session getAdminSession() throws RepositoryException;

    protected void activate(ComponentContext ctx) throws LoginException {
    }

    protected void deactivate(ComponentContext context) {
        this.activityManager = null;
    }

    protected ResourceResolver getServiceResourceResolver(Session session) throws LoginException {
        HashMap<String, Object> authInfo = new HashMap<String, Object>();
        authInfo.put("user.jcr.session", session);
        return this.resourceResolverFactory.getResourceResolver(authInfo);
    }

    protected void bindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resourceResolverFactory = resourceResolverFactory;
    }

    protected void unbindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resourceResolverFactory == resourceResolverFactory) {
            this.resourceResolverFactory = null;
        }
    }

    protected void bindActivityManager(SocialActivityManager socialActivityManager) {
        this.activityManager = socialActivityManager;
    }

    protected void unbindActivityManager(SocialActivityManager socialActivityManager) {
        if (this.activityManager == socialActivityManager) {
            this.activityManager = null;
        }
    }

    protected void bindRepository(SlingRepository slingRepository) {
        this.repository = slingRepository;
    }

    protected void unbindRepository(SlingRepository slingRepository) {
        if (this.repository == slingRepository) {
            this.repository = null;
        }
    }
}

