/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.calendar.client.api;

import com.adobe.cq.social.calendar.client.api.Calendar;
import com.adobe.cq.social.calendar.client.api.CalendarEvent;
import com.adobe.cq.social.scf.SocialComponent;
import com.adobe.cq.social.scf.core.SocialEvent;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.InvalidItemStateException;

public class CalendarActionsEvent
extends SocialEvent<CalendarActions>
implements Serializable {
    public static final String CALENDAR_TOPIC = "calendar";
    private static final long serialVersionUID = 2L;

    public CalendarActionsEvent(String path, String userId, CalendarActions action, Map<String, Object> additionalData) {
        super(CALENDAR_TOPIC, path, userId, action, additionalData);
    }

    public static CalendarActionsEvent calendarEventCreated(CalendarEvent calendarEvent, String userId) {
        return CalendarActionsEvent.buildEventForCalendarEvent(calendarEvent, userId, CalendarActions.CalendarEventAdded);
    }

    public static CalendarActionsEvent calendarEventUpdated(CalendarEvent calendarEvent, String userId) {
        return CalendarActionsEvent.buildEventForCalendarEvent(calendarEvent, userId, CalendarActions.CalendarEventEdited);
    }

    public static CalendarActionsEvent calendarEventDeleted(CalendarEvent calendarEvent, String userId) {
        return CalendarActionsEvent.buildEventForCalendarEvent(calendarEvent, userId, CalendarActions.CalendarEventDeleted);
    }

    public static CalendarActionsEvent calendarEventReplyCreated(CalendarEvent calendarEvent, String userId) {
        return CalendarActionsEvent.buildEventForCalendarEventReply(calendarEvent, userId, CalendarActions.CalendarEventReplyAdded);
    }

    public static CalendarActionsEvent calendarEventReplyUpdated(CalendarEvent calendarEvent, String userId) {
        return CalendarActionsEvent.buildEventForCalendarEventReply(calendarEvent, userId, CalendarActions.CalendarEventReplyEdited);
    }

    public static CalendarActionsEvent calendarEventReplyDeleted(CalendarEvent calendarEvent, String userId) {
        return CalendarActionsEvent.buildEventForCalendarEventReply(calendarEvent, userId, CalendarActions.CalendarEventReplyDeleted);
    }

    private static CalendarActionsEvent buildEventForCalendarEvent(CalendarEvent calendarEvent, String userId, CalendarActions action) {
        HashMap<String, Object> addData = new HashMap<String, Object>(2);
        addData.put(OBJECT, new SocialEvent.BaseEventObject(CalendarActionsEvent.getDisplayName(calendarEvent), calendarEvent.getResource().getPath(), "article"));
        addData.put(TARGET, new SocialEvent.BaseEventObject(CalendarActionsEvent.getDisplayName(calendarEvent.getParentComponent()), calendarEvent.getSourceComponentId(), "collection"));
        return new CalendarActionsEvent(calendarEvent.getResource().getPath(), userId, action, addData);
    }

    private static CalendarActionsEvent buildEventForCalendarEventReply(CalendarEvent calendarEvent, String userId, CalendarActions action) {
        HashMap<String, Object> addData = new HashMap<String, Object>(2);
        if (calendarEvent.isTopic()) {
            addData.put(OBJECT, new SocialEvent.BaseEventObject(CalendarActionsEvent.getDisplayName(calendarEvent), calendarEvent.getResource().getPath(), "article"));
            addData.put(TARGET, new SocialEvent.BaseEventObject(CalendarActionsEvent.getDisplayName(calendarEvent.getSourceComponent()), calendarEvent.getSourceComponentId(), "collection"));
        } else {
            addData.put(TARGET, new SocialEvent.BaseEventObject(CalendarActionsEvent.getDisplayName(calendarEvent.getParentComponent()), calendarEvent.getParentId(), "article"));
            addData.put(OBJECT, new SocialEvent.BaseEventObject(CalendarActionsEvent.getDisplayName(calendarEvent), calendarEvent.getResource().getPath(), "comment"));
        }
        return new CalendarActionsEvent(calendarEvent.getResource().getPath(), userId, action, addData);
    }

    private static String getDisplayName(SocialComponent socialComponent) {
        if (socialComponent instanceof CalendarEvent) {
            String defaultName = ((CalendarEvent)socialComponent).isTopic() ? "a calendar event" : "a calendar event reply";
            try {
                String name = ((CalendarEvent)socialComponent).getSubject();
                if (name != null) {
                    return name;
                }
                return defaultName;
            }
            catch (IllegalArgumentException e) {
                if (e.getCause() instanceof InvalidItemStateException) {
                    return defaultName;
                }
                throw e;
            }
        }
        if (socialComponent instanceof Calendar) {
            return ((Calendar)socialComponent).getName();
        }
        return null;
    }

    public static enum CalendarActions implements SocialEvent.SocialActions
    {
        CalendarEventAdded,
        CalendarEventReplyAdded,
        CalendarEventEdited,
        CalendarEventReplyEdited,
        CalendarEventDeleted,
        CalendarEventReplyDeleted;


        @Override
        public String getVerb() {
            switch (this) {
                case CalendarEventAdded: {
                    return "post";
                }
                case CalendarEventReplyAdded: {
                    return "add";
                }
                case CalendarEventEdited: {
                    return "update";
                }
                case CalendarEventReplyEdited: {
                    return "update";
                }
                case CalendarEventDeleted: {
                    return "delete";
                }
                case CalendarEventReplyDeleted: {
                    return "delete";
                }
            }
            throw new IllegalArgumentException();
        }
    }
}

