/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.commons.bundleactivator;

import com.adobe.cq.social.commons.SaferSlingPostValidator;
import com.adobe.cq.social.commons.bundleactivator.Activator;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Hashtable;
import org.apache.sling.api.SlingHttpServletRequest;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.ServiceRegistration;

class PostValidatorProvider
implements BundleListener {
    private static final String POST_VALIDATOR_CLASSNAME = "com.day.cq.opensocial.gadgets.servlet.security.InternalCQUserPreferencePostValidator";
    private ServiceRegistration postValidatorRegistration;
    private BundleContext bundleContext;

    private boolean matchBundleName(Bundle b) {
        return "com.day.cq.cq-opensocial".equals(b.getSymbolicName());
    }

    PostValidatorProvider(BundleContext inContext) {
        Bundle[] bundles;
        this.bundleContext = inContext;
        this.bundleContext.addBundleListener((BundleListener)this);
        for (Bundle b : bundles = this.bundleContext.getBundles()) {
            if (!this.matchBundleName(b)) continue;
            this.checkBundle(b);
            break;
        }
    }

    public synchronized void bundleChanged(BundleEvent event) {
        if (!this.matchBundleName(event.getBundle())) {
            return;
        }
        if (event.getType() == 2) {
            this.checkBundle(event.getBundle());
        } else if (this.postValidatorRegistration != null) {
            this.postValidatorRegistration.unregister();
            this.postValidatorRegistration = null;
        }
    }

    private synchronized void checkBundle(Bundle b) {
        try {
            Hashtable properties = new Hashtable();
            Class targetClass = b.loadClass(POST_VALIDATOR_CLASSNAME);
            Object service = Proxy.newProxyInstance(targetClass.getClassLoader(), new Class[]{targetClass}, (InvocationHandler)new ValidatorInvoker());
            if (this.postValidatorRegistration != null) {
                this.postValidatorRegistration.unregister();
            }
            this.postValidatorRegistration = this.bundleContext.registerService(POST_VALIDATOR_CLASSNAME, service, properties);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    synchronized void close() {
        if (this.postValidatorRegistration != null) {
            this.postValidatorRegistration.unregister();
            this.postValidatorRegistration = null;
        }
        this.bundleContext.removeBundleListener((BundleListener)this);
        this.bundleContext = null;
    }

    private static class ValidatorInvoker
    implements InvocationHandler {
        private ValidatorInvoker() {
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if ("reject".equals(method.getName())) {
                SaferSlingPostValidator validator = Activator.getService(SaferSlingPostValidator.class);
                return validator.reject((SlingHttpServletRequest)args[0]);
            }
            return null;
        }
    }
}

