/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.commons.comments.api;

import com.adobe.cq.social.SocialException;
import com.adobe.cq.social.commons.CommentSystem;
import com.adobe.cq.social.commons.comments.api.AbstractCommentCollectionConfiguration;
import com.adobe.cq.social.commons.comments.api.Comment;
import com.adobe.cq.social.commons.comments.api.CommentCollection;
import com.adobe.cq.social.commons.comments.api.CommentCollectionConfiguration;
import com.adobe.cq.social.commons.comments.api.PageInfo;
import com.adobe.cq.social.commons.comments.listing.CommentSocialComponentList;
import com.adobe.cq.social.commons.comments.listing.CommentSocialComponentListProvider;
import com.adobe.cq.social.commons.comments.listing.CommentSocialComponentListProviderManager;
import com.adobe.cq.social.scf.ClientUtilities;
import com.adobe.cq.social.scf.CollectionPagination;
import com.adobe.cq.social.scf.QueryRequestInfo;
import com.adobe.cq.social.scf.core.BaseSocialComponent;
import com.adobe.cq.social.scf.core.CollectionSortedOrder;
import com.adobe.cq.social.scf.core.ResourceID;
import com.adobe.cq.social.translation.TranslationSCFUtil;
import com.adobe.cq.social.ugcbase.SocialUtils;
import com.day.cq.wcm.api.Page;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.util.Calendar;
import java.util.List;
import javax.jcr.Session;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCommentCollection<C extends Comment, T extends CommentCollectionConfiguration>
extends BaseSocialComponent
implements CommentCollection<C, T> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractCommentCollection.class);
    private CommentSocialComponentListProviderManager commentListProviderManager;
    private Calendar lastModified;
    private Calendar created;
    private CommentSocialComponentList comments;
    private QueryRequestInfo queryInfo;
    private PageInfo pageInfo;
    private CommentSystem cs;
    private String friendlyUrl;
    private T configuration;
    private boolean mayPost = false;
    private boolean needComments = true;
    private boolean needCommentSystem = true;

    public AbstractCommentCollection(ResourceID id, ResourceResolver resolver, ClientUtilities clientUtils, CommentSocialComponentListProviderManager commentListProviderManager) {
        this(resolver.resolve(id.getResourceIdentifier()), clientUtils, commentListProviderManager);
    }

    public AbstractCommentCollection(Resource resource, ClientUtilities clientUtils, CommentSocialComponentListProviderManager commentListProviderManager) {
        super(resource, clientUtils);
        this.init(resource, clientUtils, QueryRequestInfo.DEFAULT_QUERY_INFO_FACTORY.create(), false, commentListProviderManager);
    }

    public AbstractCommentCollection(Resource resource, ClientUtilities clientUtils, QueryRequestInfo queryInfo, CommentSocialComponentListProviderManager commentListProviderManager) {
        super(resource, clientUtils);
        this.init(resource, clientUtils, queryInfo, true, commentListProviderManager);
    }

    private void init(Resource resource, ClientUtilities clientUtils, QueryRequestInfo queryInfo, boolean buildPages, CommentSocialComponentListProviderManager commentListProviderManager) throws SocialException {
        this.queryInfo = queryInfo;
        this.setCommentListProviderManager(commentListProviderManager);
    }

    private void initCommentSystem() {
        if (!this.needCommentSystem) {
            return;
        }
        this.needCommentSystem = false;
        Resource ugcResource = this.clientUtils.getSocialUtils().getUGCResource(this.resource, this.resource.getResourceType());
        this.cs = this.resource.adaptTo(CommentSystem.class);
        this.setLastModified(this.cs.getLastModified());
        this.setCreated(this.cs.getCreated());
        this.configuration = this.createConfiguration(this.cs.getResource());
    }

    private void initComments() {
        if (!this.needComments) {
            return;
        }
        this.needComments = false;
        QueryRequestInfo commentsQueryInfo = QueryRequestInfo.DEFAULT_QUERY_INFO_FACTORY.create(this.queryInfo);
        commentsQueryInfo.setSortOrder(this.getConfiguration().getSortOrder());
        CollectionPagination currentPagination = commentsQueryInfo.getPagination();
        int pageSize = this.configuration.getPageSize();
        if (this.queryInfo != null) {
            pageSize = this.queryInfo.getPagination() == CollectionPagination.DEFAULT_PAGINATION ? this.configuration.getPageSize() : currentPagination.getSize();
        }
        commentsQueryInfo.setPagination(new CollectionPagination(currentPagination.getOffset(), pageSize, currentPagination.getEmbedLevel() + 1, currentPagination.getSelectedIndex(), this.configuration.getPageSize()));
        CommentSocialComponentListProvider listProvider = this.getCommentListProviderManager().getCommentSocialComponentListProvider(this.resource, commentsQueryInfo);
        if (listProvider == null) {
            throw new SocialException(String.format("Could not find a SCF list provider for %1$s whose resource type is: %2$s.", this.resource.getPath(), this.resource.getResourceType()));
        }
        if (TranslationSCFUtil.isSmartRenderingOn(this.resource, this.clientUtils)) {
            commentsQueryInfo.setTranslationRequest(true);
        }
        this.comments = listProvider.getCommentSocialComponentList(this, commentsQueryInfo, this.clientUtils);
        this.pageInfo = new PageInfo(this, this.clientUtils, commentsQueryInfo.getPagination());
    }

    @Override
    public boolean getMayPost() {
        this.initCommentSystem();
        SocialUtils socialUtils = this.clientUtils.getSocialUtils();
        Session session = this.resource.getResourceResolver().adaptTo(Session.class);
        String aclPath = socialUtils.resourceToACLPath(this.cs.getResource());
        if (!this.clientUtils.userIsAnonymous()) {
            this.mayPost = this.clientUtils.getSocialUtils().canAddNode(session, aclPath == null ? "/content/usergenerated" : aclPath);
        }
        return this.mayPost;
    }

    @Override
    public void setPagination(CollectionPagination pagination) {
        this.initComments();
        this.queryInfo.setPagination(pagination);
        this.comments.setPagination(pagination);
        this.pageInfo = new PageInfo(this, this.clientUtils, pagination);
    }

    protected CollectionPagination getPagination() {
        return this.queryInfo.getPagination();
    }

    protected QueryRequestInfo getQueryRequestInfo() {
        return this.queryInfo;
    }

    @Override
    public Calendar getCreated() {
        this.initCommentSystem();
        return this.created;
    }

    @Override
    public Calendar getLastModified() {
        this.initCommentSystem();
        return this.lastModified;
    }

    @Override
    public int getTotalSize() {
        this.initComments();
        return this.comments.getTotalSize();
    }

    @Override
    public List<Object> getItems() {
        this.initComments();
        return this.comments;
    }

    @Override
    public void setSortedOrder(CollectionSortedOrder sortedOrder) {
        this.initComments();
        this.comments.setSortedOrder(sortedOrder);
    }

    @Override
    public PageInfo getPageInfo() {
        this.initComments();
        return this.pageInfo;
    }

    @Override
    @JsonIgnoreProperties
    public boolean isTaggingAllowed() {
        return Boolean.parseBoolean(this.properties.getProperty("allowTagging", "false"));
    }

    protected void setLastModified(Calendar lastModified) {
        this.lastModified = lastModified;
    }

    protected void setCreated(Calendar created) {
        this.created = created;
    }

    protected CommentSocialComponentListProviderManager getCommentListProviderManager() {
        return this.commentListProviderManager;
    }

    protected void setCommentListProviderManager(CommentSocialComponentListProviderManager commentListProviderManager) {
        this.commentListProviderManager = commentListProviderManager;
    }

    @Override
    public T getConfiguration() {
        this.initCommentSystem();
        return this.configuration;
    }

    protected T createConfiguration(Resource resource) {
        this.initCommentSystem();
        if (ResourceUtil.isNonExistingResource(this.cs.getResource()) && this.clientUtils != null) {
            ValueMap vm = this.clientUtils.getDesignProperties(resource, "sling:resourceType");
            return (T)new AbstractCommentCollectionConfiguration(vm);
        }
        return (T)new AbstractCommentCollectionConfiguration(resource);
    }

    @Override
    public String getFriendlyUrl() {
        Page page;
        if (this.friendlyUrl != null) {
            return this.friendlyUrl;
        }
        SocialUtils socialUtils = this.clientUtils.getSocialUtils();
        if (socialUtils != null && (page = socialUtils.getContainingPage(this.resource)) != null) {
            this.friendlyUrl = this.clientUtils.externalLink(page.getPath(), false) + ".html";
        }
        return this.friendlyUrl;
    }
}

