/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.commons.comments.api;

import com.adobe.cq.social.commons.comments.api.CommentCollectionConfiguration;
import com.adobe.cq.social.scf.core.CollectionSortedOrder;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;

public class AbstractCommentCollectionConfiguration
implements CommentCollectionConfiguration {
    private boolean allowsVoting;
    private boolean isRTEEnabled;
    private boolean allowsAttachment;
    private final boolean allowsTranslateAllButton;
    private final boolean allowsFlagging;
    private final boolean allowsClose;
    private final boolean allowsDeny;
    private final boolean allowsEdit;
    private final boolean allowsReply;
    private final boolean allowsFollowing;
    private boolean allowsDelete;
    private boolean allowsMove;
    private boolean allowsCustomFlagReason = true;
    private int pageSize = 10;
    private final ValueMap configValueMap;
    private final CollectionSortedOrder sortOrder;

    public AbstractCommentCollectionConfiguration(Resource commentSystem) {
        this(ResourceUtil.getValueMap(commentSystem));
    }

    public AbstractCommentCollectionConfiguration(@Nonnull ValueMap vm) {
        this.allowsVoting = vm.get("allowVoting", false);
        this.allowsEdit = true;
        this.pageSize = vm.get("maxPerPage", 10);
        this.allowsTranslateAllButton = vm.get("allowTranslateAllButton", false);
        this.allowsCustomFlagReason = vm.get("allowCustomFlagReason", false);
        this.allowsAttachment = vm.get("allowFileUploads", false);
        this.isRTEEnabled = vm.get("rteEnabled", false);
        this.allowsDeny = vm.get("allowDenyComments", false);
        this.allowsFlagging = vm.get("allowFlagComments", false);
        this.allowsFollowing = vm.get("allowFollowing", false);
        this.allowsReply = vm.get("allowRepliesToComments", false);
        this.allowsMove = vm.get("allowMoves", true);
        this.allowsClose = vm.get("allowCloseComments", false);
        this.allowsDelete = vm.get("allowDeleteComments", false);
        String sortOrderValue = vm.get("sortOrder", "DESC");
        this.sortOrder = StringUtils.equalsIgnoreCase((CharSequence)"asc", (CharSequence)sortOrderValue) ? CollectionSortedOrder.DEFAULT_ORDER : CollectionSortedOrder.REVERSED_ORDER;
        this.configValueMap = vm;
    }

    @Override
    @JsonProperty(value="isVotingAllowed")
    public boolean isVotingAllowed() {
        return this.allowsVoting;
    }

    @Override
    @JsonProperty(value="isAttachmentAllowed")
    public boolean isAttachmentAllowed() {
        return this.allowsAttachment;
    }

    @Override
    @JsonProperty(value="isRTEEnabled")
    public boolean isRTEEnabled() {
        return this.isRTEEnabled;
    }

    @Override
    @JsonProperty(value="isCustomFlagReasonAllowed")
    public boolean isCustomFlagReasonAllowed() {
        return this.allowsCustomFlagReason;
    }

    @Override
    @JsonProperty(value="isTranslateAllButtonAllowed")
    public boolean isTranslateAllButtonAllowed() {
        return this.allowsTranslateAllButton;
    }

    @Override
    public int getPageSize() {
        return this.pageSize;
    }

    @Override
    @JsonProperty(value="isFlaggingAllowed")
    public boolean isFlaggingAllowed() {
        return this.allowsFlagging;
    }

    @Override
    @JsonProperty(value="isCloseAllowed")
    public boolean isCloseAllowed() {
        return this.allowsClose;
    }

    @Override
    @JsonProperty(value="isDenyAllowed")
    public boolean isDenyAllowed() {
        return this.allowsDeny;
    }

    @Override
    @JsonProperty(value="isEditAllowed")
    public boolean isEditAllowed() {
        return this.allowsEdit;
    }

    @Override
    @JsonProperty(value="isReplyAllowed")
    public boolean isReplyAllowed() {
        return this.allowsReply;
    }

    @Override
    @JsonProperty(value="isDeleteAllowed")
    public boolean isDeleteAllowed() {
        return this.allowsDelete;
    }

    protected void setAllowsMove(boolean allowsMove) {
        this.allowsMove = allowsMove;
    }

    protected void setAllowsDelete(boolean flag) {
        this.allowsDelete = flag;
    }

    protected void setAllowsAttachment(boolean flag) {
        this.allowsAttachment = flag;
    }

    protected void setAllowsVoting(boolean flag) {
        this.allowsVoting = flag;
    }

    protected void setRTEEnabled(boolean flag) {
        this.isRTEEnabled = flag;
    }

    @Nonnull
    protected ValueMap getConfigValueMap() {
        return this.configValueMap;
    }

    @Override
    public boolean isFollowingAllowed() {
        return this.allowsFollowing;
    }

    @Override
    public CollectionSortedOrder getSortOrder() {
        return this.sortOrder;
    }

    @Override
    public boolean isMoveAllowed() {
        return this.allowsMove;
    }
}

