/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.commons.comments.endpoints;

import com.adobe.cq.social.commons.CollabUtil;
import com.adobe.cq.social.commons.CommentException;
import com.adobe.cq.social.commons.bundleactivator.Activator;
import com.adobe.cq.social.commons.comments.endpoints.CommentOperations;
import com.adobe.cq.social.commons.comments.endpoints.impl.CommentPostOperation;
import com.adobe.cq.social.scf.OperationException;
import com.adobe.cq.social.scf.SocialComponent;
import com.adobe.cq.social.scf.SocialComponentFactory;
import com.adobe.cq.social.scf.SocialComponentFactoryManager;
import com.adobe.cq.social.scf.SocialOperationResult;
import com.adobe.cq.social.scf.core.operations.AbstractSocialOperation;
import com.adobe.cq.social.serviceusers.internal.ServiceUserWrapper;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.jcr.api.SlingRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=false, componentAbstract=true)
public abstract class AbstractCommentOperation<T extends CommentOperations>
extends AbstractSocialOperation {
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY, policy=ReferencePolicy.STATIC)
    protected SlingRepository repository;
    private SlingRepository repositoryBugFix;
    private ServiceUserWrapper serviceUserWrapper;
    private static final Logger LOG = LoggerFactory.getLogger(CommentPostOperation.class);
    private static final String UGC_WRITER = "ugc-writer";
    @Reference
    private SocialComponentFactoryManager componentFactoryManager;

    protected abstract SocialOperationResult performOperation(SlingHttpServletRequest var1, Session var2) throws OperationException;

    protected Session getSessionFromResource(Resource resource) {
        return resource.getResourceResolver().adaptTo(Session.class);
    }

    protected Session createAdminSession() {
        try {
            if (this.repositoryBugFix == null) {
                this.repositoryBugFix = Activator.getService(SlingRepository.class);
            }
            if (this.serviceUserWrapper == null) {
                this.serviceUserWrapper = Activator.getService(ServiceUserWrapper.class);
            }
            return this.serviceUserWrapper.loginService(this.repositoryBugFix, UGC_WRITER);
        }
        catch (RepositoryException e) {
            LOG.error("error creating session: ", (Throwable)e);
            return null;
        }
    }

    protected void closeAdminSession(Session serviceSession) {
        if (serviceSession != null && serviceSession.isLive()) {
            serviceSession.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected SocialOperationResult performOperation(SlingHttpServletRequest request) throws OperationException {
        Session serviceSession = null;
        Session session = CollabUtil.hasModeratePermissions(request.getResource()) ? this.getSessionFromResource(request.getResource()) : (serviceSession = this.createAdminSession());
        if (null == session) {
            throw new CommentException("session unavailable");
        }
        try {
            SocialOperationResult result;
            SocialOperationResult socialOperationResult = result = this.performOperation(request, session);
            return socialOperationResult;
        }
        finally {
            this.closeAdminSession(serviceSession);
        }
    }

    protected SocialComponent getSocialComponentForComment(Resource comment, SlingHttpServletRequest request) {
        Resource resource = request.getResourceResolver().getResource(comment.getPath());
        SocialComponentFactory factory = this.componentFactoryManager.getSocialComponentFactory(resource);
        return factory != null ? factory.getSocialComponent(resource, request) : null;
    }

    protected abstract T getCommentOperationService();

    protected void bindRepository(SlingRepository slingRepository) {
        this.repository = slingRepository;
    }

    protected void unbindRepository(SlingRepository slingRepository) {
        if (this.repository == slingRepository) {
            this.repository = null;
        }
    }

    protected void bindComponentFactoryManager(SocialComponentFactoryManager socialComponentFactoryManager) {
        this.componentFactoryManager = socialComponentFactoryManager;
    }

    protected void unbindComponentFactoryManager(SocialComponentFactoryManager socialComponentFactoryManager) {
        if (this.componentFactoryManager == socialComponentFactoryManager) {
            this.componentFactoryManager = null;
        }
    }
}

