/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.commons.comments.endpoints;

import com.adobe.cq.social.commons.CollabUtil;
import com.adobe.cq.social.commons.Comment;
import com.adobe.cq.social.commons.CommentException;
import com.adobe.cq.social.commons.CommentSystem;
import com.adobe.cq.social.commons.CommentUtil;
import com.adobe.cq.social.commons.FileUploadSizeLimit;
import com.adobe.cq.social.commons.comments.endpoints.UploadOperationUtils;
import com.adobe.cq.social.commons.comments.scheduler.api.ScheduledPostService;
import com.adobe.cq.social.scf.InheritedOperationExtensionManager;
import com.adobe.cq.social.scf.Operation;
import com.adobe.cq.social.scf.OperationException;
import com.adobe.cq.social.scf.OperationExtension;
import com.adobe.cq.social.scf.SocialComponentFactoryManager;
import com.adobe.cq.social.scf.core.SocialEvent;
import com.adobe.cq.social.scf.core.operations.AbstractOperationService;
import com.adobe.cq.social.srp.SocialResourceProvider;
import com.adobe.cq.social.ugcbase.SocialUtils;
import com.adobe.cq.social.ugcbase.core.SocialResourceUtils;
import com.adobe.granite.security.user.UserProperties;
import com.day.cq.commons.Externalizer;
import com.day.cq.commons.date.DateUtil;
import com.day.cq.commons.date.InvalidDateException;
import com.day.cq.security.NoSuchAuthorizableException;
import com.day.cq.security.UserManagerFactory;
import com.day.text.Text;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessControlException;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import javax.activation.DataSource;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import org.apache.commons.collections.IteratorUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.request.RequestParameter;
import org.apache.sling.api.request.RequestParameterMap;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.commons.osgi.OsgiUtil;
import org.apache.sling.jcr.api.SlingRepository;
import org.apache.sling.settings.SlingSettingsService;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=false, componentAbstract=true)
@Properties(value={@Property(name="fieldWhitelist", value={"cq:tags", "tags", "composedFor"}, cardinality=100), @Property(name="attachmentTypeBlacklist", cardinality=0x7FFFFFFF, value={"DEFAULT"})})
public abstract class AbstractCommentOperationService<T extends OperationExtension, U extends Operation, S extends com.adobe.cq.social.commons.comments.api.Comment>
extends AbstractOperationService<T, U, S> {
    private static final String CQ_TAGS_PROPERTY = "cq:tags";
    public static final String CHARSET_PROPERTY = "_charset_";
    public static final String TAGS_PROPERTY = "tags";
    public static final String PROPERTY_FIELD_WHITELIST = "fieldWhitelist";
    public static final String[] RESERVED_PROPERTY_NAMES = new String[]{"email", "userIdentifier", "url"};
    public static final String PROPERTY_ATTACHMENT_TYPE_BLACKLIST = "attachmentTypeBlacklist";
    public static final String PROP_MESSAGE = "message";
    private static final String PN_COMPOSED_FOR = "composedFor";
    private static final Logger LOG = LoggerFactory.getLogger(AbstractCommentOperationService.class);
    @Reference
    public SocialComponentFactoryManager componentFactoryManager;
    @Reference
    protected ScheduledPostService futurePostScheduler;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY, policy=ReferencePolicy.STATIC)
    protected ResourceResolverFactory resourceResolverFactory;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY, policy=ReferencePolicy.STATIC)
    protected Externalizer externalizer;
    @Reference
    protected UserManagerFactory userManagerFactory;
    @Reference
    protected SlingSettingsService settingsService;
    @Reference
    protected EventAdmin eventAdmin;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY, policy=ReferencePolicy.STATIC)
    protected SlingRepository repository;
    @Reference
    protected InheritedOperationExtensionManager extensionManager;
    protected String[] fieldWhitelist;
    protected String[] attachmentTypeBlacklist;
    private ComponentContext context;

    @Override
    public InheritedOperationExtensionManager getInheritedOperationExtensionManager() {
        return this.extensionManager;
    }

    protected void getDefaultProperties(SlingHttpServletRequest request, Map<String, Object> props, Session session) throws RepositoryException, OperationException {
        String isPublishLater;
        String isDraft;
        String authId;
        Calendar cal = Calendar.getInstance();
        props.put("added", cal);
        String email = request.getParameter("email");
        if (email == null) {
            email = "";
        }
        props.put("email", email);
        String website = request.getParameter("url");
        if (website == null) {
            website = "";
        } else if (!"".equals(website) && !website.matches("^.*\\:\\/\\/.*$")) {
            website = "http://" + website;
        }
        props.put("url", website);
        props.put("ip", this.getClientIpAddr(request));
        String userAgent = request.getHeader("User-Agent");
        if (StringUtils.isNotBlank((CharSequence)userAgent)) {
            props.put("userAgent", request.getHeader("User-Agent"));
        }
        if (StringUtils.isNotBlank((CharSequence)(authId = this.getAuthorizableId(request, session)))) {
            props.put("authorizableId", authId);
        }
        this.getReferrerProperty(request, props);
        String value = request.getParameter(PROP_MESSAGE);
        if (StringUtils.isNotBlank((CharSequence)value)) {
            props.put(PROP_MESSAGE, value);
        }
        if (StringUtils.isNotBlank((CharSequence)(isDraft = request.getParameter("isDraft")))) {
            props.put("isDraft", Boolean.parseBoolean(isDraft));
        }
        if (StringUtils.isNotBlank((CharSequence)(isPublishLater = request.getParameter("isScheduled")))) {
            String publishDateString = request.getParameter("publishDate");
            if (StringUtils.isNotBlank((CharSequence)publishDateString)) {
                try {
                    Calendar publishDate = DateUtil.parseISO8601(publishDateString, TimeZone.getTimeZone("Etc/UTC"));
                    if (publishDate == null) {
                        throw new OperationException("Publish date and time format is incorrect", 400);
                    }
                    props.put("publishDate", publishDate);
                }
                catch (InvalidDateException e) {
                    LOG.error("Invalid date format for publishDate %s while trying to create/update comment", (Object)publishDateString);
                    throw new OperationException("Publish date and time format is incorrect", 400);
                }
                props.put("isScheduled", Boolean.parseBoolean(isPublishLater));
            } else {
                throw new OperationException("Publish date is empty", 400);
            }
        }
    }

    private void getReferrerProperty(SlingHttpServletRequest request, Map<String, Object> props) throws RepositoryException {
        String referrerUrl = this.getReferrer(request);
        if (StringUtils.isNotBlank((CharSequence)referrerUrl)) {
            props.put("referer", referrerUrl);
            try {
                URL url = new URL(referrerUrl);
                props.put("Referer", url.getFile());
            }
            catch (MalformedURLException e) {
                if (referrerUrl.matches("^https?:")) {
                    LOG.error("Error parsing referer url", (Throwable)e);
                }
                if (StringUtils.startsWith((CharSequence)referrerUrl, (CharSequence)"/")) {
                    LOG.info("Referrer URL does not have a protocol, returning passed in value {}", (Object)referrerUrl);
                    props.put("Referer", referrerUrl);
                }
                LOG.error("Error parsing referer url", (Throwable)e);
            }
        }
    }

    private String getClientIpAddr(SlingHttpServletRequest request) {
        String ip = request.getHeader("X-Forwarded-For");
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("HTTP_CLIENT_IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("HTTP_X_FORWARDED_FOR");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        return ip;
    }

    private void addProp(Map<String, Object> props, String name, SlingHttpServletRequest request, Session session) throws RepositoryException {
        String value = request.getParameter(name);
        if (StringUtils.isNotBlank((CharSequence)value)) {
            props.put(name, value);
        }
    }

    protected void getCustomProperties(SlingHttpServletRequest request, Map<String, Object> map, Session session) throws RepositoryException {
        RequestParameterMap params = request.getRequestParameterMap();
        for (String key : params.keySet()) {
            if (map.containsKey(key) || StringUtils.equals((CharSequence)key, (CharSequence)CHARSET_PROPERTY)) continue;
            if (!ArrayUtils.contains((Object[])this.fieldWhitelist, (Object)key) || key.contains(":")) {
                LOG.debug("skipped custom form field [{}], not in white list.", (Object)key);
                continue;
            }
            if (!ArrayUtils.contains((Object[])RESERVED_PROPERTY_NAMES, (Object)key)) {
                RequestParameter[] values = (RequestParameter[])params.get(key);
                if (values.length > 0 && values[0].isFormField()) {
                    Object value = values.length == 1 ? values[0].getString() : request.getParameterValues(key);
                    if (null == value) continue;
                    if (key.equals("userIdentifier") && ((String)value).length() == 0) {
                        LOG.debug("skipped custom form field \"userIdentifier\", empty value is not allowed.");
                        continue;
                    }
                    map.put(key, value);
                    continue;
                }
                LOG.debug("skipped custom form field [{}], empty or binary not allowed.", (Object)key);
                continue;
            }
            LOG.debug("skipped custom form field [{}], matches reserved field name.", (Object)key);
        }
    }

    protected List<DataSource> filterAttachments(List<DataSource> attachments, CommentSystem cs) {
        if (BooleanUtils.toBoolean((Boolean)cs.allowsAttachment())) {
            List<DataSource> attList = attachments;
            HashSet<String> whitelist = cs.getAllowedFileTypes() == null ? null : new HashSet<String>(cs.getAllowedFileTypes());
            Iterable<DataSource> filtered = CollabUtil.getAttachmentsFromDataSources(attList, new FileUploadSizeLimit(cs.getAttachmentSizeLimit(), cs.getAttachmentSizeLimit()), whitelist, this.attachmentTypeBlacklist);
            List filteredAttList = IteratorUtils.toList(filtered.iterator());
            return new ArrayList<DataSource>(filteredAttList);
        }
        return Collections.emptyList();
    }

    protected List<DataSource> getAttachmentsFromRequest(SlingHttpServletRequest request, CommentSystem cs) {
        if (BooleanUtils.toBoolean((Boolean)cs.allowsAttachment())) {
            RequestParameter[] fileRequestParameters = request.getRequestParameters("file");
            return CollabUtil.getAttachmentsFromRequest(fileRequestParameters, cs.getAttachmentSizeLimit(), cs.getAllowedFileTypes(), this.attachmentTypeBlacklist);
        }
        return Collections.emptyList();
    }

    protected boolean isAuthorMode() {
        return this.settingsService != null && this.settingsService.getRunModes().contains("author");
    }

    protected boolean isBot(SlingHttpServletRequest request) {
        String botCheck = request.getParameter("id");
        return botCheck == null || !botCheck.equals("nobot");
    }

    protected ResourceResolver getResourceResolver(Session session) throws LoginException {
        HashMap<String, Object> authInfo = new HashMap<String, Object>();
        authInfo.put("user.jcr.session", session);
        return this.resourceResolverFactory.getResourceResolver(authInfo);
    }

    protected CommentSystem getCommentSystem(Resource r, Session session) {
        Resource res;
        try {
            res = this.getResourceResolver(session).resolve(r.getPath());
        }
        catch (LoginException e) {
            LOG.error("Unable to fetch resource resolver for session", (Throwable)e);
            return null;
        }
        if (null != res) {
            return res.adaptTo(CommentSystem.class);
        }
        return null;
    }

    protected Comment getComment(Resource r, Session session) {
        Resource res;
        try {
            res = this.getResourceResolver(session).resolve(r.getPath());
        }
        catch (LoginException e) {
            LOG.error("Unable to fetch resource resolver for session", (Throwable)e);
            return null;
        }
        if (null != res) {
            return res.adaptTo(Comment.class);
        }
        return null;
    }

    protected String getAuthorizableId(SlingHttpServletRequest request, Session session) throws OperationException {
        String userIdentifier = request.getParameter("userIdentifier");
        if (StringUtils.isBlank((CharSequence)userIdentifier)) {
            userIdentifier = this.getUserIdFromRequest(request, "Anonymous");
        }
        String sessionUserId = this.getUserIdFromRequest(request, null);
        String id = "";
        if (StringUtils.isNotBlank((CharSequence)sessionUserId)) {
            boolean anonymous = "anonymous".equals(sessionUserId);
            boolean authorMode = this.isAuthorMode();
            if (!anonymous && authorMode) {
                boolean userExists = this.userExists(userIdentifier, session);
                boolean hasPermissions = this.hasPermissions(userIdentifier, this.getRequestSession(request), session);
                if (userExists && hasPermissions) {
                    id = userIdentifier;
                    if (!userIdentifier.equals(sessionUserId)) {
                        LOG.warn("host {} posted a comment with different userIdentifier ({}) than sessionUserId ({})", (Object[])new String[]{request.getRemoteAddr(), userIdentifier, sessionUserId});
                    }
                } else {
                    LOG.warn("host {} posted a comment with an unknown userIdentifier ({})", (Object)request.getRemoteAddr(), (Object)userIdentifier);
                }
            } else if (!anonymous && !authorMode) {
                String userId = sessionUserId;
                if (userIdentifier != null && !sessionUserId.equals(userIdentifier)) {
                    StringBuilder exception = new StringBuilder("host ");
                    exception.append(request.getRemoteAddr());
                    exception.append("posted a comment with suspect userIdentifier (");
                    exception.append(userIdentifier);
                    exception.append("), sessionUserId (");
                    exception.append(sessionUserId);
                    exception.append(")");
                    String exceptionMessage = exception.toString();
                    if (LOG.isWarnEnabled()) {
                        LOG.warn(exceptionMessage);
                    }
                    throw new OperationException(exceptionMessage, 404);
                }
                id = userId;
            } else {
                id = "anonymous";
            }
        }
        return id;
    }

    protected String getUserIdFromRequest(SlingHttpServletRequest request, String defaultValue) {
        String userIdentifier;
        UserProperties up = request.getResourceResolver().adaptTo(UserProperties.class);
        String string = userIdentifier = up == null ? null : up.getAuthorizableID();
        if (userIdentifier == null) {
            userIdentifier = defaultValue;
        }
        return userIdentifier;
    }

    protected UserProperties getSessionUserProperties(SlingHttpServletRequest request) {
        return request.getResourceResolver().adaptTo(UserProperties.class);
    }

    protected Session getRequestSession(SlingHttpServletRequest request) {
        return request.getResourceResolver().adaptTo(Session.class);
    }

    protected boolean userExists(String userId, Session session) {
        try {
            ResourceResolver resourceResolver = this.getResourceResolver(session);
            UserManager userManager = resourceResolver.adaptTo(UserManager.class);
            Authorizable user = userManager.getAuthorizable(userId);
            if (user != null) {
                return true;
            }
        }
        catch (RepositoryException e) {
            LOG.debug("Error checking for user existence", (Throwable)e);
        }
        catch (LoginException e) {
            LOG.debug("Error checking for user existence", (Throwable)e);
        }
        return false;
    }

    protected boolean isUserPrivileged(CommentSystem cs, Session session, String userId) {
        ResourceResolver resolver = null;
        try {
            resolver = this.getResourceResolver(session);
        }
        catch (LoginException e) {
            LOG.debug("Could not check for user privileges", (Throwable)e);
        }
        return CommentUtil.isUserPrivileged(cs.getResource(), resolver, userId);
    }

    protected boolean hasPermissions(String userIdentifier, Session requestSession, Session adminSession) {
        try {
            if (StringUtils.isNotBlank((CharSequence)userIdentifier)) {
                UserProperties userProperties = this.getResourceResolver(requestSession).adaptTo(UserProperties.class);
                if (requestSession != null) {
                    return requestSession.hasPermission(userProperties.getResource(".").getPath(), "read");
                }
            }
            return false;
        }
        catch (LoginException e) {
            return false;
        }
        catch (RepositoryException e) {
            return false;
        }
        catch (NoSuchAuthorizableException e) {
            return false;
        }
    }

    @Activate
    protected void activate(ComponentContext context) {
        this.context = context;
        this.fieldWhitelist = OsgiUtil.toStringArray(context.getProperties().get(PROPERTY_FIELD_WHITELIST));
        this.attachmentTypeBlacklist = OsgiUtil.toStringArray(context.getProperties().get(PROPERTY_ATTACHMENT_TYPE_BLACKLIST));
    }

    protected SlingRepository getRepository() {
        return this.repository;
    }

    protected Resource getResource(String path, Session session) {
        try {
            return this.getResourceResolver(session).getResource(path);
        }
        catch (LoginException e) {
            LOG.error("Error getching the resource resolver from session", (Throwable)e);
            return null;
        }
    }

    protected void postEvent(SocialEvent event) {
        EventAdmin localEventAdminRef = this.eventAdmin;
        if (null != localEventAdminRef) {
            localEventAdminRef.postEvent((Event)event);
        }
    }

    protected Resource create(Resource targetCommentSystemResource, CommentSystem cs, String author, Map<String, Object> props, List<DataSource> attachments, Session session) throws OperationException {
        Object v;
        boolean rootPathExists;
        String message;
        U createOperation = this.getCreateOperation();
        this.performBeforeActions(createOperation, session, targetCommentSystemResource, props);
        if (cs == null) {
            throw new OperationException("Failed to get comment system for target '" + targetCommentSystemResource.getPath() + "' ", 404);
        }
        try {
            message = this.getStringProperty(PROP_MESSAGE, props);
        }
        catch (RepositoryException e) {
            throw new OperationException("Failed to get the new message value", e, 500);
        }
        if (message == null || "".equals(message)) {
            throw new OperationException("Comment value is empty", 400);
        }
        Comment parent = targetCommentSystemResource.adaptTo(Comment.class);
        if (parent != null && parent.isClosed()) {
            throw new OperationException("Reply attempted on closed comment: " + targetCommentSystemResource.getPath(), 400);
        }
        if (parent != null && !this.mayReply(targetCommentSystemResource, cs)) {
            throw new OperationException("Reply is not allowed: " + targetCommentSystemResource.getPath(), 403);
        }
        long messageCharacterLimit = cs.getMessageCharacterLimit();
        String normalizedMessage = Normalizer.normalize(message, Normalizer.Form.NFC);
        if ((long)normalizedMessage.codePointCount(0, normalizedMessage.length()) > messageCharacterLimit) {
            throw new OperationException("Parameter message exceeded character limit", 400);
        }
        boolean bl = rootPathExists = this.getResource(cs.getRootPath(), session) != null;
        if (props.containsKey(PROP_MESSAGE)) {
            props.put("jcr:description", props.get(PROP_MESSAGE));
            props.remove(PROP_MESSAGE);
        }
        if (props.containsKey(TAGS_PROPERTY)) {
            props.put(CQ_TAGS_PROPERTY, props.get(TAGS_PROPERTY));
            props.remove(TAGS_PROPERTY);
        }
        if (props.containsKey("publishDate") && props.get("publishDate") instanceof Calendar) {
            Calendar d = Calendar.getInstance();
            d.setTime(((Calendar)props.get("publishDate")).getTime());
            props.put("publishDate", d);
        }
        if (props.containsKey(CQ_TAGS_PROPERTY) && !((v = props.get(CQ_TAGS_PROPERTY)) instanceof String[])) {
            if (v instanceof String) {
                if (String.valueOf(v).isEmpty()) {
                    props.remove(CQ_TAGS_PROPERTY);
                } else {
                    props.put(CQ_TAGS_PROPERTY, new String[]{(String)v});
                }
            } else {
                throw new OperationException("Parameter cq:tags is not a String Array", 400);
            }
        }
        for (String key : props.keySet()) {
            if (!StringUtils.startsWith((CharSequence)key, (CharSequence)"scf:")) continue;
            props.remove(key);
        }
        try {
            ModifiableValueMap vm;
            Comment comment = cs.addComment(message, author, attachments, "", this.getResourceType(targetCommentSystemResource), props);
            if (SocialResourceUtils.isSocialResource(comment.getResource()) && (vm = comment.getResource().adaptTo(ModifiableValueMap.class)) != null) {
                String entityUrl = this.getEntityUrl(comment.getResource());
                if (!StringUtils.isEmpty((CharSequence)entityUrl)) {
                    vm.put("social:entity", entityUrl);
                }
                if (!cs.isModerated()) {
                    vm.put("approved", true);
                }
                vm.put("eventTopic", this.getEventTopic());
                if (vm.get("publishDate", Calendar.class) == null && !vm.get("isDraft", false).booleanValue()) {
                    vm.put("publishDate", Calendar.getInstance());
                }
            }
            String userId = author;
            if (props.containsKey(PN_COMPOSED_FOR)) {
                userId = comment.getProperty(PN_COMPOSED_FOR, author);
            }
            boolean throwEvent = true;
            if (comment.getProperty("isDraft", false).booleanValue()) {
                Calendar publishDate;
                throwEvent = false;
                if (comment.getProperty("publishDate", Calendar.class) != null && (publishDate = (Calendar)((Object)comment.getProperty("publishDate", Calendar.class))).compareTo(Calendar.getInstance()) <= 0) {
                    ModifiableValueMap vm2 = comment.getResource().adaptTo(ModifiableValueMap.class);
                    vm2.put("isDraft", false);
                    vm2.put("cq:lastModified", publishDate);
                    vm2.put("added", publishDate.getTime());
                    throwEvent = true;
                }
            }
            cs.save();
            LOG.info("Comment created: " + comment.getPath());
            S commentComp = this.getSocialComponentForResource(comment.getResource());
            this.performAfterActions(createOperation, session, commentComp, props);
            if (throwEvent) {
                this.postCreateEvent(commentComp, userId);
            }
            return comment.getResource();
        }
        catch (CommentException e) {
            this.cleanupFailure(session);
            throw new OperationException("Failed to create comment.", e, 500);
        }
    }

    private void cleanupFailure(Session session) {
        try {
            session.refresh(false);
        }
        catch (RepositoryException e) {
            LOG.info("Failed to refresh the session", (Throwable)e);
        }
    }

    public Resource create(Resource root, String author, Map<String, Object> props, List<DataSource> attachments, Session session) throws OperationException {
        CommentSystem cs = this.getCommentSystem(root, session);
        List<DataSource> filteredAttachments = this.filterAttachments(attachments, cs);
        return this.create(root, cs, author, props, filteredAttachments, session);
    }

    public Resource create(SlingHttpServletRequest request, Session session) throws OperationException {
        Resource resource = request.getResource();
        CommentSystem cs = this.getCommentSystem(resource, session);
        this.validateParameters(request);
        String name = this.getAuthorizableId(request, session);
        if (!this.mayPost(request, cs, name)) {
            throw new OperationException("User not allowed to post to forum at " + cs.getPath(), 412);
        }
        HashMap<String, Object> props = new HashMap<String, Object>();
        try {
            this.getDefaultProperties(request, props, session);
            this.getCustomProperties(request, props, session);
        }
        catch (CommentException e) {
            throw new OperationException("Failed to create comment", e, 203);
        }
        catch (RepositoryException e) {
            throw new OperationException("Failed to get comment properties", e, 500);
        }
        List<DataSource> attachments = this.getAttachmentsFromRequest(request, cs);
        return this.create(resource, cs, name, props, attachments, session);
    }

    public Resource uploadImage(SlingHttpServletRequest request, Session session) throws OperationException {
        Resource resource = request.getResource();
        String name = this.getAuthorizableId(request, session);
        CommentSystem cs = this.getCommentSystem(resource, session);
        if (!this.mayPost(request, cs, name)) {
            throw new OperationException("User not allowed to post to comment at " + cs.getPath(), 412);
        }
        List<DataSource> attachments = this.getAttachmentsFromRequest(request, cs);
        HashMap<String, Object> props = new HashMap<String, Object>();
        try {
            this.getDefaultProperties(request, props, session);
            this.getCustomProperties(request, props, session);
        }
        catch (CommentException e) {
            LOG.error("Failed to get request properties at " + resource.getPath(), (Throwable)e);
            throw new OperationException("Failed to get request properties", e, 203);
        }
        catch (RepositoryException e) {
            LOG.error("Failed to get request properties @ " + resource.getPath(), (Throwable)e);
            throw new OperationException("Failed to get comment properties", e, 500);
        }
        return this.uploadImageToTemp(resource, cs, name, attachments, session);
    }

    public Resource uploadImageToTemp(Resource targetCommentSystemResource, CommentSystem cs, String author, List<DataSource> attachments, Session session) throws OperationException {
        block8: {
            if (cs == null) {
                throw new OperationException("Failed to get comment system for target '" + targetCommentSystemResource.getPath() + "' ", 404);
            }
            List<DataSource> filteredAttachments = this.filterAttachments(attachments, cs);
            Comment parent = targetCommentSystemResource.adaptTo(Comment.class);
            if (parent != null && parent.isClosed()) {
                throw new OperationException("Reply attempted on closed comment: " + targetCommentSystemResource.getPath(), 400);
            }
            if (parent != null && !this.mayReply(targetCommentSystemResource, cs)) {
                throw new OperationException("Reply is not allowed: " + targetCommentSystemResource.getPath(), 403);
            }
            if (attachments.size() == 1) {
                DataSource data = attachments.get(0);
                try {
                    Node uploadRoot = UploadOperationUtils.createOrGetUploadResource(session, targetCommentSystemResource.getPath());
                    if (attachments.size() == 1) {
                        String name = Text.getName(data.getName());
                        Node attachment = UploadOperationUtils.addAttachment(uploadRoot, name, data.getInputStream(), data.getContentType());
                        session.save();
                        return targetCommentSystemResource.getResourceResolver().getResource(attachment.getPath());
                    }
                    break block8;
                }
                catch (RepositoryException e) {
                    throw new OperationException("Could not upload image", e, 500);
                }
                catch (IOException e) {
                    throw new OperationException("Could not upload image", e, 500);
                }
            }
            throw new OperationException("Invalid number of attachment", 500);
        }
        return null;
    }

    public Resource uploadImage(Resource targetCommentSystemResource, CommentSystem cs, String author, Map<String, Object> props, List<DataSource> attachments, Session session) throws OperationException {
        if (cs == null) {
            LOG.error("Failed to get comment system for target " + targetCommentSystemResource.getPath());
            throw new OperationException("Failed to get comment system for target '" + targetCommentSystemResource.getPath() + "' ", 404);
        }
        U uploadImageOperation = this.getUploadImageOperation();
        if (uploadImageOperation != null) {
            Comment parent = targetCommentSystemResource.adaptTo(Comment.class);
            this.performBeforeActions(uploadImageOperation, session, parent.getResource(), props);
            List<DataSource> filteredAttachments = this.filterAttachments(attachments, cs);
            if (parent != null && parent.isClosed()) {
                LOG.error("Reply attempted on closed comment: " + targetCommentSystemResource.getPath());
                throw new OperationException("Reply attempted on closed comment: " + targetCommentSystemResource.getPath(), 400);
            }
            if (parent != null && !this.mayReply(targetCommentSystemResource, cs)) {
                LOG.error("Reply is not allowed: " + targetCommentSystemResource.getPath());
                throw new OperationException("Reply is not allowed: " + targetCommentSystemResource.getPath(), 403);
            }
            if (attachments.size() == 1) {
                DataSource data = attachments.get(0);
                try {
                    Resource image = parent.addImage(data.getName(), data.getInputStream(), data.getContentType());
                    this.performAfterActions(uploadImageOperation, session, this.getSocialComponentForResource(targetCommentSystemResource), props);
                    image.getResourceResolver().commit();
                    return image;
                }
                catch (IOException e) {
                    LOG.error("IOException while trying to add image at " + targetCommentSystemResource.getPath());
                    throw new OperationException("IOException while trying to add image", e, 500);
                }
            }
            LOG.error("Only one attachment supported " + targetCommentSystemResource.getPath());
            throw new OperationException("Invalid number of attachment", 500);
        }
        throw new OperationException("Unsupported operation", 400);
    }

    private String getStringProperty(String key, Map<String, Object> props) throws RepositoryException {
        Object obj = props.get(key);
        if (obj == null) {
            return null;
        }
        if (obj instanceof Value) {
            return ((Value)obj).getString();
        }
        return obj.toString();
    }

    protected void validateParameters(SlingHttpServletRequest request) throws OperationException {
        String message = request.getParameter(PROP_MESSAGE);
        if (message == null || "".equals(message)) {
            throw new OperationException("Comment value is empty", 400);
        }
        if (this.isBot(request)) {
            throw new OperationException("Bot check failed: Parameter id is missing or has unexpected value", 412);
        }
    }

    protected boolean mayPost(SlingHttpServletRequest request, CommentSystem cs, String userId) {
        ResourceResolver resolver = request.getResourceResolver();
        if (null != resolver && null != cs) {
            if ("anonymous".equals(userId)) {
                return false;
            }
            SocialUtils socialUtils = resolver.adaptTo(SocialUtils.class);
            Resource r = resolver.getResource(cs.getPath());
            if (null != r) {
                r = resolver.getResource(socialUtils.resourceToACLPath(r));
            }
            if (null == r) {
                r = resolver.getResource("/content/usergenerated");
            }
            return CollabUtil.canAddNode(resolver.adaptTo(Session.class), r.getPath());
        }
        return false;
    }

    protected boolean mayEdit(SlingHttpServletRequest request, CommentSystem cs, String userId) throws OperationException {
        boolean mayEdit;
        boolean bl = mayEdit = CollabUtil.hasModeratePermissions(request.getResource()) || CollabUtil.isResourceOwner(request.getResource());
        if (mayEdit) {
            return true;
        }
        ValueMap props = request.getResource().adaptTo(ValueMap.class);
        String composedBy = props.get("composedBy", "");
        return mayEdit || StringUtils.equals((CharSequence)userId, (CharSequence)composedBy);
    }

    protected boolean mayReply(Resource root, CommentSystem cs) throws OperationException {
        return cs.allowsReplies();
    }

    protected boolean mayDelete(SlingHttpServletRequest request, CommentSystem cs, String userId) throws OperationException {
        return this.mayEdit(request, cs, userId);
    }

    protected String getAuthorFromRequest(SlingHttpServletRequest request) {
        String name = request.getParameter("userIdentifier");
        if (StringUtils.isBlank((CharSequence)name)) {
            UserProperties up = request.getResourceResolver().adaptTo(UserProperties.class);
            String string = name = up == null ? null : up.getAuthorizableID();
            if (name == null) {
                name = "Anonymous";
            }
        }
        return name;
    }

    public Resource update(SlingHttpServletRequest request, Session session) throws OperationException {
        Resource resource = request.getResource();
        CommentSystem cs = this.getCommentSystem(resource, session);
        this.validateParameters(request);
        String userId = this.getAuthorizableId(request, session);
        if (!this.mayEdit(request, cs, userId)) {
            throw new OperationException("User not allowed to edit UGC at " + cs.getPath(), 412);
        }
        HashMap<String, Object> props = new HashMap<String, Object>();
        try {
            this.getDefaultProperties(request, props, session);
            this.getCustomProperties(request, props, session);
        }
        catch (CommentException e) {
            throw new OperationException("Failed to update UGC", e, 203);
        }
        catch (RepositoryException e) {
            throw new OperationException("Failed to get comment properties", e, 500);
        }
        List<DataSource> attachments = this.getAttachmentsFromRequest(request, cs);
        return this.update(resource, cs, props, attachments, session, userId);
    }

    protected Resource update(Resource commentResource, CommentSystem cs, Map<String, Object> props, List<DataSource> attachments, Session session, String author) throws OperationException {
        Comment comment = this.getComment(commentResource, session);
        if (comment == null) {
            throw new OperationException("Failed to get Commment for target " + commentResource.getPath(), 404);
        }
        if (comment.isClosed() && !CollabUtil.hasModeratePermissions(commentResource)) {
            throw new OperationException("Update attempted on closed comment: " + commentResource.getPath(), 400);
        }
        U updateOperation = this.getUpdateOperation();
        this.performBeforeActions(updateOperation, session, comment.getResource(), props);
        if (cs == null) {
            throw new OperationException("Failed to get comment system for target '" + comment.getResource().getPath() + "' ", 404);
        }
        try {
            ModifiableValueMap properties = comment.getResource().adaptTo(ModifiableValueMap.class);
            Calendar oldPublishDate = (Calendar)((Object)properties.get("publishDate", Calendar.class));
            boolean usedToBeDraft = properties.get("isDraft", false);
            if (props.containsKey(TAGS_PROPERTY)) {
                props.put(CQ_TAGS_PROPERTY, props.get(TAGS_PROPERTY));
                props.remove(TAGS_PROPERTY);
            }
            properties.remove(CQ_TAGS_PROPERTY);
            for (Map.Entry<String, Object> entry : props.entrySet()) {
                if (entry.getKey() == PROP_MESSAGE) {
                    long messageCharacterLimit = cs.getMessageCharacterLimit();
                    String message = CollabUtil.getValueString(entry.getValue());
                    if (message == null) {
                        throw new OperationException("Null value for comment message.", 400);
                    }
                    String normalizedMessage = Normalizer.normalize(message, Normalizer.Form.NFC);
                    if ((long)normalizedMessage.codePointCount(0, normalizedMessage.length()) > messageCharacterLimit) {
                        throw new OperationException("Parameter message exceeded character limit", 400);
                    }
                    properties.put("jcr:description", entry.getValue());
                    continue;
                }
                properties.put(entry.getKey(), entry.getValue());
            }
            if (cs.isModerated()) {
                properties.remove("approved");
            }
            properties.put("moderate", Boolean.TRUE);
            properties.put("cq:lastModified", Calendar.getInstance());
            if (CollabUtil.hasModeratePermissions(comment.getResource())) {
                properties.put("cq:lastModifiedBy", session.getUserID());
            } else {
                properties.put("cq:lastModifiedBy", comment.getAuthor().getId());
            }
            this.updateAttachments(comment, attachments);
            boolean isCurrentDraft = false;
            if (props.containsKey("isDraft")) {
                isCurrentDraft = (Boolean)props.get("isDraft");
            }
            Calendar currentPublishDate = null;
            if (props.containsKey("publishDate")) {
                currentPublishDate = (Calendar)props.get("publishDate");
            }
            boolean cancelJob = false;
            boolean forcePublish = false;
            if (!isCurrentDraft && usedToBeDraft && oldPublishDate != null) {
                cancelJob = true;
            } else if (isCurrentDraft && oldPublishDate != null && (currentPublishDate == null || oldPublishDate.compareTo(currentPublishDate) != 0)) {
                cancelJob = true;
            }
            if (isCurrentDraft && currentPublishDate != null && currentPublishDate.compareTo(Calendar.getInstance()) <= 0) {
                properties.put("isDraft", Boolean.FALSE);
                properties.put("cq:lastModified", currentPublishDate);
                properties.put("added", currentPublishDate.getTime());
                cancelJob = true;
                forcePublish = true;
            }
            if (cancelJob) {
                String oldJob = (String)((Object)properties.get("publishJobId", String.class));
                if (currentPublishDate == null) {
                    properties.remove("publishDate");
                }
                if (StringUtils.isNotEmpty((CharSequence)oldJob)) {
                    this.futurePostScheduler.unschedule(oldJob);
                    properties.remove("publishJobId");
                }
            }
            comment.getResource().getResourceResolver().commit();
            Comment updatedComment = comment.getResource().adaptTo(Comment.class);
            S commentComp = this.getSocialComponentForResource(updatedComment.getResource());
            if (!isCurrentDraft) {
                if (!usedToBeDraft) {
                    this.postUpdateEvent(commentComp, author);
                } else {
                    this.postCreateEvent(commentComp, author);
                }
            } else if (forcePublish) {
                this.postCreateEvent(commentComp, author);
            }
            this.performAfterActions(updateOperation, session, commentComp, props);
            return updatedComment.getResource();
        }
        catch (RepositoryException e) {
            throw new OperationException("Failed to update comment", e, 500);
        }
        catch (PersistenceException e) {
            throw new OperationException("Failed to update comment", e, 500);
        }
        catch (IllegalArgumentException e) {
            throw new OperationException("Failed to update comment", e, 500);
        }
    }

    protected void updateAttachments(Comment comment, List<DataSource> attachments) {
        if (attachments != null) {
            comment.addAttachments(attachments);
        }
    }

    public Resource update(Resource commentResource, Map<String, Object> props, List<DataSource> attachments, Session session) throws OperationException {
        CommentSystem cs = this.getCommentSystem(commentResource, session);
        return this.update(commentResource, cs, props, attachments, session, commentResource.getResourceResolver().getUserID());
    }

    public void delete(SlingHttpServletRequest request, Session session) throws OperationException {
        Resource reqResource = request.getResource();
        CommentSystem cs = this.getCommentSystem(reqResource, session);
        Comment comment = this.getComment(reqResource, session);
        boolean isDraft = comment.getProperty("isDraft", false);
        String userId = this.getAuthorizableId(request, session);
        if (!cs.allowsDelete() && !isDraft) {
            throw new OperationException("Deletion is not enabling.", 403);
        }
        if (!this.mayDelete(request, cs, userId)) {
            throw new OperationException("User not allowed to delete " + cs.getPath(), 404);
        }
        this.delete(reqResource, cs, session);
    }

    public void delete(Resource commentResource, Session session) throws OperationException {
        CommentSystem cs = this.getCommentSystem(commentResource, session);
        this.delete(commentResource, cs, session);
    }

    public Resource move(SlingHttpServletRequest request, Session session) throws OperationException {
        String resourcePath = request.getParameter("resourcePath");
        String parentPath = request.getParameter("parentPath");
        ResourceResolver resolver = request.getResourceResolver();
        if (null == resolver) {
            throw new OperationException("Request does not provide a resource resolver", 403);
        }
        Resource resource = resolver.getResource(resourcePath);
        if (null == resource) {
            throw new OperationException("The resource to be moved could not be found at " + resourcePath, 404);
        }
        Resource parent = resolver.getResource(parentPath);
        if (null == parent) {
            throw new OperationException("The target resource could not be found at " + parentPath, 404);
        }
        return this.move(resource, parent, request.getResourceResolver().adaptTo(Session.class));
    }

    public Resource move(Resource commentResource, Resource parentResource, Session session) throws OperationException {
        ResourceResolver resolver = commentResource.getResourceResolver();
        String resourcePath = commentResource.getPath();
        String parentPath = parentResource.getPath();
        SocialUtils socialUtils = resolver.adaptTo(SocialUtils.class);
        try {
            if (!socialUtils.hasModeratePermissions(commentResource) || !socialUtils.hasModeratePermissions(parentResource)) {
                throw new OperationException("The user does not have sufficient privileges to perform the move operation", 403);
            }
            if (!SocialResourceUtils.isCloudUGC(parentPath)) {
                session.checkPermission(socialUtils.resourceToUGCStoragePath(parentResource), "add_node");
            } else {
                session.checkPermission(parentPath, "add_node");
            }
        }
        catch (AccessControlException e) {
            throw new OperationException("The user does not have sufficient privileges to perform the move operation", e, 403);
        }
        catch (RepositoryException e) {
            throw new OperationException("Unable to complete a permission check", e, 500);
        }
        SocialResourceProvider srp = socialUtils.getConfiguredProvider(commentResource);
        try {
            Resource newResource = srp.move(resolver, resourcePath, parentPath);
            if (null == newResource) {
                srp.revert(resolver);
                throw new OperationException("Unable to move " + resourcePath + " to " + parentPath, 500);
            }
            U createOperation = this.getCreateOperation();
            Map props = newResource.adaptTo(ValueMap.class);
            this.performBeforeActions(createOperation, session, resolver.getResource((String)props.get("social:rootCommentSystem")), props);
            srp.commit(resolver);
            S commentComp = this.getSocialComponentForResource(newResource);
            this.performAfterActions(createOperation, session, commentComp, props);
            this.postCreateEvent(commentComp, session.getUserID());
            return newResource;
        }
        catch (PersistenceException e) {
            srp.revert(resolver);
            throw new OperationException("Unable to move " + resourcePath + " to " + parentPath, e, 500);
        }
    }

    public void delete(Resource commentResource, CommentSystem cs, Session session) throws OperationException {
        LOG.debug("delete for  {} ", (Object)commentResource.getPath());
        try {
            Comment comment = this.getComment(commentResource, session);
            if (comment == null) {
                throw new OperationException("Unable to get comment for resource at " + commentResource.getPath(), 404);
            }
            if (comment.isClosed() && !CollabUtil.hasModeratePermissions(commentResource)) {
                throw new OperationException("Delete attempted on closed comment: " + commentResource.getPath(), 400);
            }
            S commentComp = this.getSocialComponentForResource(comment.getResource());
            U deleteOperation = this.getDeleteOperation();
            this.performBeforeActions(deleteOperation, session, comment.getResource(), Collections.<String, Object>emptyMap());
            List<String> paths = this.getPaths(commentResource.getResourceResolver(), comment.getPath());
            commentComp.getParentComponent();
            String author = commentResource.getResourceResolver().getUserID();
            boolean throwEvent = true;
            ValueMap properties = comment.getResource().adaptTo(ModifiableValueMap.class);
            Boolean isDraft = (Boolean)((Object)properties.get("isDraft", Boolean.class));
            if (isDraft != null && isDraft.booleanValue()) {
                throwEvent = false;
                String oldJob = (String)((Object)properties.get("publishJobId", String.class));
                if (StringUtils.isNotEmpty((CharSequence)oldJob)) {
                    this.futurePostScheduler.unschedule(oldJob);
                }
            }
            comment.remove();
            comment.getCommentSystem().save();
            if (throwEvent) {
                this.postDeleteEvent(commentComp, author);
            }
            this.performAfterActions(deleteOperation, session, commentComp, Collections.<String, Object>emptyMap());
        }
        catch (RepositoryException e) {
            throw new OperationException("Failed to delete comment", e, 404);
        }
    }

    private List<String> getPaths(ResourceResolver resolver, String path) throws RepositoryException {
        ArrayList<String> paths = new ArrayList<String>();
        Resource resource = resolver.getResource(path);
        if (resource == null) {
            return paths;
        }
        for (Resource child : resource.getChildren()) {
            paths.addAll(this.getPaths(resolver, child.getPath()));
        }
        paths.add(path);
        return paths;
    }

    protected String getEntityUrl(Resource resource) {
        return resource.adaptTo(CommentSystem.class).getUrl();
    }

    protected String getEventTopic() {
        return "comment";
    }

    protected abstract S getSocialComponentForResource(Resource var1);

    protected abstract void postCreateEvent(S var1, String var2);

    protected abstract void postUpdateEvent(S var1, String var2);

    protected abstract void postDeleteEvent(S var1, String var2);

    protected abstract U getCreateOperation();

    protected abstract U getDeleteOperation();

    protected abstract U getUpdateOperation();

    protected abstract U getUploadImageOperation();

    protected abstract String getResourceType(Resource var1);

    protected void bindComponentFactoryManager(SocialComponentFactoryManager socialComponentFactoryManager) {
        this.componentFactoryManager = socialComponentFactoryManager;
    }

    protected void unbindComponentFactoryManager(SocialComponentFactoryManager socialComponentFactoryManager) {
        if (this.componentFactoryManager == socialComponentFactoryManager) {
            this.componentFactoryManager = null;
        }
    }

    protected void bindFuturePostScheduler(ScheduledPostService scheduledPostService) {
        this.futurePostScheduler = scheduledPostService;
    }

    protected void unbindFuturePostScheduler(ScheduledPostService scheduledPostService) {
        if (this.futurePostScheduler == scheduledPostService) {
            this.futurePostScheduler = null;
        }
    }

    protected void bindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resourceResolverFactory = resourceResolverFactory;
    }

    protected void unbindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resourceResolverFactory == resourceResolverFactory) {
            this.resourceResolverFactory = null;
        }
    }

    protected void bindExternalizer(Externalizer externalizer) {
        this.externalizer = externalizer;
    }

    protected void unbindExternalizer(Externalizer externalizer) {
        if (this.externalizer == externalizer) {
            this.externalizer = null;
        }
    }

    protected void bindUserManagerFactory(UserManagerFactory userManagerFactory) {
        this.userManagerFactory = userManagerFactory;
    }

    protected void unbindUserManagerFactory(UserManagerFactory userManagerFactory) {
        if (this.userManagerFactory == userManagerFactory) {
            this.userManagerFactory = null;
        }
    }

    protected void bindSettingsService(SlingSettingsService slingSettingsService) {
        this.settingsService = slingSettingsService;
    }

    protected void unbindSettingsService(SlingSettingsService slingSettingsService) {
        if (this.settingsService == slingSettingsService) {
            this.settingsService = null;
        }
    }

    protected void bindEventAdmin(EventAdmin eventAdmin) {
        this.eventAdmin = eventAdmin;
    }

    protected void unbindEventAdmin(EventAdmin eventAdmin) {
        if (this.eventAdmin == eventAdmin) {
            this.eventAdmin = null;
        }
    }

    protected void bindRepository(SlingRepository slingRepository) {
        this.repository = slingRepository;
    }

    protected void unbindRepository(SlingRepository slingRepository) {
        if (this.repository == slingRepository) {
            this.repository = null;
        }
    }

    protected void bindExtensionManager(InheritedOperationExtensionManager inheritedOperationExtensionManager) {
        this.extensionManager = inheritedOperationExtensionManager;
    }

    protected void unbindExtensionManager(InheritedOperationExtensionManager inheritedOperationExtensionManager) {
        if (this.extensionManager == inheritedOperationExtensionManager) {
            this.extensionManager = null;
        }
    }
}

