/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.commons.comments.endpoints;

import com.adobe.cq.social.commons.Comment;
import com.adobe.cq.social.scf.ClientUtilities;
import com.adobe.cq.social.ugcbase.SocialUtils;
import com.day.cq.commons.Externalizer;
import com.day.text.Text;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.commons.JcrUtils;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UploadOperationUtils {
    private static String UGC_ROOT_DIR = "/content/usergenerated";
    private static String TEMP_ROOT_DIR = "tmp";
    private static String SOCIAL_DIR = "social";
    private static String[] SKIP_DIRS = new String[]{"jcr:content"};
    private static String IMAGE_ELEMENT = "img";
    private static String SRC = "src";
    private static String SRC_ELEMENT = SRC + "=";
    private static String IMAGES_DIR = "images";
    private static String TEMP_DIR = UGC_ROOT_DIR + "/" + TEMP_ROOT_DIR + "/" + SOCIAL_DIR + "/" + IMAGES_DIR;
    private static final Logger LOG = LoggerFactory.getLogger(UploadOperationUtils.class);

    public static Node addAttachment(Node root, String name, InputStream inputStream, String mimeType) throws RepositoryException {
        Node contentNode;
        Node attachmentNode;
        String fileName = FilenameUtils.getName((String)name);
        if (root.hasNode(name)) {
            attachmentNode = root.getNode(name);
            contentNode = attachmentNode.getNode("jcr:content");
        } else {
            attachmentNode = root.addNode(name, "nt:file");
            contentNode = attachmentNode.addNode("jcr:content", "nt:resource");
        }
        contentNode.setProperty("jcr:mimeType", mimeType);
        contentNode.setProperty("jcr:data", inputStream);
        contentNode.setProperty("jcr:lastModified", Calendar.getInstance());
        return attachmentNode;
    }

    public static Node createOrGetUploadResource(Session session, String path) throws PathNotFoundException, RepositoryException {
        Node ugc = session.getNode(UGC_ROOT_DIR);
        if (ugc != null) {
            int i;
            Node tmp = JcrUtils.getOrAddFolder(ugc, TEMP_ROOT_DIR);
            String[] folders = path.split("/");
            Node parent = JcrUtils.getOrAddFolder(tmp, SOCIAL_DIR);
            parent = JcrUtils.getOrAddFolder(parent, IMAGES_DIR);
            int n = i = path.startsWith("/") ? 0 : 1;
            while (i < folders.length) {
                if (!UploadOperationUtils.skipFolder(folders[i])) {
                    parent = JcrUtils.getOrAddFolder(parent, folders[i]);
                }
                ++i;
            }
            return parent;
        }
        return null;
    }

    public static void moveImages(Externalizer externalizer, boolean author, SocialUtils socialUtils, com.adobe.cq.social.commons.comments.api.Comment comment) throws PersistenceException {
        String message = comment.getMessage();
        if (message.contains(IMAGE_ELEMENT)) {
            Resource resource = comment.getResource();
            Comment ocomment = resource.adaptTo(Comment.class);
            ResourceResolver resolver = comment.getResource().getResourceResolver();
            int startPos = 0;
            int index = -1;
            boolean updated = false;
            while ((index = StringUtils.indexOf((CharSequence)message, (CharSequence)SRC_ELEMENT, (int)startPos)) >= 0) {
                String imgUrl;
                int imgEndPos;
                startPos = index + 1;
                int imgStartPos = StringUtils.indexOf((CharSequence)message, (CharSequence)"\"", (int)index);
                if (imgStartPos <= 0 || (imgEndPos = StringUtils.indexOf((CharSequence)message, (CharSequence)"\"", (int)(imgStartPos + 1))) <= 0 || !(imgUrl = StringUtils.substring((String)message, (int)(imgStartPos + 1), (int)imgEndPos)).startsWith(TEMP_DIR)) continue;
                String name = FilenameUtils.getName((String)imgUrl);
                Resource imgResource = resolver.getResource(imgUrl);
                if (imgResource != null && imgResource.hasChildren()) {
                    imgResource = imgResource.getChild("jcr:content");
                }
                if (imgResource == null) continue;
                InputStream inputStream = imgResource.adaptTo(InputStream.class);
                ValueMap valueMap = imgResource.adaptTo(ValueMap.class);
                String mimeType = (String)((Object)valueMap.get("jcr:mimeType", String.class));
                Resource image = ocomment.addImage(name, inputStream, mimeType);
                String externalUrl = UploadOperationUtils.externalizeLink(externalizer, author, resolver, image.getPath());
                message = UploadOperationUtils.replace(message, externalUrl, imgStartPos, imgEndPos - imgStartPos);
                updated = true;
            }
            if (updated) {
                ModifiableValueMap mvm = resource.adaptTo(ModifiableValueMap.class);
                mvm.put("jcr:description", message);
                resolver.commit();
            }
        }
    }

    public static void moveImages(ClientUtilities clientUtils, com.adobe.cq.social.commons.comments.api.Comment comment, ResourceResolver serviceUserResolver) throws PersistenceException {
        String message = comment.getMessage();
        if (message.contains(IMAGE_ELEMENT)) {
            String commentPath = comment.getResource().getPath();
            Resource resource = serviceUserResolver.getResource(commentPath);
            Comment ocomment = resource.adaptTo(Comment.class);
            int startPos = 0;
            int index = -1;
            boolean updated = false;
            Resource imgResource = null;
            ArrayList<Resource> deletedResources = new ArrayList<Resource>();
            while ((index = StringUtils.indexOf((CharSequence)message, (CharSequence)SRC_ELEMENT, (int)startPos)) >= 0) {
                ValueMap valueMap;
                String mimeType;
                InputStream inputStream;
                Resource image;
                int imgEndPos;
                startPos = index + 1;
                int imgStartPos = StringUtils.indexOf((CharSequence)message, (CharSequence)"\"", (int)index);
                if (imgStartPos <= 0 || (imgEndPos = StringUtils.indexOf((CharSequence)message, (CharSequence)"\"", (int)(imgStartPos + 1))) <= 0) continue;
                String imgUrl = StringUtils.substring((String)message, (int)(imgStartPos + 1), (int)imgEndPos);
                if (!(imgUrl = Text.unescape(imgUrl)).startsWith(TEMP_DIR)) continue;
                String name = FilenameUtils.getName((String)imgUrl);
                imgResource = serviceUserResolver.getResource(imgUrl);
                Resource targetImgResource = imgResource != null && imgResource.hasChildren() ? imgResource.getChild("jcr:content") : imgResource;
                if (targetImgResource == null || (image = ocomment.addImage(name, inputStream = targetImgResource.adaptTo(InputStream.class), mimeType = (String)((Object)(valueMap = targetImgResource.adaptTo(ValueMap.class)).get("jcr:mimeType", String.class)))) == null) continue;
                deletedResources.add(imgResource);
                String externalUrl = UploadOperationUtils.encode(image.getPath(), clientUtils);
                message = UploadOperationUtils.replace(message, externalUrl, imgStartPos, imgEndPos - imgStartPos);
                updated = true;
            }
            if (updated) {
                ModifiableValueMap mvm = resource.adaptTo(ModifiableValueMap.class);
                mvm.put("jcr:description", message);
                for (Resource deletedResource : deletedResources) {
                    Resource parentResource = deletedResource.getParent();
                    serviceUserResolver.delete(deletedResource);
                }
                serviceUserResolver.commit();
            }
        }
    }

    private static String encode(String str, ClientUtilities clientUtils) {
        String result = clientUtils.externalLink(str, false);
        return Text.escapePath(str);
    }

    private static String replace(String text, String replacement, int startIndex, int length) {
        int replLength = replacement.length();
        int increase = replacement.length() - length;
        increase = increase < 0 ? 0 : increase;
        StringBuilder buf = new StringBuilder(text.length() + (increase *= 16));
        buf = buf.append(text, 0, startIndex + 1).append(replacement).append(text.substring(startIndex + length));
        return buf.toString();
    }

    private static String externalizeLink(Externalizer externalizer, boolean author, ResourceResolver resolver, String url) {
        String externalUrl = url;
        if (externalizer != null) {
            externalUrl = author ? externalizer.authorLink(resolver, externalUrl) : externalizer.publishLink(resolver, externalUrl);
        }
        return UploadOperationUtils.getRootBasedURL(url);
    }

    private static String getRootBasedURL(String url) {
        try {
            URL startURL = new URL(url);
            String HOST_CHECK_HEADER = "origin";
            if (StringUtils.startsWithIgnoreCase((CharSequence)startURL.getProtocol(), (CharSequence)"http")) {
                return StringUtils.removeStart((String)url.toString(), (String)(startURL.getProtocol() + "://" + startURL.getHost() + (startURL.getPort() == -1 ? "" : ":" + startURL.getPort())));
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return url;
    }

    private static boolean skipFolder(String name) {
        for (int i = 0; i < SKIP_DIRS.length; ++i) {
            if (!name.equals(SKIP_DIRS[i])) continue;
            return true;
        }
        return false;
    }
}

