/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.commons.emailreply;

import com.adobe.cq.social.commons.FileDataSource;
import com.adobe.cq.social.commons.bundleactivator.Activator;
import com.adobe.cq.social.commons.emailreply.CommentEmailBuilder;
import com.adobe.cq.social.commons.emailreply.EmailClientProvider;
import com.adobe.cq.social.commons.emailreply.EmailContent;
import com.adobe.cq.social.commons.emailreply.EmailReplyException;
import com.adobe.cq.social.commons.emailreply.FileDataSourceFactory;
import com.adobe.cq.social.commons.emailreply.internal.EmailReplyConfiguration;
import com.adobe.cq.social.serviceusers.internal.ServiceUserWrapper;
import com.day.cq.mailer.MailService;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.observation.Event;
import javax.jcr.observation.EventIterator;
import javax.jcr.observation.EventListener;
import javax.jcr.observation.ObservationManager;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.MimeMessage;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.mail.Email;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.jackrabbit.api.observation.JackrabbitEvent;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.resource.ValueMap;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(componentAbstract=true)
public abstract class AbstractEmailEventListener
implements EventListener {
    protected static final String EMAIL_CLIENT_PROVIDER_PROPERTY = "email.parsingEmailClient";
    protected static final String TRACKER_ID_PROPERTY = "commentObjectUniqueId_s";
    private static final String PROCESSING_STATUS_PROPERTY = "processingStatus";
    private static final String PROCESSING_STATUS_MSG_PROP = "processingStatusMsg";
    private static final String USER_READER = "user-reader";
    private static final String MSM_SERVICE = "msm-service";
    private static final String UGC_WRITER = "ugc-writer";
    private static final Logger LOG = LoggerFactory.getLogger(AbstractEmailEventListener.class);
    @Reference(cardinality=ReferenceCardinality.MANDATORY_MULTIPLE, bind="bindEmailClientProvider", unbind="unbindEmailClientProvider", referenceInterface=EmailClientProvider.class, policy=ReferencePolicy.DYNAMIC)
    private static final List<EmailClientProvider> EMAIL_CLIENT_PROVIDERS = Collections.synchronizedList(new ArrayList());
    @Reference
    private ServiceUserWrapper serviceUserWrapper;
    @Reference
    private EmailReplyConfiguration emailReplyConfiguration;
    @Reference
    private MailService mailService;
    @Reference
    private FileDataSourceFactory fileDataSourceFactory;
    @Reference
    private CommentEmailBuilder commentEmailBuilder;
    private ExecutorService eventExecutorService;
    private ResourceResolver userReaderResourceResolver;
    private ResourceResolver utilityReaderResourceResolver;
    private ResourceResolver ugcWriterResourceResolver;
    private ObservationManager observationManager;
    private Pattern pattern;

    protected void activate(ComponentContext context) throws RepositoryException, LoginException {
        LOG.info("Activating {}.", (Object)this.getClass().getName());
        this.configure();
    }

    private void configure() throws RepositoryException, LoginException {
        ResourceResolverFactory resourceResolverFactory = Activator.getService(ResourceResolverFactory.class);
        this.userReaderResourceResolver = this.serviceUserWrapper.getServiceResourceResolver(resourceResolverFactory, Collections.singletonMap("sling.service.subservice", USER_READER));
        this.utilityReaderResourceResolver = this.serviceUserWrapper.getServiceResourceResolver(resourceResolverFactory, Collections.singletonMap("sling.service.subservice", MSM_SERVICE));
        this.ugcWriterResourceResolver = this.serviceUserWrapper.getServiceResourceResolver(resourceResolverFactory, Collections.singletonMap("sling.service.subservice", UGC_WRITER));
        if (this.ugcWriterResourceResolver == null) {
            throw new EmailReplyException("Unable to get observation manager. No resource resolver.");
        }
        this.observationManager = this.ugcWriterResourceResolver.adaptTo(Session.class).getWorkspace().getObservationManager();
        this.eventExecutorService = Executors.newSingleThreadExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = Executors.defaultThreadFactory().newThread(r);
                t.setDaemon(true);
                return t;
            }
        });
        this.pattern = Pattern.compile("(\\[" + this.emailReplyConfiguration.getTrackerIdPrefixInSubject() + ")([a-zA-Z0-9]+)(\\])");
    }

    protected void bindEmailClientProvider(EmailClientProvider boundProvider) {
        EMAIL_CLIENT_PROVIDERS.add(boundProvider);
        Collections.sort(EMAIL_CLIENT_PROVIDERS, new Comparator<EmailClientProvider>(){

            @Override
            public int compare(EmailClientProvider p1, EmailClientProvider p2) {
                Integer priority1 = p1.getPriorityOrder();
                Integer priority2 = p2.getPriorityOrder();
                return priority1.compareTo(priority2);
            }
        });
        LOG.info("Bound email client provider: {}", (Object)boundProvider.getClass().getSimpleName());
    }

    protected void unbindEmailClientProvider(EmailClientProvider unboundProvider) {
        EMAIL_CLIENT_PROVIDERS.remove(unboundProvider);
        LOG.debug("Unbound email client provider: {}", (Object)unboundProvider.getClass().getSimpleName());
    }

    protected ResourceResolver getUserReaderResourceResolver() {
        return this.userReaderResourceResolver;
    }

    protected ResourceResolver getUgcWriterResourceResolver() {
        return this.ugcWriterResourceResolver;
    }

    protected ObservationManager getObservationManager() {
        return this.observationManager;
    }

    public void onEvent(EventIterator events) {
        while (events.hasNext()) {
            final Event event = events.nextEvent();
            if (event instanceof JackrabbitEvent && ((JackrabbitEvent)event).isExternal()) continue;
            this.eventExecutorService.execute(new Runnable(){

                @Override
                public void run() {
                    String nodePath = null;
                    Resource emailResource = null;
                    EmailContent emailContent = null;
                    try {
                        nodePath = event.getPath();
                        LOG.debug("Email received at path: [{}]", (Object)nodePath);
                        if (!nodePath.contains("/Job") && nodePath.endsWith("/message/jcr:content")) {
                            Resource resource = AbstractEmailEventListener.this.ugcWriterResourceResolver.getResource(nodePath);
                            emailResource = resource.getParent().getParent();
                            AbstractEmailEventListener.this.setProcessingStatus(emailResource, "processing", null);
                            emailContent = AbstractEmailEventListener.this.getEmailContent(resource);
                            AbstractEmailEventListener.this.processEvent(resource, emailContent);
                            LOG.info("Deleting node: [{}]", (Object)emailResource.getPath());
                            AbstractEmailEventListener.this.ugcWriterResourceResolver.delete(emailResource);
                            AbstractEmailEventListener.this.ugcWriterResourceResolver.commit();
                        }
                    }
                    catch (RepositoryException e) {
                        LOG.warn("Error while processing event", (Throwable)e);
                    }
                    catch (PersistenceException e) {
                        LOG.warn("Unable to delete processed email at path: [{}]", (Object)nodePath, (Object)e);
                    }
                    catch (EmailReplyException e) {
                        LOG.warn("Error while processing email saved at path: [{}]", (Object)nodePath, (Object)e);
                        AbstractEmailEventListener.this.setProcessingStatus(emailResource, "failure", e.getMessage());
                        AbstractEmailEventListener.this.sendFailureEmailReply(emailContent);
                    }
                }
            });
        }
    }

    public EmailContent getEmailContent(Resource resource) {
        ValueMap valueMap = resource.adaptTo(ValueMap.class);
        InputStream emailStream = (InputStream)valueMap.get("jcr:data");
        final Properties properties = new Properties();
        final ArrayList<FileDataSource> attachmentList = new ArrayList<FileDataSource>();
        try {
            MimeMessage email = this.getEmailFromStream(emailStream);
            EmailClientProvider emailClientProvider = this.getEmailClientProvider(email);
            EmailContent emailContent = new EmailContent(){

                @Override
                public Properties getProperties() {
                    return properties;
                }

                @Override
                public List<FileDataSource> getAttachments() {
                    return attachmentList;
                }
            };
            if (emailClientProvider == null) {
                throw new EmailReplyException("No suitable email client provider found.");
            }
            String emailClientProviderName = emailClientProvider.getClass().getName();
            LOG.debug("Contents parsed by {}", (Object)emailClientProviderName);
            String trackerId = this.getTrackerIdFromMail(email);
            Properties emailProperties = emailClientProvider.getMailProperties(email);
            properties.setProperty("email.message", emailProperties.getProperty("email.message", ""));
            properties.setProperty("email.author", emailProperties.getProperty("email.author", ""));
            properties.setProperty("email.subject", emailProperties.getProperty("email.subject", ""));
            properties.setProperty(TRACKER_ID_PROPERTY, StringUtils.defaultIfEmpty((String)trackerId, (String)""));
            properties.setProperty(EMAIL_CLIENT_PROVIDER_PROPERTY, StringUtils.defaultIfEmpty((String)emailClientProviderName, (String)""));
            this.handleAttachments(attachmentList, email);
            EmailContent emailContent2 = emailContent;
            return emailContent2;
        }
        catch (MessagingException e) {
            throw new EmailReplyException("Unable to construct MIME message from input stream", e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)emailStream);
        }
    }

    private MimeMessage getEmailFromStream(InputStream mailFileStream) throws MessagingException {
        Properties properties = System.getProperties();
        javax.mail.Session mailSession = javax.mail.Session.getDefaultInstance((Properties)properties, null);
        return new MimeMessage(mailSession, mailFileStream);
    }

    private EmailClientProvider getEmailClientProvider(MimeMessage mail) {
        for (EmailClientProvider emailClientProvider : EMAIL_CLIENT_PROVIDERS) {
            boolean mailAccepted = emailClientProvider.acceptsMail(mail);
            LOG.debug("Going through EmailClientProvider {} to see if this accepts mail {}.", (Object)emailClientProvider.getClass().getName(), (Object)mailAccepted);
            if (!mailAccepted) continue;
            return emailClientProvider;
        }
        return null;
    }

    private String getTrackerIdFromMail(MimeMessage emailMessage) throws MessagingException {
        Matcher m;
        String trackerId = "";
        String subject = emailMessage.getSubject();
        if (subject != null && (m = this.pattern.matcher(subject)).find()) {
            LOG.debug("Found tracker id in subject: {}", (Object)trackerId);
            return m.group(2);
        }
        Address[] recipients = emailMessage.getRecipients(Message.RecipientType.TO);
        if (recipients != null && recipients.length > 0) {
            int replyToDelimiterIndex;
            String recipientAddress = recipients[0].toString();
            if (recipientAddress.contains("<") && recipientAddress.contains(">")) {
                recipientAddress = recipientAddress.replaceAll("[<>]", "");
            }
            if ((replyToDelimiterIndex = recipientAddress.indexOf(this.emailReplyConfiguration.getReplyToDelimiter())) != -1) {
                trackerId = recipientAddress.substring(replyToDelimiterIndex + 1, recipientAddress.indexOf("@"));
                LOG.debug("Found tracker id in recipient address [{}]", (Object)trackerId);
            } else {
                LOG.error("Recipient email address has no configured reply-to delimiter.");
            }
        } else {
            LOG.error("Unable to track recipient email address.");
        }
        return trackerId;
    }

    private void handleAttachments(List<FileDataSource> attachments, MimeMessage mail) {
        try {
            if (mail == null) {
                LOG.error("Unable to handle attachments list. No MIME message.");
                return;
            }
            Object mailContent = mail.getContent();
            if (mailContent instanceof Multipart) {
                Multipart multipart = (Multipart)mailContent;
                this.handleMultipart(attachments, multipart);
            }
        }
        catch (MessagingException e) {
            LOG.error("Unable to construct MIME message from input stream", (Throwable)e);
        }
        catch (IOException e) {
            LOG.error("Unable to handle attachments list in the email", (Throwable)e);
        }
    }

    private void handleMultipart(List<FileDataSource> attachments, Multipart multipart) throws MessagingException, IOException {
        int count = multipart.getCount();
        for (int i = 0; i < count; ++i) {
            BodyPart bodypart = multipart.getBodyPart(i);
            Object content = bodypart.getContent();
            if (bodypart.getFileName() != null) {
                if (content instanceof String || content instanceof InputStream) {
                    FileDataSource attachment = this.fileDataSourceFactory.getFileDataSource(bodypart);
                    attachments.add(attachment);
                    continue;
                }
                LOG.error("Unable to attach file with name " + bodypart.getFileName());
                continue;
            }
            if (!(content instanceof Multipart)) continue;
            this.handleMultipart(attachments, (Multipart)content);
        }
    }

    public void sendFailureEmailReply(EmailContent emailContent) {
        Email failureEmail = this.commentEmailBuilder.buildFailure(this.userReaderResourceResolver, this.utilityReaderResourceResolver, emailContent);
        if (failureEmail != null) {
            LOG.info("Sending failure notification email.");
            this.mailService.send(failureEmail);
        } else {
            LOG.error("Unable to send failure notification email. Email hasn't been built.");
        }
    }

    protected void setProcessingStatus(Resource emailResource, String processingStatus, String statusMsg) {
        if (emailResource != null) {
            try {
                Node emailNode = emailResource.adaptTo(Node.class);
                if (processingStatus != null) {
                    emailNode.setProperty(PROCESSING_STATUS_PROPERTY, processingStatus);
                }
                if (statusMsg != null) {
                    emailNode.setProperty(PROCESSING_STATUS_MSG_PROP, statusMsg);
                }
            }
            catch (RepositoryException e) {
                LOG.error("Error while saving setting processing status", (Throwable)e);
            }
        }
    }

    @Deactivate
    protected void deactivate(ComponentContext componentContext) {
        if (this.eventExecutorService != null) {
            this.eventExecutorService.shutdown();
        }
        if (this.userReaderResourceResolver != null) {
            this.userReaderResourceResolver.close();
        }
        if (this.utilityReaderResourceResolver != null) {
            this.utilityReaderResourceResolver.close();
        }
        if (this.ugcWriterResourceResolver != null) {
            this.ugcWriterResourceResolver.close();
        }
    }

    protected abstract void processEvent(Resource var1, EmailContent var2);

    protected void bindServiceUserWrapper(ServiceUserWrapper serviceUserWrapper) {
        this.serviceUserWrapper = serviceUserWrapper;
    }

    protected void unbindServiceUserWrapper(ServiceUserWrapper serviceUserWrapper) {
        if (this.serviceUserWrapper == serviceUserWrapper) {
            this.serviceUserWrapper = null;
        }
    }

    protected void bindEmailReplyConfiguration(EmailReplyConfiguration emailReplyConfiguration) {
        this.emailReplyConfiguration = emailReplyConfiguration;
    }

    protected void unbindEmailReplyConfiguration(EmailReplyConfiguration emailReplyConfiguration) {
        if (this.emailReplyConfiguration == emailReplyConfiguration) {
            this.emailReplyConfiguration = null;
        }
    }

    protected void bindMailService(MailService mailService) {
        this.mailService = mailService;
    }

    protected void unbindMailService(MailService mailService) {
        if (this.mailService == mailService) {
            this.mailService = null;
        }
    }

    protected void bindFileDataSourceFactory(FileDataSourceFactory fileDataSourceFactory) {
        this.fileDataSourceFactory = fileDataSourceFactory;
    }

    protected void unbindFileDataSourceFactory(FileDataSourceFactory fileDataSourceFactory) {
        if (this.fileDataSourceFactory == fileDataSourceFactory) {
            this.fileDataSourceFactory = null;
        }
    }

    protected void bindCommentEmailBuilder(CommentEmailBuilder commentEmailBuilder) {
        this.commentEmailBuilder = commentEmailBuilder;
    }

    protected void unbindCommentEmailBuilder(CommentEmailBuilder commentEmailBuilder) {
        if (this.commentEmailBuilder == commentEmailBuilder) {
            this.commentEmailBuilder = null;
        }
    }
}

