/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.commons.events;

import com.adobe.cq.social.commons.comments.api.Comment;
import com.adobe.cq.social.scf.SocialComponent;
import com.adobe.cq.social.scf.core.SocialEvent;
import com.day.text.Text;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.osgi.service.event.Event;

public class CommentEvent
extends SocialEvent<CommentActions> {
    private static final long serialVersionUID = 1L;
    public static final String COMMENT_TOPIC = "comment";
    private static final String COMMENT_SYSTEM_PATH = "COMMENT_SYSTEM_PATH";

    public CommentEvent(final Comment comment, String userId, CommentActions action) {
        super(COMMENT_TOPIC, comment.getResource().getPath(), userId, action, new SocialEvent.BaseEventObject(CommentEvent.getObjectName(comment.getResource()), comment.getResource().getPath(), COMMENT_TOPIC), new SocialEvent.BaseEventObject(CommentEvent.getTargetname(comment), comment.getParentComponent() != null ? comment.getParentComponent().getResource().getPath() : comment.getSourceComponentId(), "collection"), (Map<String, Object>)new HashMap<String, Object>(1){
            private static final long serialVersionUID = 1L;
            {
                super(x0);
                this.put(CommentEvent.COMMENT_SYSTEM_PATH, comment.getParentComponent() != null ? comment.getParentComponent().getResource().getPath() : comment.getSourceComponentId());
            }
        });
    }

    protected static String getObjectName(Resource resource) {
        return "a " + Text.getName(resource.getResourceType());
    }

    protected static String getTargetname(Comment comment) {
        ValueMap vm;
        String title = null;
        SocialComponent component = comment.getParentComponent();
        if (component != null && StringUtils.isEmpty((CharSequence)(title = (String)((Object)(vm = ResourceUtil.getValueMap(component.getResource())).get("jcr:title", String.class))))) {
            title = Text.getName(component.getId().getResourceIdentifier());
            if (component.getResource().isResourceType("social/commons/components/hbs/comments/comment")) {
                title = StringUtils.substringAfterLast((String)title, (String)"-");
            }
        }
        if (StringUtils.isEmpty(title)) {
            title = Text.getName(comment.getSourceComponentId());
        }
        return title;
    }

    private CommentEvent(Event event) {
        super(event);
    }

    public String getCommentSystemPath() {
        return (String)this.getProperty(COMMENT_SYSTEM_PATH);
    }

    public static CommentEvent fromEvent(Event event) {
        if ("com/adobe/cq/social/comment".equals(event.getTopic())) {
            return new CommentEvent(event);
        }
        return null;
    }

    public static enum CommentActions implements SocialEvent.SocialActions
    {
        CREATED,
        REPLIED,
        EDITED,
        DELETED;


        @Override
        public String getVerb() {
            switch (this) {
                case CREATED: {
                    return "post";
                }
                case REPLIED: {
                    return "add";
                }
                case EDITED: {
                    return "update";
                }
                case DELETED: {
                    return "delete";
                }
            }
            throw new IllegalArgumentException();
        }
    }
}

