/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.commons.moderation.api;

import com.adobe.cq.social.commons.bundleactivator.Activator;
import com.adobe.cq.social.commons.moderation.api.ModerationOperations;
import com.adobe.cq.social.scf.OperationException;
import com.adobe.cq.social.scf.SocialComponent;
import com.adobe.cq.social.scf.SocialComponentFactory;
import com.adobe.cq.social.scf.SocialComponentFactoryManager;
import com.adobe.cq.social.scf.SocialOperationResult;
import com.adobe.cq.social.scf.core.operations.AbstractSocialOperation;
import com.adobe.cq.social.serviceusers.internal.ServiceUserWrapper;
import com.adobe.cq.social.ugcbase.SocialUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.jcr.api.SlingRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=false, componentAbstract=true)
public abstract class AbstractModerationOperation
extends AbstractSocialOperation {
    public final String BULK_PARAM = ":items";
    @Reference
    protected ModerationOperations moderationOps;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY, policy=ReferencePolicy.STATIC)
    protected SlingRepository repository;
    @Reference
    protected SocialComponentFactoryManager componentFactoryManager;
    @Reference
    protected SocialUtils socialUtils;
    private SlingRepository repositoryBugFix;
    private ServiceUserWrapper serviceUserWrapper;
    private static final Logger log = LoggerFactory.getLogger(AbstractModerationOperation.class);
    public static final String PROPERTY_REVERSE_REPLICATE = "reverseReplicate";
    private static final String UGC_WRITER = "ugc-writer";
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY, policy=ReferencePolicy.STATIC)
    protected ResourceResolverFactory resourceResolverFactory;

    public abstract String getOperationName();

    @Override
    public abstract SocialOperationResult performOperation(SlingHttpServletRequest var1) throws OperationException;

    protected Session getSession(Resource resource) {
        return resource.getResourceResolver().adaptTo(Session.class);
    }

    protected Session getSession(SlingHttpServletRequest request) {
        return this.getSession(request.getResource());
    }

    protected Session createAdminSession() {
        try {
            if (this.repositoryBugFix == null) {
                this.repositoryBugFix = Activator.getService(SlingRepository.class);
            }
            if (this.serviceUserWrapper == null) {
                this.serviceUserWrapper = Activator.getService(ServiceUserWrapper.class);
            }
            return this.serviceUserWrapper.loginService(this.repositoryBugFix, UGC_WRITER);
        }
        catch (RepositoryException e) {
            log.error("error creating session: ", (Throwable)e);
            return null;
        }
    }

    protected void closeAdminSession(Session adminSession) {
        if (adminSession != null && adminSession.isLive()) {
            adminSession.logout();
        }
    }

    public Resource getSessionResource(SlingHttpServletRequest request, Session session) throws OperationException {
        ResourceResolver resolver;
        Resource requestResource = request.getResource();
        HashMap<String, Object> sessionMap = new HashMap<String, Object>();
        sessionMap.put("user.jcr.session", session);
        try {
            resolver = this.resourceResolverFactory.getResourceResolver(sessionMap);
        }
        catch (LoginException e) {
            throw new OperationException("Unable to get session resource from session.  ", e, 500);
        }
        return resolver.getResource(requestResource.getPath());
    }

    protected SocialOperationResult getSocialOperationResult(SlingHttpServletRequest request, String path) {
        SocialComponent socialComponent = null;
        Resource resource = request.getResourceResolver().getResource(request.getResource().getPath());
        SocialComponentFactory factory = this.componentFactoryManager.getSocialComponentFactory(resource);
        if (factory != null) {
            socialComponent = factory.getSocialComponent(resource, request);
        }
        return new SocialOperationResult(socialComponent, 200, path);
    }

    protected void verifyUserHasModeratePermissions(SlingHttpServletRequest request, Session session) throws OperationException {
        Resource resource = this.getSessionResource(request, session);
        if (!this.socialUtils.hasModeratePermissions(resource)) {
            throw new OperationException("Requesting user does not have permissions for this action.  ", 401);
        }
    }

    protected List<Resource> verifyUserBulkModerationPermissions(String[] bulkItemPaths, ResourceResolver resourceResolver) throws LoginException {
        ArrayList<Resource> allowedResources = new ArrayList<Resource>();
        for (String itemPath : bulkItemPaths) {
            Resource resource = resourceResolver.resolve(itemPath);
            if (this.socialUtils.hasModeratePermissions(resource)) {
                allowedResources.add(resource);
                continue;
            }
            log.warn("User '{}' doesn't have moderation permission for resource at '{}'", (Object)resourceResolver.getUserID(), (Object)itemPath);
        }
        return allowedResources;
    }

    protected void verifyUserIsValid(Session session) throws OperationException {
        String userId = session.getUserID();
        if (userId == null || userId.equalsIgnoreCase("Anonymous")) {
            throw new OperationException("Requesting user does not have permissions for this action.  ", 401);
        }
    }

    public void setResourceResolverFactory(ResourceResolverFactory aRRFactory) {
        this.resourceResolverFactory = aRRFactory;
    }

    public void setRepository(SlingRepository aRepository) {
        this.repository = aRepository;
    }

    public void setModerationOperations(ModerationOperations modOps) {
        this.moderationOps = modOps;
    }

    public void setSocialUtils(SocialUtils aSocialUtils) {
        this.socialUtils = aSocialUtils;
    }

    public void setComponentFactoryManager(SocialComponentFactoryManager aSocialComponentFactoryManager) {
        this.componentFactoryManager = aSocialComponentFactoryManager;
    }

    protected void bindModerationOps(ModerationOperations moderationOperations) {
        this.moderationOps = moderationOperations;
    }

    protected void unbindModerationOps(ModerationOperations moderationOperations) {
        if (this.moderationOps == moderationOperations) {
            this.moderationOps = null;
        }
    }

    protected void bindRepository(SlingRepository slingRepository) {
        this.repository = slingRepository;
    }

    protected void unbindRepository(SlingRepository slingRepository) {
        if (this.repository == slingRepository) {
            this.repository = null;
        }
    }

    protected void bindComponentFactoryManager(SocialComponentFactoryManager socialComponentFactoryManager) {
        this.componentFactoryManager = socialComponentFactoryManager;
    }

    protected void unbindComponentFactoryManager(SocialComponentFactoryManager socialComponentFactoryManager) {
        if (this.componentFactoryManager == socialComponentFactoryManager) {
            this.componentFactoryManager = null;
        }
    }

    protected void bindSocialUtils(SocialUtils socialUtils) {
        this.socialUtils = socialUtils;
    }

    protected void unbindSocialUtils(SocialUtils socialUtils) {
        if (this.socialUtils == socialUtils) {
            this.socialUtils = null;
        }
    }

    protected void bindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resourceResolverFactory = resourceResolverFactory;
    }

    protected void unbindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resourceResolverFactory == resourceResolverFactory) {
            this.resourceResolverFactory = null;
        }
    }
}

