/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.connect.oauth;

import com.day.cq.commons.jcr.JcrUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.jcr.Binary;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.io.IOUtils;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.scribe.model.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProviderUtils {
    private static Logger log = LoggerFactory.getLogger(ProviderUtils.class);

    public static Map<String, String> parseProfileDataResponse(Response response) throws IOException {
        String body = response.getBody();
        try {
            JSONObject json = new JSONObject(body);
            HashMap<String, String> newProps = new HashMap<String, String>();
            Iterator<String> keys = json.keys();
            while (keys.hasNext()) {
                String key = keys.next();
                newProps.put(key, json.optString(key));
            }
            return newProps;
        }
        catch (JSONException je) {
            log.debug("problem parsing JSON; response body was: {}", (Object)body);
            throw new IOException(je.toString());
        }
    }

    @Deprecated
    public static void importAvatarFile(Node userNode, String avatarURL, String avatarFileProperty) throws IOException, RepositoryException {
        ProviderUtils.importAvatarFile(userNode, avatarURL, avatarFileProperty, HttpClientBuilder.create());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void importAvatarFile(Node userNode, String avatarURL, String avatarFileProperty, HttpClientBuilder httpClientBuilder) throws IOException, RepositoryException {
        Session session = userNode.getSession();
        if (avatarURL != null && avatarURL.startsWith("http")) {
            InputStream ins = null;
            CloseableHttpClient hc = null;
            CloseableHttpResponse response = null;
            try {
                hc = httpClientBuilder.build();
                HttpGet get = new HttpGet(avatarURL);
                response = hc.execute((HttpUriRequest)get);
                if (response.getStatusLine().getStatusCode() == 200) {
                    String mimeType = response.getFirstHeader("Content-Type").getValue();
                    ins = response.getEntity().getContent();
                    Binary binary = session.getValueFactory().createBinary(ins);
                    Node imageNode = JcrUtil.createPath(userNode, avatarFileProperty, false, "sling:Folder", "nt:file", session, false);
                    Node contentNode = imageNode.addNode("jcr:content", "nt:resource");
                    contentNode.setProperty("jcr:data", binary);
                    contentNode.setProperty("jcr:lastModified", Calendar.getInstance());
                    contentNode.setProperty("jcr:mimeType", mimeType);
                    session.save();
                }
            }
            finally {
                IOUtils.closeQuietly(ins);
                ins = null;
                if (hc != null) {
                    hc.close();
                }
                if (response != null) {
                    response.close();
                }
            }
        }
    }
}

