/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.dns.api;

import com.adobe.cq.social.dns.api.DNSManager;
import com.adobe.cq.social.dns.api.DNSManagerException;
import java.util.Dictionary;
import org.apache.commons.lang3.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(componentAbstract=true)
@Properties(value={@Property(name="soco.dns.applicationkey"), @Property(name="soco.dns.pointsto")})
public abstract class AbstractDNSManager
implements DNSManager {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractDNSManager.class);
    protected String applicationKey;
    protected String pointsTo;

    protected void setPropertyValues(Dictionary properties) throws DNSManagerException {
        this.applicationKey = this.getProperty(properties, "soco.dns.applicationkey", "Could not get application key from configuration.");
        this.pointsTo = this.getProperty(properties, "soco.dns.pointsto", "Could not get where to point CNAMES to.");
        LOG.trace("AbstractDNSManager.setPropertyValues applicationKey: {} pointsTo: {}", (Object)this.applicationKey, (Object)this.pointsTo);
    }

    protected String getProperty(Dictionary properties, String key, String message) throws DNSManagerException {
        Object property = properties.get(key);
        if (StringUtils.isEmpty((CharSequence)message)) {
            return (String)property;
        }
        if (property == null || !(property instanceof String) || StringUtils.isEmpty((CharSequence)((String)property))) {
            throw new DNSManagerException(message);
        }
        return (String)property;
    }
}

