/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.enablement.model;

import com.adobe.cq.social.community.api.CommunityContext;
import com.adobe.cq.social.community.api.CommunityUserGroup;
import com.adobe.cq.social.console.utils.api.UserUtils;
import com.adobe.cq.social.enablement.exception.EnablementContentNotFound;
import com.adobe.cq.social.enablement.exception.EnablementResourceNotFound;
import com.adobe.cq.social.enablement.exception.FailureCodes;
import com.adobe.cq.social.enablement.exception.OperationNotAllowedOnResource;
import com.adobe.cq.social.enablement.exception.ResourceFailureCodes;
import com.adobe.cq.social.enablement.exception.StatusException;
import com.adobe.cq.social.enablement.model.EnablementContentContactImpl;
import com.adobe.cq.social.enablement.model.EnablementLearningPath;
import com.adobe.cq.social.enablement.model.EnablementResource;
import com.adobe.cq.social.enablement.model.LinkedResourceInfo;
import com.adobe.cq.social.enablement.model.User;
import com.adobe.cq.social.enablement.model.api.EnablementContentContact;
import com.adobe.cq.social.enablement.model.api.PrerequisiteLearningPath;
import com.adobe.cq.social.enablement.model.resourceAsset.DamAsset;
import com.adobe.cq.social.enablement.model.resourceAsset.ExternalResourceAsset;
import com.adobe.cq.social.enablement.model.resourceAsset.ResourceAsset;
import com.adobe.cq.social.enablement.model.resourceAsset.UrlAsset;
import com.adobe.cq.social.enablement.utils.BundleUtils;
import com.adobe.cq.social.enablement.utils.EnablementContentUUIDUtils;
import com.adobe.cq.social.enablement.utils.ResourceUtils;
import com.adobe.cq.social.enablement.utils.SlingResourceUtils;
import com.adobe.cq.social.enablement.utils.Utils;
import com.adobe.cq.social.scf.ClientUtilities;
import com.adobe.cq.social.scf.core.BaseSocialComponent;
import com.adobe.cq.social.tally.RatingComponent;
import com.adobe.cq.social.tally.client.api.TallyException;
import com.adobe.granite.security.user.UserProperties;
import com.adobe.granite.security.user.UserPropertiesManager;
import com.day.cq.commons.jcr.JcrUtil;
import com.day.cq.dam.api.Asset;
import com.day.cq.replication.ReplicationStatus;
import com.day.cq.search.Predicate;
import com.day.cq.search.PredicateGroup;
import com.day.cq.search.Query;
import com.day.cq.search.QueryBuilder;
import com.day.cq.search.result.Hit;
import com.day.cq.search.result.SearchResult;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.security.Principal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import org.apache.commons.lang.StringUtils;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.AuthorizableExistsException;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.jackrabbit.commons.JcrUtils;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.commons.json.JSONArray;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.apache.sling.jcr.base.util.AccessControlUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractEnablementResource
extends BaseSocialComponent
implements EnablementResource {
    public static final String ENABLEMENT_CONTENT_PRIMARY_TYPE = "nt:unstructured";
    public static final String CARD_IMAGE_PATH = "card-image-path";
    public static final String CARD_IMAGE_RESOURCE_NAME = "image";
    public static final String CARD_IMAGE_CONTAINER = "cardimage";
    public static final String PROFILE_PATH = "profile";
    public static final String USER_ID_PROPERTY = "userId";
    public static final String VANITY_PATH = "vanity-path";
    public static final String TAG_NAMESPACES = "tagNameSpaces";
    private Logger log = LoggerFactory.getLogger(this.getClass());
    protected Resource rsc;
    protected ResourceResolver resourceResolver;
    protected ClientUtilities clientUtilities;
    private static final String AUTHORIZABLE_ID_LIST_PROPERTY = "authorizableIdList";
    private static final String AUTHORIZABLE_DELTA_ID_LIST_PROPERTY = "deltaAuthorizableIdList";
    private Resource enrolleeListContainer;
    private static final Logger LOG = LoggerFactory.getLogger(AbstractEnablementResource.class);
    public static final String ASSET_ARRAY = "assets";
    private Session session;
    private UserManager userManager;
    private Node resourceNode;
    static final String[] MANDATORY_FIELDS = new String[]{"jcr:title", "resource-contact"};

    private void initialize() throws EnablementResourceNotFound {
        this.session = this.resourceResolver.adaptTo(Session.class);
        if (this.rsc != null) {
            this.userManager = this.rsc.adaptTo(UserManager.class);
        }
    }

    public AbstractEnablementResource(Resource resource, ClientUtilities clientUtilities) throws PersistenceException, EnablementContentNotFound, EnablementResourceNotFound {
        super(resource, clientUtilities);
        this.clientUtilities = clientUtilities;
        if (resource.isResourceType("social/enablement/components/hbs/resource") || resource.isResourceType("social/enablement/components/hbs/learningpath")) {
            this.rsc = resource;
            this.resourceNode = this.rsc.adaptTo(Node.class);
        }
        this.enrolleeListContainer = resource.getChild("enrollee-list-container");
        this.resourceResolver = resource.getResourceResolver();
        this.userManager = resource.adaptTo(UserManager.class);
        this.initialize();
    }

    public AbstractEnablementResource(Resource resource, ClientUtilities clientUtilities, EnablementResource enablementResource) throws PersistenceException, EnablementContentNotFound, EnablementResourceNotFound {
        super(resource, clientUtilities);
        this.clientUtilities = clientUtilities;
        this.resourceResolver = resource.getResourceResolver();
        String resourceSuffix = clientUtilities.getRequest().getRequestPathInfo().getSuffix();
        this.rsc = this.resourceResolver.getResource(resourceSuffix);
        this.enrolleeListContainer = this.rsc.getChild("enrollee-list-container");
        this.userManager = this.rsc.adaptTo(UserManager.class);
        this.resourceNode = this.rsc.adaptTo(Node.class);
        this.initialize();
    }

    public AbstractEnablementResource(Resource resource, ClientUtilities clientUtilities, String nameHint) throws PersistenceException, EnablementResourceNotFound, RepositoryException {
        this(resource, clientUtilities, nameHint, resource.getPath(), resource.getResourceResolver());
        this.clientUtilities = clientUtilities;
        this.resourceNode = this.rsc.adaptTo(Node.class);
        this.resourceNode.setProperty("sling:resourceType", "social/enablement/components/hbs/resource");
        this.setupSocialNodes();
    }

    public AbstractEnablementResource(Resource resource, ClientUtilities clientUtilities, String title, String resourceGroupContainerPath, ResourceResolver resourceResolver) throws PersistenceException, RepositoryException, EnablementResourceNotFound {
        super(resource, clientUtilities);
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("jcr:title", title);
        properties.put("enablement-resource-name", title);
        properties.put("jcr:primaryType", ENABLEMENT_CONTENT_PRIMARY_TYPE);
        Calendar c = Calendar.getInstance();
        properties.put("date-created", c);
        properties.put("date-modified", c);
        properties.put("date-first-published", c);
        properties.put("created-by", resourceResolver.adaptTo(User.class).getUserId());
        resource = SlingResourceUtils.CreateUniqueResource(resourceResolver, resourceResolver.getResource(resourceGroupContainerPath), JcrUtil.createValidName(this.getUniqueResourceNodeName(resource)), properties);
        this.resourceResolver = resource.getResourceResolver();
        resourceResolver.create(resource, CARD_IMAGE_CONTAINER, null);
        EnablementContentUUIDUtils.createOrGetEcUUID(resource);
        this.enrolleeListContainer = resourceResolver.create(resource, "enrollee-list-container", null);
        this.userManager = resource.adaptTo(UserManager.class);
        this.rsc = resource;
        this.resourceNode = this.rsc.adaptTo(Node.class);
        this.session = this.resourceResolver.adaptTo(Session.class);
    }

    private String getUniqueResourceNodeName(Resource resource) throws PersistenceException {
        String prefix = "res";
        return ResourceUtil.createUniqueChildName(resource.getParent(), prefix.toLowerCase());
    }

    @Override
    public String getPath() {
        if (this.rsc == null) {
            return null;
        }
        return this.rsc.getPath();
    }

    @Override
    public String getTitle() {
        if (this.rsc == null) {
            return null;
        }
        return (String)((Object)this.rsc.adaptTo(ValueMap.class).get("jcr:title", String.class));
    }

    @Override
    public String getECUUID() {
        if (this.rsc == null) {
            return null;
        }
        return EnablementContentUUIDUtils.getEcUUID(this.rsc);
    }

    @Override
    public void setTitle(String title) {
        this.rsc.adaptTo(ModifiableValueMap.class).put("jcr:title", title);
        this.rsc.adaptTo(ModifiableValueMap.class).put("enablement-resource-name", title);
    }

    @Override
    public void setLastModified() {
        this.rsc.adaptTo(ModifiableValueMap.class).put("date-modified", Calendar.getInstance());
    }

    @Override
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getContentCreatorPrincipalId() {
        if (this.rsc == null) {
            return null;
        }
        return (String)((Object)this.rsc.adaptTo(ValueMap.class).get("created-by", String.class));
    }

    @Override
    public String getEnablementResourceId() {
        if (this.rsc == null) {
            return null;
        }
        return (String)((Object)this.rsc.adaptTo(ValueMap.class).get("id", String.class));
    }

    @Override
    public void setEnablementResourceId(String id) throws RepositoryException {
        if (id != null) {
            this.rsc.adaptTo(ModifiableValueMap.class).put("id", id);
        }
    }

    @Override
    public String getDescription() {
        if (this.rsc == null) {
            return null;
        }
        return (String)((Object)this.rsc.adaptTo(ValueMap.class).get("description", String.class));
    }

    @Override
    public void setDescription(String desc) throws RepositoryException {
        if (desc != null) {
            this.rsc.adaptTo(ModifiableValueMap.class).put("description", desc);
        }
    }

    @Override
    public String getSitePath() {
        if (this.rsc == null) {
            return null;
        }
        return this.rsc.adaptTo(CommunityContext.class).getSitePagePath();
    }

    @Override
    public void updateContacts(JSONArray contactsList, String contactType) throws JSONException, RepositoryException, PersistenceException {
        if (contactsList == null) {
            return;
        }
        ModifiableValueMap valueMap = this.rsc.adaptTo(ModifiableValueMap.class);
        String[] values = new String[contactsList.length()];
        for (int i = 0; i < contactsList.length(); ++i) {
            values[i] = contactsList.getString(i);
        }
        valueMap.put(contactType, values);
    }

    @Override
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public JSONArray getContactsAuthorizableIds(String contactType) throws JSONException, RepositoryException {
        if (this.rsc == null) {
            return null;
        }
        Object value = this.rsc.adaptTo(ValueMap.class).get(contactType);
        JSONArray contacts = new JSONArray();
        if (value != null) {
            String[] contactsList;
            for (String contact : contactsList = (String[])value) {
                if (StringUtils.isBlank((String)contact)) continue;
                contacts.put(new JSONObject(contact));
            }
        }
        return contacts;
    }

    @Override
    public void setSendEnrollmentEmail(boolean sendEnrolmentEmail) throws RepositoryException {
        this.rsc.adaptTo(ModifiableValueMap.class).put("send-enrollment-email", sendEnrolmentEmail);
    }

    @Override
    public boolean getSendEnrollmentEmail() {
        if (this.rsc == null) {
            return false;
        }
        return this.rsc.adaptTo(ValueMap.class).get("send-enrollment-email", false);
    }

    @Override
    public void setEnforcedOrder(boolean isEnforcedOrder) {
        this.rsc.adaptTo(ModifiableValueMap.class).put("enforce-order", false);
    }

    @Override
    public void setPrerequisites(List<PrerequisiteLearningPath> prerequisites) {
    }

    @Override
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<String> getAuthors() throws RepositoryException, JSONException {
        JSONArray contacts = this.getContactsAuthorizableIds("resource-author");
        List<String> contactsAuthorizableIds = this.adaptToEnablementContentContact(contacts);
        return contactsAuthorizableIds;
    }

    @Override
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<String> getExperts() throws RepositoryException, JSONException {
        JSONArray experts = this.getContactsAuthorizableIds("resource-expert");
        List<String> expertsAuthorizableIds = this.adaptToEnablementContentContact(experts);
        return expertsAuthorizableIds;
    }

    @Override
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<String> getContacts() throws RepositoryException, JSONException {
        JSONArray contacts = this.getContactsAuthorizableIds("resource-contact");
        List<String> contactsAuthorizableIds = this.adaptToEnablementContentContact(contacts);
        return contactsAuthorizableIds;
    }

    private List<String> adaptToEnablementContentContact(JSONArray jsonArray) throws JSONException, RepositoryException {
        ArrayList<String> contacts = new ArrayList<String>();
        if (jsonArray != null) {
            String jsonStr = "";
            for (int i = 0; i < jsonArray.length(); ++i) {
                jsonStr = jsonArray.getString(i);
                if (StringUtils.isBlank((String)jsonStr)) continue;
                contacts.add(jsonStr);
            }
        }
        return contacts;
    }

    @Override
    public List<EnablementContentContact> getResourceAuthors() throws RepositoryException {
        return this.getEnablementResourceContacts("resource-author");
    }

    @Override
    public List<EnablementContentContact> getResourceExperts() throws RepositoryException {
        return this.getEnablementResourceContacts("resource-expert");
    }

    @Override
    public List<EnablementContentContact> getResourceContacts() throws RepositoryException {
        return this.getEnablementResourceContacts("resource-contact");
    }

    @Override
    public List<EnablementContentContact> getResourceEnrollments() throws RepositoryException {
        if (this.rsc == null) {
            return null;
        }
        if (this.enrolleeListContainer == null) {
            return null;
        }
        Node enrolleeListNode = this.enrolleeListContainer.adaptTo(Node.class);
        if (!enrolleeListNode.hasProperty(AUTHORIZABLE_ID_LIST_PROPERTY)) {
            return null;
        }
        Property enrolleeList = enrolleeListNode.getProperty(AUTHORIZABLE_ID_LIST_PROPERTY);
        Value[] values = enrolleeList.getValues();
        ArrayList<String> stringList = new ArrayList<String>();
        for (int i = 0; i < values.length; ++i) {
            try {
                stringList.add(values[i].getString());
                continue;
            }
            catch (RepositoryException e) {
                // empty catch block
            }
        }
        String[] rslt = new String[stringList.size()];
        rslt = stringList.toArray(rslt);
        return this.createEnablementResourceContacts(rslt);
    }

    private List<EnablementContentContact> getEnablementResourceContacts(String contactType) {
        if (this.rsc == null) {
            return null;
        }
        Object value = this.rsc.adaptTo(ValueMap.class).get(contactType);
        if (value == null) {
            return null;
        }
        String[] contactsList = (String[])value;
        return this.createEnablementResourceContacts(contactsList);
    }

    private List<EnablementContentContact> createEnablementResourceContacts(String[] contactsList) {
        ArrayList<EnablementContentContact> resourceContactList = new ArrayList<EnablementContentContact>();
        for (String contact : contactsList) {
            if (StringUtils.isBlank((String)contact)) continue;
            JSONObject tmp = null;
            try {
                tmp = new JSONObject(contact);
            }
            catch (JSONException except) {
                // empty catch block
            }
            final JSONObject resourceContactJson = tmp;
            EnablementContentContact resourceContact = new EnablementContentContact(){
                private final JSONObject jsonObj;
                {
                    this.jsonObj = resourceContactJson;
                }

                private String getProperty(String prop) {
                    if (this.jsonObj == null) {
                        return "";
                    }
                    if (!this.jsonObj.has(prop)) {
                        return "";
                    }
                    String val = "";
                    try {
                        val = this.jsonObj.getString(prop);
                    }
                    catch (JSONException jSONException) {
                        // empty catch block
                    }
                    return val;
                }

                @Override
                public String getPrincipalName() {
                    return this.getProperty("userName");
                }

                @Override
                public String getAuthorizableId() {
                    return this.getProperty(AbstractEnablementResource.USER_ID_PROPERTY);
                }

                @Override
                public String getProfileImage() {
                    return "";
                }

                @Override
                public String getProfilePath() {
                    return "";
                }

                @Override
                public String getEmail() {
                    return this.getProperty("userEmail");
                }
            };
            resourceContactList.add(resourceContact);
        }
        return resourceContactList;
    }

    @Override
    public List<EnablementContentContact> getContacts(String contactType) throws RepositoryException {
        if (this.rsc == null) {
            return null;
        }
        ValueMap valueMap = this.rsc.adaptTo(ValueMap.class);
        ArrayList<EnablementContentContact> contacts = new ArrayList<EnablementContentContact>();
        if (valueMap != null && valueMap.containsKey(contactType)) {
            String[] contactsList;
            for (String contact : contactsList = (String[])valueMap.get(contactType)) {
                UserProperties properties = null;
                try {
                    if (!StringUtils.isBlank((String)contact)) {
                        String userIdValue = new JSONObject(contact).getString(USER_ID_PROPERTY);
                        UserPropertiesManager upm = this.rsc.getResourceResolver().adaptTo(UserPropertiesManager.class);
                        if (userIdValue != null && upm != null) {
                            properties = upm.getUserProperties(userIdValue, PROFILE_PATH);
                        }
                    }
                }
                catch (JSONException e) {
                    this.log.error("Can not parse the contact information", (Throwable)e);
                }
                if (properties == null) continue;
                contacts.add(new EnablementContentContactImpl(properties, this.resourceResolver));
            }
        }
        return contacts;
    }

    @Override
    public boolean isPublished() {
        if (this.rsc == null) {
            return false;
        }
        ReplicationStatus resourceReplicationStatus = this.rsc.adaptTo(ReplicationStatus.class);
        return resourceReplicationStatus.isActivated();
    }

    @Override
    public Date getFirstPublishedDate() {
        if (this.rsc == null) {
            return null;
        }
        ReplicationStatus resourceReplicationStatus = this.rsc.adaptTo(ReplicationStatus.class);
        if (!resourceReplicationStatus.isDelivered()) {
            return null;
        }
        Calendar c = (Calendar)((Object)this.rsc.adaptTo(ValueMap.class).get("date-first-published", Calendar.class));
        return c == null ? null : c.getTime();
    }

    @Override
    public List<String> getTags() throws RepositoryException {
        if (this.rsc == null) {
            return null;
        }
        ValueMap valueMap = this.rsc.adaptTo(ValueMap.class);
        List<String> resourceTags = new ArrayList<String>();
        if (valueMap != null && valueMap.containsKey("cq:tags")) {
            String[] tags = (String[])valueMap.get("cq:tags");
            resourceTags = Arrays.asList(tags);
        }
        return resourceTags;
    }

    @Override
    public void updateTags(List<String> tags) throws RepositoryException, PersistenceException {
        if (tags == null) {
            return;
        }
        ModifiableValueMap valueMap = this.rsc.adaptTo(ModifiableValueMap.class);
        ArrayList<String> values = new ArrayList<String>();
        for (String tag : tags) {
            if (tag == null || tag.equals("")) continue;
            values.add(tag);
        }
        valueMap.put("cq:tags", values.toArray());
        if (!this.resourceNode.isNodeType("cq:Taggable")) {
            this.resourceNode.addMixin("cq:Taggable");
        }
    }

    @Override
    public void updateDueDate(Calendar dueDate) throws RepositoryException, PersistenceException {
        if (dueDate == null) {
            return;
        }
        ModifiableValueMap valueMap = this.rsc.adaptTo(ModifiableValueMap.class);
        valueMap.put("due-date", dueDate);
    }

    @Override
    public boolean isPublic() throws RepositoryException {
        return this.hasTags();
    }

    private boolean hasTags() throws RepositoryException {
        return this.getTags() != null && this.getTags().size() > 0;
    }

    @Override
    public void resetDeltaJson() throws JSONException, RepositoryException {
        Node enrolleeListNode = this.enrolleeListContainer.adaptTo(Node.class);
        if (enrolleeListNode.hasProperty(AUTHORIZABLE_ID_LIST_PROPERTY)) {
            Value[] values;
            Property enrolleeList = enrolleeListNode.getProperty(AUTHORIZABLE_ID_LIST_PROPERTY);
            JSONObject enrolledeltaList = new JSONObject();
            for (Value value : values = enrolleeList.getValues()) {
                enrolledeltaList.put(new JSONObject(value.getString()).getString(USER_ID_PROPERTY), "+");
            }
            enrolleeListNode.setProperty(AUTHORIZABLE_DELTA_ID_LIST_PROPERTY, enrolledeltaList.toString());
        }
    }

    @Override
    public void deleteDeltajson() throws JSONException, RepositoryException {
        Node enrolleeListNode = this.enrolleeListContainer.adaptTo(Node.class);
        if (enrolleeListNode.hasProperty(AUTHORIZABLE_DELTA_ID_LIST_PROPERTY)) {
            Property enrolleeList = enrolleeListNode.getProperty(AUTHORIZABLE_DELTA_ID_LIST_PROPERTY);
            enrolleeList.setValue("{}");
        }
    }

    @Override
    public void updateEnrollesDelta(JSONObject authorizablesMap) throws JSONException, RepositoryException {
        if (authorizablesMap == null) {
            return;
        }
        Node enrolleeListContainerNode = this.enrolleeListContainer.adaptTo(Node.class);
        ValueFactory valueFactory = enrolleeListContainerNode.getSession().getValueFactory();
        JSONObject enrolleeDeltaJsonOld = this.getEnrolleesDeltaJson();
        Iterator<String> enrolleeDeltaIterator = authorizablesMap.keys();
        while (enrolleeDeltaIterator.hasNext()) {
            String key = enrolleeDeltaIterator.next();
            String value = authorizablesMap.getString(key);
            if (enrolleeDeltaJsonOld.has(key) && !enrolleeDeltaJsonOld.getString(key).equalsIgnoreCase(value)) {
                enrolleeDeltaJsonOld.remove(key);
                continue;
            }
            if (enrolleeDeltaJsonOld.has(key)) continue;
            enrolleeDeltaJsonOld.put(key, value);
        }
        enrolleeListContainerNode.setProperty(AUTHORIZABLE_DELTA_ID_LIST_PROPERTY, valueFactory.createValue(enrolleeDeltaJsonOld.toString()));
    }

    @Override
    @JsonIgnore
    public JSONObject getEnrolleesDeltaJson() throws JSONException, RepositoryException {
        if (this.rsc == null || this.enrolleeListContainer == null) {
            return null;
        }
        Node enrolleeListNode = this.enrolleeListContainer.adaptTo(Node.class);
        JSONObject enrolleeDeltaJson = new JSONObject();
        if (enrolleeListNode.hasProperty(AUTHORIZABLE_DELTA_ID_LIST_PROPERTY)) {
            Property enrolleeList = enrolleeListNode.getProperty(AUTHORIZABLE_DELTA_ID_LIST_PROPERTY);
            Value value = enrolleeList.getValue();
            enrolleeDeltaJson = new JSONObject(value.getString());
        }
        return enrolleeDeltaJson;
    }

    @Override
    public void updateEnrolles(JSONArray enrolleesUpdate) throws JSONException, RepositoryException {
        if (enrolleesUpdate == null) {
            return;
        }
        Node enrolleeListContainerNode = this.enrolleeListContainer.adaptTo(Node.class);
        ValueFactory valueFactory = enrolleeListContainerNode.getSession().getValueFactory();
        Value[] values = new Value[enrolleesUpdate.length()];
        for (int i = 0; i < enrolleesUpdate.length(); ++i) {
            values[i] = valueFactory.createValue(enrolleesUpdate.getString(i));
        }
        enrolleeListContainerNode.setProperty(AUTHORIZABLE_ID_LIST_PROPERTY, values);
    }

    @Override
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getEnrolleesJson() throws RepositoryException, JSONException {
        if (this.rsc == null) {
            return null;
        }
        String[] enrolleeList = this.getListOfEnrolledAuthorizableIds();
        JSONArray enrollees = new JSONArray();
        if (enrolleeList != null) {
            for (int i = 0; i < enrolleeList.length; ++i) {
                JSONObject enrollee = new JSONObject(enrolleeList[i]);
                enrollees.put(enrollee);
            }
        }
        return enrollees.toString();
    }

    @Override
    @JsonIgnore
    public JSONArray getEnrollees() throws RepositoryException, JSONException {
        if (this.rsc == null) {
            return null;
        }
        String[] enrolleeList = this.getListOfEnrolledAuthorizableIds();
        JSONArray enrollees = new JSONArray();
        if (enrolleeList != null) {
            for (int i = 0; i < enrolleeList.length; ++i) {
                JSONObject enrollee = new JSONObject(enrolleeList[i]);
                enrollees.put(enrollee);
            }
        }
        return enrollees;
    }

    @Override
    public String[] getListOfEnrolledAuthorizableIds() throws RepositoryException {
        if (this.rsc == null) {
            return null;
        }
        String[] enrollees = null;
        if (this.enrolleeListContainer == null) {
            return enrollees;
        }
        Node enrolleeListNode = this.enrolleeListContainer.adaptTo(Node.class);
        if (enrolleeListNode.hasProperty(AUTHORIZABLE_ID_LIST_PROPERTY)) {
            Property enrolleeList = enrolleeListNode.getProperty(AUTHORIZABLE_ID_LIST_PROPERTY);
            Value[] values = enrolleeList.getValues();
            enrollees = new String[values.length];
            for (int i = 0; i < values.length; ++i) {
                enrollees[i] = values[i].getString();
            }
        }
        return enrollees;
    }

    @Override
    public void enrollAuthorizables(JSONObject enrolleList, EnablementResource.EnrollmentOperation operation) throws RepositoryException, PersistenceException {
        Group directEnrolleGroup = this.createOrGetEnrolleeGroup(EnablementResource.ENROLLMENT_GROUPS.ENROLLEE);
        if (operation == EnablementResource.EnrollmentOperation.PUBLISH_ENROLLMENT) {
            this.clearAllMembersFromGroup(directEnrolleGroup);
            this.addDirectEnrollmentQueryNode();
        }
        Iterator<String> keys = enrolleList.keys();
        while (keys.hasNext()) {
            String value;
            String key = keys.next();
            try {
                value = enrolleList.getString(key);
            }
            catch (JSONException e) {
                this.log.error("The Json passed as for enrollment in replication is not well formed");
                throw new RepositoryException((Throwable)e);
            }
            Authorizable authorizable = this.userManager.getAuthorizable(key);
            if (authorizable == null) continue;
            if (value.equalsIgnoreCase("+")) {
                directEnrolleGroup.addMember(authorizable);
                continue;
            }
            if (!value.equalsIgnoreCase("-")) continue;
            directEnrolleGroup.removeMember(authorizable);
        }
        this.fixIndirectEnrollments();
    }

    @Override
    public Group createOrGetEnrolleeGroup(EnablementResource.ENROLLMENT_GROUPS enrollmentGroup) throws RepositoryException {
        Group enrolleeGrp = this.getEnrolleeGroup(enrollmentGroup);
        if (enrolleeGrp == null) {
            enrolleeGrp = this.createEnrolleeGroup(enrollmentGroup);
            if (!this.isPublic()) {
                AccessControlUtil.replaceAccessControlEntry(this.resourceResolver.adaptTo(Session.class), this.rsc.getPath(), enrolleeGrp.getPrincipal(), new String[]{"{http://www.jcp.org/jcr/1.0}read"}, null, null, null);
            } else {
                UserUtils userUtils = this.resourceResolver.adaptTo(UserUtils.class);
                CommunityContext context = this.rsc.adaptTo(CommunityContext.class);
                String groupSiteMembersId = userUtils.getCommunitySiteGroupName(context, CommunityUserGroup.MEMBER);
                Authorizable groupSiteMembers = this.userManager.getAuthorizable(groupSiteMembersId);
                AccessControlUtil.replaceAccessControlEntry(this.resourceResolver.adaptTo(Session.class), this.rsc.getPath(), groupSiteMembers.getPrincipal(), new String[]{"{http://www.jcp.org/jcr/1.0}read"}, null, null, null);
            }
        }
        return enrolleeGrp;
    }

    @Override
    public String getEnrolleeGroupId(EnablementResource.ENROLLMENT_GROUPS enrollmentGroup) throws RepositoryException {
        if (this.rsc == null) {
            return null;
        }
        return (String)((Object)this.rsc.adaptTo(ValueMap.class).get(enrollmentGroup.type, String.class));
    }

    @Override
    @JsonIgnore
    public List<Authorizable> getCurrentEnrollees() throws RepositoryException {
        if (this.rsc == null) {
            return null;
        }
        ArrayList<Authorizable> enrollees = new ArrayList<Authorizable>();
        Group enrolleeGroup = this.createOrGetEnrolleeGroup(EnablementResource.ENROLLMENT_GROUPS.ENROLLEE);
        Iterator<Authorizable> keys = enrolleeGroup.getMembers();
        while (keys.hasNext()) {
            enrollees.add(keys.next());
        }
        return enrollees;
    }

    private Group getEnrolleeGroup(EnablementResource.ENROLLMENT_GROUPS enrollmentGroup) throws RepositoryException {
        if (this.rsc == null) {
            return null;
        }
        String groupId = this.getEnrolleeGroupId(enrollmentGroup);
        if (groupId != null) {
            return (Group)this.userManager.getAuthorizable(groupId);
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Group createEnrolleeGroup(EnablementResource.ENROLLMENT_GROUPS enrollmentGroup) throws RepositoryException {
        String groupId;
        String groupIdPrefix = EnablementContentUUIDUtils.createOrGetEcUUID(this.rsc);
        final String finalGroupId = groupId = groupIdPrefix + enrollmentGroup.name;
        Principal principal = new Principal(){

            @Override
            public String getName() {
                return finalGroupId;
            }
        };
        Session session = this.resourceResolver.adaptTo(Session.class);
        Authorizable authorizable = this.userManager.getAuthorizable(groupId);
        Group grp = null;
        if (authorizable != null) {
            if (!(authorizable instanceof Group)) throw new AuthorizableExistsException("Authorizable already exist, id: " + groupId);
            grp = (Group)authorizable;
        } else {
            grp = this.userManager.createGroup(principal, AbstractEnablementResource.getIntermediatePathForEnrollmentgroups(this.rsc.adaptTo(CommunityContext.class), this.rsc.getName()));
        }
        this.rsc.adaptTo(ModifiableValueMap.class).put(enrollmentGroup.type, grp.getID());
        grp.setProperty("ecGroupType", session.getValueFactory().createValue(enrollmentGroup.type));
        grp.setProperty("ecPath", session.getValueFactory().createValue(this.rsc.getPath()));
        return grp;
    }

    public static String getIntermediatePathForEnrollmentgroups(CommunityContext comunityContext, String enrollableContentpath) {
        String path = BundleUtils.getEnablementSiteService().getSiteResourceGroupsPath(comunityContext);
        return path + '/' + enrollableContentpath;
    }

    private void clearAllMembersFromGroup(Group grp) throws RepositoryException {
        Iterator<Authorizable> members = grp.getDeclaredMembers();
        while (members.hasNext()) {
            Authorizable member = members.next();
            grp.removeMember(member);
        }
    }

    private void addDirectEnrollmentQueryNode() throws RepositoryException, PersistenceException {
        Group directEnrolleeGroup = this.createOrGetEnrolleeGroup(EnablementResource.ENROLLMENT_GROUPS.ENROLLEE);
        UserUtils userUtils = this.resourceResolver.adaptTo(UserUtils.class);
        CommunityContext context = this.rsc.adaptTo(CommunityContext.class);
        String groupSiteAdministratorsId = userUtils.getCommunitySiteGroupName(context, CommunityUserGroup.GROUP_ADMIN);
        Authorizable groupSiteAdministrators = this.userManager.getAuthorizable(groupSiteAdministratorsId);
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("jcr:primaryType", ENABLEMENT_CONTENT_PRIMARY_TYPE);
        properties.put("directly-enrolled", true);
        Resource enrollmentQueryResource = this.resourceResolver.create(this.rsc, "enrollment", properties);
        Session session = this.resourceResolver.adaptTo(Session.class);
        AccessControlUtil.replaceAccessControlEntry(session, enrollmentQueryResource.getPath(), this.userManager.getAuthorizable("everyone").getPrincipal(), null, new String[]{"{http://www.jcp.org/jcr/1.0}all"}, null, null);
        if (directEnrolleeGroup != null) {
            AccessControlUtil.replaceAccessControlEntry(session, enrollmentQueryResource.getPath(), directEnrolleeGroup.getPrincipal(), new String[]{"{http://www.jcp.org/jcr/1.0}read"}, null, null, null);
        }
        if (groupSiteAdministrators != null) {
            AccessControlUtil.replaceAccessControlEntry(session, enrollmentQueryResource.getPath(), groupSiteAdministrators.getPrincipal(), new String[]{"{http://www.jcp.org/jcr/1.0}all"}, null, null, null);
        }
    }

    protected void validateContent() throws StatusException {
    }

    public static void validateRequestParams(Map<String, String[]> parameterMap) throws OperationNotAllowedOnResource, RepositoryException {
        for (String fieldName : MANDATORY_FIELDS) {
            String[] params = parameterMap.get(fieldName);
            if (params == null) {
                throw new OperationNotAllowedOnResource((FailureCodes)ResourceFailureCodes.MANDATORY_PARAMETER_MISSING, fieldName);
            }
            try {
                JSONArray paramValsArray = new JSONArray(params[0]);
                if (paramValsArray.length() != 0) continue;
                throw new OperationNotAllowedOnResource((FailureCodes)ResourceFailureCodes.MANDATORY_PARAMETER_MISSING, fieldName);
            }
            catch (JSONException e) {
                String paramVals = params[0];
                if (!paramVals.isEmpty()) continue;
                throw new OperationNotAllowedOnResource((FailureCodes)ResourceFailureCodes.MANDATORY_PARAMETER_MISSING, fieldName);
            }
        }
        for (String contactType : CONTACT_TYPES) {
            String[] params = parameterMap.get(contactType);
            if (params == null) continue;
            try {
                JSONArray paramValsArray = new JSONArray(params[0]);
                if (paramValsArray.length() <= 3) continue;
                throw new OperationNotAllowedOnResource((FailureCodes)ResourceFailureCodes.ENABLEMENT_RESOURCE_MAX_CONTACTS, contactType);
            }
            catch (JSONException e) {
                throw new OperationNotAllowedOnResource((FailureCodes)ResourceFailureCodes.MANDATORY_PARAMETER_MISSING, contactType);
            }
        }
    }

    @Override
    public String getCardImagePath(String defVal) {
        if (this.rsc == null) {
            return defVal;
        }
        String coverImageSrc = this.rsc.adaptTo(ValueMap.class).get(CARD_IMAGE_PATH, null);
        if (null == coverImageSrc) {
            return defVal;
        }
        if (coverImageSrc.startsWith("./")) {
            return this.rsc.getPath() + coverImageSrc.substring(1);
        }
        return coverImageSrc;
    }

    @Override
    public String getCardImagePath() {
        return this.getCardImagePath(null);
    }

    @Override
    public boolean isSocialAllowed() {
        if (this.rsc == null) {
            return true;
        }
        return this.rsc.adaptTo(ValueMap.class).get("allow-social-switch", false);
    }

    @Override
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getAssetProperties() {
        JSONArray assets = new JSONArray();
        try {
            assets = this.getAssetDetails();
        }
        catch (JSONException e) {
            this.log.error("Error while getting asset details", (Throwable)e);
        }
        return assets.toString();
    }

    private Node getSocialContentNode() throws RepositoryException {
        if (this.resourceNode == null) {
            return null;
        }
        if (this.resourceNode.hasNode("social")) {
            return this.resourceNode.getNode("social");
        }
        return null;
    }

    @Override
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getSocialContentParentPath() throws RepositoryException {
        Node socialContentNode = this.getSocialContentNode();
        return socialContentNode != null ? socialContentNode.getParent().getPath() : null;
    }

    @Override
    public boolean isCommentsAllowed() {
        if (this.rsc == null) {
            return true;
        }
        return this.isSocialAllowed() && this.rsc.adaptTo(ValueMap.class).get("allow-comments", false) != false;
    }

    @Override
    public boolean isRatingsAllowed() {
        if (this.rsc == null) {
            return true;
        }
        return this.isSocialAllowed() && this.rsc.adaptTo(ValueMap.class).get("allow-ratings", false) != false;
    }

    @Override
    public Vector<String> getSocialNodePaths() throws RepositoryException {
        String commentsPath;
        if (this.rsc == null) {
            return null;
        }
        Vector<String> socialNodes = new Vector<String>();
        String ratingPath = this.getRatingsNodePath();
        if (ratingPath != null) {
            socialNodes.add(ratingPath);
        }
        if ((commentsPath = this.getCommentsNodePath()) != null) {
            socialNodes.add(commentsPath);
        }
        return socialNodes;
    }

    @Override
    public String getRatingsNodePath() throws RepositoryException {
        if (this.rsc == null) {
            return null;
        }
        if (this.isRatingsAllowed()) {
            Node socialContentNode = this.getSocialContentNode();
            return socialContentNode != null ? socialContentNode.getNode("ratings").getPath() : null;
        }
        return null;
    }

    @Override
    public String getCommentsNodePath() throws RepositoryException {
        if (this.isCommentsAllowed()) {
            Node socialContentNode = this.getSocialContentNode();
            return socialContentNode != null ? socialContentNode.getNode("discussion").getPath() : null;
        }
        return null;
    }

    @Override
    public String getCommentModeration() {
        if (this.rsc == null) {
            return null;
        }
        return this.rsc.adaptTo(ValueMap.class).get("moderate-comments", "moderate-comments");
    }

    @Override
    @JsonIgnore
    public JSONArray getAssetDetails() throws JSONException {
        JSONArray assetArr = new JSONArray();
        if (this.rsc == null) {
            return assetArr;
        }
        Iterator<ResourceAsset> assetsIter = this.getAssets();
        while (assetsIter.hasNext()) {
            ResourceAsset ra = assetsIter.next();
            JSONObject assetObj = new JSONObject();
            assetObj.put("title", ra.getTitle());
            assetObj.put("coverImg", ra.getCoverImagePath());
            assetObj.put("thumbnail-source", ra.getThumbnailSource());
            String assetCategory = ra.getAssetCategory();
            assetObj.put("asset-category", assetCategory);
            if ("enablementAsset:dam".equals(assetCategory)) {
                assetObj.put("path", ra.getUnderlyingAsset().getPath());
                if (ra.isBasedOnDamAsset()) {
                    Asset asset = ((DamAsset)ra.getUnderlyingAsset()).getAsset();
                    assetObj.put("type", asset.getMimeType());
                    assetObj.put("size", asset.getMetadataValue("dam:size"));
                }
            } else if ("enablementAsset:url".equals(assetCategory)) {
                UrlAsset urlAsset = (UrlAsset)ra.getUnderlyingAsset();
                assetObj.put("path", ra.getAssetPath());
                assetObj.put("resource-asset-name", ra.getTitle());
                assetObj.put("url", urlAsset.getUrl());
                assetObj.put("asset-sub-category", urlAsset.getSubType());
            } else if ("enablementAsset:externalResource".equals(assetCategory)) {
                ExternalResourceAsset externalAsset = (ExternalResourceAsset)ra.getUnderlyingAsset();
                assetObj.put("path", ra.getAssetPath());
                assetObj.put("resource-asset-name", ra.getTitle());
                assetObj.put("location", externalAsset.getLocation());
            }
            assetArr.put(assetObj);
        }
        return assetArr;
    }

    @Override
    public long getSize() {
        ResourceAsset ra;
        if (this.rsc == null) {
            return 0L;
        }
        Iterator<ResourceAsset> assetsIter = this.getAssets();
        if (assetsIter.hasNext() && (ra = assetsIter.next()).isBasedOnDamAsset()) {
            return ((DamAsset)ra.getUnderlyingAsset()).getSize().intValue();
        }
        return -1L;
    }

    @Override
    public String getFriendlySize() {
        double size = this.getSize();
        if (size < 0.0) {
            return null;
        }
        double meg = 1048576.0;
        double kilo = 1024.0;
        if (size > meg) {
            return String.format("%1$,.1f", size / meg) + "M";
        }
        if (size > kilo) {
            return String.format("%1$,.1f", size / kilo) + "K";
        }
        return String.valueOf(size);
    }

    @Override
    public String getAssetType() {
        if (this.rsc == null) {
            return null;
        }
        Iterator<ResourceAsset> assetsIter = this.getAssets();
        if (assetsIter.hasNext()) {
            ResourceAsset ra = assetsIter.next();
            return ra.getUnderlyingAsset().getFriendlyType();
        }
        return null;
    }

    private ResourceAsset getFirstAsset() {
        if (this.rsc == null) {
            return null;
        }
        Iterator<ResourceAsset> assetsIter = this.getAssets();
        if (assetsIter.hasNext()) {
            ResourceAsset ra = assetsIter.next();
            return ra;
        }
        return null;
    }

    @Override
    public boolean isImage() {
        ResourceAsset asset = this.getFirstAsset();
        return asset != null && asset.isImage();
    }

    @Override
    public String getExternalUrl() {
        if (this.rsc == null) {
            return null;
        }
        ResourceAsset asset = this.getFirstAsset();
        if (asset == null || !asset.isUrl()) {
            return null;
        }
        try {
            return asset.getUnderlyingAsset().getAssetResource().adaptTo(Node.class).getProperty("url").getString();
        }
        catch (RepositoryException e) {
            return null;
        }
    }

    @Override
    public String getResourceType() {
        if (this.rsc == null) {
            return null;
        }
        String resourceType = "";
        boolean foundFirstAsset = false;
        Resource assetContainerResource = this.rsc.getChild(ASSET_ARRAY);
        if (assetContainerResource != null) {
            for (Resource assetRsrc : this.rsc.getChild(ASSET_ARRAY).getChildren()) {
                ResourceAsset ra = assetRsrc.adaptTo(ResourceAsset.class);
                if (ra == null) continue;
                if (!foundFirstAsset) {
                    resourceType = ra.getType();
                    foundFirstAsset = true;
                    continue;
                }
                resourceType = "resource_path";
                break;
            }
        }
        return resourceType;
    }

    @Override
    @JsonIgnore
    public RatingComponent getRating() throws RepositoryException {
        String ratingNodePath;
        if (this.rsc == null) {
            return null;
        }
        if (this.isRatingsAllowed() && (ratingNodePath = this.getRatingsNodePath()) != null) {
            Resource ratingResource = this.resourceResolver.getResource(ratingNodePath);
            return ratingResource.adaptTo(RatingComponent.class);
        }
        return null;
    }

    @Override
    public Iterator<ResourceAsset> getAssets() {
        if (this.rsc == null) {
            return null;
        }
        LinkedList<ResourceAsset> list = new LinkedList<ResourceAsset>();
        Resource assetContainerResource = this.rsc.getChild(ASSET_ARRAY);
        if (assetContainerResource != null) {
            for (Resource assetRsrc : this.rsc.getChild(ASSET_ARRAY).getChildren()) {
                ResourceAsset ra = assetRsrc.adaptTo(ResourceAsset.class);
                if (ra == null) continue;
                list.add(ra);
            }
        }
        return list.iterator();
    }

    @Override
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public org.apache.jackrabbit.api.security.user.User getAuthor() throws RepositoryException {
        String authorPrincipleId = this.getContentCreatorPrincipalId();
        if (authorPrincipleId == null) {
            return null;
        }
        Authorizable authorizable = null;
        authorizable = this.userManager.getAuthorizable(authorPrincipleId);
        return (org.apache.jackrabbit.api.security.user.User)authorizable;
    }

    @Override
    public String getFriendlyDueDate() {
        String dueDate = this.getDueDate();
        SimpleDateFormat friendlyFormatter = new SimpleDateFormat("MM/dd/yy");
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date date = null;
        if (null != dueDate && !dueDate.equals("")) {
            try {
                date = formatter.parse(dueDate);
            }
            catch (ParseException e) {
                LOG.error("Failed to parse current date ", (Throwable)e);
            }
            return friendlyFormatter.format(date);
        }
        return "";
    }

    @Override
    public String getDueDate() {
        if (this.rsc == null) {
            return "";
        }
        Calendar dueDate = (Calendar)((Object)this.rsc.adaptTo(ValueMap.class).get("due-date", Calendar.class));
        if (null == dueDate) {
            return "";
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return dateFormat.format(dueDate.getTime());
    }

    @Override
    public String getPublishedDate() {
        if (this.rsc == null) {
            return null;
        }
        ValueMap props = this.rsc.adaptTo(ValueMap.class);
        String pubDate = (String)((Object)props.get("cq:lastReplicated", String.class));
        return pubDate;
    }

    @Override
    public String getDuration() {
        if (this.rsc == null) {
            return null;
        }
        return (String)((Object)this.rsc.adaptTo(ValueMap.class).get("duration", String.class));
    }

    @Override
    public String getAuthorName() {
        String[] experts;
        if (this.rsc == null) {
            return "unknown";
        }
        ValueMap vmap = this.rsc.adaptTo(ValueMap.class);
        String[] authors = (String[])vmap.get("resource-author", String[].class);
        String authorName = this.getResourceContactName(authors);
        if (authorName == null && (authorName = this.getResourceContactName(experts = (String[])vmap.get("resource-contact", String[].class))) == null) {
            authorName = "unknown";
        }
        return authorName;
    }

    private String getResourceContactName(String[] contacts) {
        if (contacts == null) {
            return null;
        }
        String jsonStr = contacts[0];
        try {
            JSONObject jsonAuthor = new JSONObject(jsonStr);
            if (jsonAuthor.has("userName")) {
                return jsonAuthor.getString("userName");
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public Resource getResource() {
        return this.rsc;
    }

    @Override
    public JSONObject toJsonObject() throws TallyException, JSONException, RepositoryException {
        if (this.rsc == null) {
            return new JSONObject();
        }
        JSONObject jsonObj = this.rsc.adaptTo(JSONObject.class);
        try {
            jsonObj.put("name", this.getTitle());
        }
        catch (Exception e) {
            this.log.error("Failed to get the jcr:title for old resource " + this.rsc.getPath(), (Throwable)e);
        }
        try {
            jsonObj.put(ASSET_ARRAY, ResourceUtils.getResourceAssets(this));
        }
        catch (Exception e) {
            this.log.error("Failed to get the resource assets for the resource: " + this.rsc.getPath(), (Throwable)e);
        }
        try {
            jsonObj.put("contacts", this.getContactsAuthorizableIds("resource-contact"));
        }
        catch (Exception e) {
            this.log.error("Failed to get the resource contacts for the resource: " + this.rsc.getPath(), (Throwable)e);
        }
        return jsonObj;
    }

    private boolean fetchResourceCoverImgFromAsset(Node coverImgContainerNode, Session session) throws RepositoryException {
        String assetCoverImgPath;
        Node assetNode;
        String assetNodeThumbnailType;
        String assetNodePath = "assets/asset";
        if (this.resourceNode.hasNode(assetNodePath) && !(assetNodeThumbnailType = (assetNode = this.resourceNode.getNode(assetNodePath)).getProperty("thumbnail-source").getString()).equalsIgnoreCase("default") && session.nodeExists(assetCoverImgPath = assetNode.getPath() + "/" + assetNode.getProperty("cover-img-path").getString())) {
            Utils.deleteNodeChildren(coverImgContainerNode, ENABLEMENT_CONTENT_PRIMARY_TYPE);
            String coverImgPath = "./" + assetCoverImgPath.substring(this.resourceNode.getPath().length() + 1);
            this.resourceNode.setProperty(CARD_IMAGE_PATH, coverImgPath);
            return true;
        }
        return false;
    }

    private void createAssetReferences(Node assetNode) throws RepositoryException {
        if (assetNode.getName().equals("asset")) {
            try {
                Node origAssetNode = assetNode.getSession().getNode(assetNode.getProperty("original-asset-path").getString());
                Node origAssetMetadataNode = origAssetNode.getNode("jcr:content/metadata");
                Boolean assetWorkflowCompleted = false;
                if (origAssetMetadataNode.hasProperty("dam:workflowCompleted")) {
                    assetWorkflowCompleted = "true".equals(origAssetMetadataNode.getProperty("dam:workflowCompleted").getString());
                }
                if (!assetWorkflowCompleted.booleanValue()) {
                    Value[] valueArray = new Value[]{};
                    ArrayList<Value> assetRefList = new ArrayList<Value>();
                    if (origAssetMetadataNode.hasProperty("dc:assetCopiedToPaths")) {
                        for (Value v : origAssetMetadataNode.getProperty("dc:assetCopiedToPaths").getValues()) {
                            if (v == null) continue;
                            assetRefList.add(v);
                        }
                    }
                    ValueFactory vFactory = origAssetNode.getSession().getValueFactory();
                    Value newPath = vFactory.createValue(assetNode.getPath());
                    assetRefList.add(newPath);
                    Value[] finalProperty = assetRefList.toArray(valueArray);
                    origAssetMetadataNode.setProperty("dc:assetCopiedToPaths", finalProperty);
                }
            }
            catch (Exception e) {
                this.log.warn("Could not create references to the a copied asset " + assetNode.getPath() + " during resource creation. Workflow updates may be missed");
            }
        }
    }

    @Override
    public void updateCardImage(String coverImgTempPath) throws PersistenceException, RepositoryException, StatusException {
        if (coverImgTempPath != null) {
            String coverImgPath = coverImgTempPath.trim();
            Node coverImgContainerNode = JcrUtils.getOrAddNode(this.resourceNode, CARD_IMAGE_CONTAINER, ENABLEMENT_CONTENT_PRIMARY_TYPE);
            Boolean isDefaultCoverImageInUse = coverImgPath.contains("/assets/asset");
            if (coverImgPath.isEmpty() || !this.session.nodeExists(coverImgPath) || isDefaultCoverImageInUse.booleanValue()) {
                if (this.fetchResourceCoverImgFromAsset(coverImgContainerNode, this.session)) {
                    return;
                }
                this.resourceNode.setProperty(CARD_IMAGE_PATH, (String)null);
                Utils.deleteNodeChildren(coverImgContainerNode, ENABLEMENT_CONTENT_PRIMARY_TYPE);
            } else if (!coverImgPath.startsWith(this.resourceNode.getPath())) {
                Utils.deleteNodeChildren(coverImgContainerNode, ENABLEMENT_CONTENT_PRIMARY_TYPE);
                Node coverImgNode = this.session.getNode(coverImgPath);
                JcrUtil.copy(coverImgNode, coverImgContainerNode, coverImgNode.getName());
                String relCoverImgPath = "./cardimage/" + coverImgNode.getName();
                this.resourceNode.setProperty(CARD_IMAGE_PATH, relCoverImgPath);
                coverImgNode.getParent().remove();
            }
        }
    }

    private void setupSocialNodes() throws RepositoryException, PersistenceException {
        HashMap<String, Object> socialProperties = new HashMap<String, Object>();
        socialProperties.put("jcr:primaryType", ENABLEMENT_CONTENT_PRIMARY_TYPE);
        socialProperties.put("jcr:title", "SoCo");
        Resource socialResource = this.resourceResolver.create(this.rsc, "social", socialProperties);
        HashMap<String, Object> commentsProperties = new HashMap<String, Object>();
        commentsProperties.put("sling:resourceType", "social/commons/components/hbs/comments");
        commentsProperties.put("allowVoting", "true");
        commentsProperties.put("allowRepliesToComments", "true");
        commentsProperties.put("allowDeleteComments", "true");
        commentsProperties.put("allowDenyComments", "true");
        commentsProperties.put("allowFlagComments", "true");
        commentsProperties.put("useReferrer", "true");
        commentsProperties.put("maxMessageLength", "1000");
        this.resourceResolver.create(socialResource, "discussion", commentsProperties);
        HashMap<String, Object> ratingsProperties = new HashMap<String, Object>();
        ratingsProperties.put("sling:resourceType", "social/tally/components/hbs/rating");
        ratingsProperties.put("useReferrer", "true");
        this.resourceResolver.create(socialResource, "ratings", ratingsProperties);
    }

    @Override
    public void setSocialPref(boolean allowSocial, boolean allowComments, boolean allowRatings) throws RepositoryException {
        this.resourceNode.setProperty("allow-social-switch", allowSocial);
        this.resourceNode.setProperty("allow-comments", allowComments);
        this.resourceNode.setProperty("allow-ratings", allowRatings);
    }

    private void deleteAsset(String assetPath) throws PersistenceException, RepositoryException {
        ResourceAsset resourceAsset;
        Resource asset = this.resourceResolver.getResource(assetPath).getParent();
        if (null != asset && (resourceAsset = asset.adaptTo(ResourceAsset.class)) != null) {
            String resourceCoverImgPath = this.getCardImagePath(null);
            if (resourceCoverImgPath != null && resourceCoverImgPath.startsWith(resourceAsset.getPath())) {
                this.resourceNode.setProperty(CARD_IMAGE_PATH, (String)null);
            }
            resourceAsset.deleteAsset();
        }
    }

    private void editAsset(JSONObject assetDetails) throws JSONException, PersistenceException, RepositoryException {
        ResourceAsset resourceAsset;
        Resource asset = this.resourceResolver.getResource(assetDetails.getString("asset-path")).getParent();
        if (null != asset && (resourceAsset = asset.adaptTo(ResourceAsset.class)) != null) {
            String coverImgPath = assetDetails.getString("cover-img-path");
            String thumbnailSrc = assetDetails.getString("thumbnail-source");
            resourceAsset.setCoverImg(coverImgPath, thumbnailSrc);
            resourceAsset.setThumbnailSource(thumbnailSrc);
        }
    }

    private ResourceAsset addAsset(JSONObject assetDetails) throws JSONException, PersistenceException, RepositoryException {
        Node assetContainerNode = this.resourceNode.hasNode(ASSET_ARRAY) ? this.resourceNode.getNode(ASSET_ARRAY) : this.resourceNode.addNode(ASSET_ARRAY, ENABLEMENT_CONTENT_PRIMARY_TYPE);
        String assetCategory = assetDetails.getString("asset-category");
        String assetSubCategory = assetDetails.has("asset-sub-category") ? assetDetails.getString("asset-sub-category") : null;
        String thumbnailSrc = assetDetails.getString("thumbnail-source");
        String coverImgPath = assetDetails.getString("cover-img-path");
        Node addedAssetNode = JcrUtil.createUniqueNode(assetContainerNode, "asset", ENABLEMENT_CONTENT_PRIMARY_TYPE, this.session);
        addedAssetNode.setProperty("sling:resourceType", "social/enablement/components/resource/asset");
        addedAssetNode.setProperty("asset-category", assetCategory);
        addedAssetNode.setProperty("thumbnail-source", thumbnailSrc);
        ResourceAsset resourceAsset = null;
        if ("enablementAsset:dam".equals(assetCategory)) {
            String assetPath = assetDetails.getString("asset-path");
            Node assetNode = this.session.getNode(assetPath);
            JcrUtil.copy(assetNode, addedAssetNode, assetNode.getName());
            addedAssetNode.setProperty("asset-path", "./" + assetNode.getName());
            addedAssetNode.setProperty("original-asset-path", assetNode.getPath());
            addedAssetNode.setProperty("resource-asset-name", assetNode.getName());
            resourceAsset = this.resourceResolver.getResource(addedAssetNode.getPath()).adaptTo(ResourceAsset.class);
            if (resourceAsset != null) {
                Map<String, String> assetProperties = resourceAsset.getUnderlyingAsset().getPropertyMap();
                String courseID = assetProperties.get("courseid");
                addedAssetNode.setProperty("courseid", courseID);
            }
        } else if ("enablementAsset:url".equals(assetCategory)) {
            Node assetNode = JcrUtil.createUniqueNode(addedAssetNode, "url", ENABLEMENT_CONTENT_PRIMARY_TYPE, this.session);
            assetNode.setProperty("url", Utils.normalizeUrl(assetDetails.getString("url")));
            addedAssetNode.setProperty("asset-path", "./" + assetNode.getName());
            addedAssetNode.setProperty("resource-asset-name", assetDetails.getString("resource-asset-name"));
            if (assetSubCategory != null) {
                assetNode.setProperty("asset-sub-category", assetSubCategory);
            }
            resourceAsset = this.resourceResolver.getResource(addedAssetNode.getPath()).adaptTo(ResourceAsset.class);
        } else if ("enablementAsset:externalResource".equals(assetCategory)) {
            Node assetNode = JcrUtil.createUniqueNode(addedAssetNode, "location", ENABLEMENT_CONTENT_PRIMARY_TYPE, this.session);
            assetNode.setProperty("location", assetDetails.getString("location"));
            addedAssetNode.setProperty("asset-path", "./" + assetNode.getName());
            addedAssetNode.setProperty("resource-asset-name", assetDetails.getString("resource-asset-name"));
            if (assetSubCategory != null) {
                assetNode.setProperty("asset-sub-category", assetSubCategory);
            }
            resourceAsset = this.resourceResolver.getResource(addedAssetNode.getPath()).adaptTo(ResourceAsset.class);
        } else {
            this.log.error("Unsupported asset type.");
        }
        if (resourceAsset != null) {
            resourceAsset.setCoverImg(coverImgPath, thumbnailSrc);
        }
        this.createAssetReferences(addedAssetNode);
        return resourceAsset;
    }

    @Override
    public void importContents(JSONArray assetsList) throws RepositoryException, PersistenceException {
        if (null != assetsList) {
            try {
                for (int i = 0; i < assetsList.length(); ++i) {
                    JSONObject assetDetails = assetsList.getJSONObject(i);
                    String state = assetDetails.getString("state");
                    if (null == state || "I".equals(state)) continue;
                    if ("D".equals(state)) {
                        if (!assetDetails.has("asset-path")) continue;
                        this.deleteAsset(assetDetails.getString("asset-path"));
                        continue;
                    }
                    if ("E".equals(state)) {
                        this.editAsset(assetDetails);
                        continue;
                    }
                    if (!"A".equals(state)) continue;
                    this.addAsset(assetDetails);
                }
            }
            catch (JSONException ex) {
                this.log.error("Unable to parse asset details json string :: " + ex);
                throw new RepositoryException((Throwable)ex);
            }
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.log == null ? 0 : this.log.hashCode());
        result = 31 * result + (this.session == null ? 0 : this.session.hashCode());
        result = 31 * result + (this.userManager == null ? 0 : this.userManager.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other instanceof EnablementResource) {
            return this.getPath().equals(((EnablementResource)other).getPath());
        }
        return false;
    }

    private void fixIndirectEnrollments() throws RepositoryException {
        List<EnablementLearningPath> containerLearningPaths = this.getListOfContainerLearningpath();
        Group indirectenrolleeGroup = this.createOrGetEnrolleeGroup(EnablementResource.ENROLLMENT_GROUPS.INDIRECT_ENROLLEE);
        for (int i = 0; i < containerLearningPaths.size(); ++i) {
            Group grp = containerLearningPaths.get(i).createOrGetEnrolleeGroup(EnablementResource.ENROLLMENT_GROUPS.ENROLLEE);
            indirectenrolleeGroup.addMember(grp);
        }
    }

    private List<EnablementLearningPath> getListOfContainerLearningpath() throws RepositoryException {
        if (this.rsc == null) {
            return null;
        }
        ResourceResolver resourceResolver = this.rsc.getResourceResolver();
        ArrayList<EnablementLearningPath> containerLearningPaths = new ArrayList<EnablementLearningPath>();
        Session session = resourceResolver.adaptTo(Session.class);
        PredicateGroup queryPredicate = new PredicateGroup();
        Predicate uuidPredicate = new Predicate("property");
        uuidPredicate.set("property", "ec-link");
        uuidPredicate.set("value", EnablementContentUUIDUtils.getEcUUID(this.rsc));
        queryPredicate.add(uuidPredicate);
        Predicate pathPredicate = new Predicate("path");
        pathPredicate.set("path", this.getSitePath());
        queryPredicate.add(pathPredicate);
        QueryBuilder queryBuilder = resourceResolver.adaptTo(QueryBuilder.class);
        Query query = queryBuilder.createQuery(queryPredicate, session);
        SearchResult searchResult = query.getResult();
        List<Hit> hits = searchResult.getHits();
        for (int i = 0; i < hits.size(); ++i) {
            EnablementLearningPath containerLearningpath;
            LinkedResourceInfo linkedResourceInfo;
            Resource linkedResource = resourceResolver.getResource(hits.get(i).getPath());
            if (linkedResource == null || (linkedResourceInfo = linkedResource.adaptTo(LinkedResourceInfo.class)) == null || (containerLearningpath = linkedResourceInfo.getContainerLearningpath()) == null) continue;
            containerLearningPaths.add(containerLearningpath);
        }
        return containerLearningPaths;
    }

    @Override
    public Vector<String> getSocialAllowedAuthIds() throws RepositoryException {
        if (this.rsc == null) {
            return null;
        }
        Vector<String> userAuthIds = new Vector<String>();
        String enrolleeGrpId = this.getEnrolleeGroupId(EnablementResource.ENROLLMENT_GROUPS.ENROLLEE);
        String indirectenrolleeGrpId = this.getEnrolleeGroupId(EnablementResource.ENROLLMENT_GROUPS.INDIRECT_ENROLLEE);
        if (enrolleeGrpId != null) {
            userAuthIds.add(enrolleeGrpId);
        }
        if (indirectenrolleeGrpId != null) {
            userAuthIds.add(indirectenrolleeGrpId);
        }
        return userAuthIds;
    }

    @Override
    public Object getProperty(String key) {
        if (this.rsc == null) {
            return null;
        }
        return this.rsc.adaptTo(ValueMap.class).get(key);
    }

    @Override
    public void setProperty(String key, Object value) throws RepositoryException {
        if (key != null) {
            this.rsc.adaptTo(ModifiableValueMap.class).put(key, value);
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String[] getTagNameSpaces() {
        CommunityContext communityContext = null;
        if (this.rsc == null) {
            Resource suffixResource = this.clientUtilities.getRequest().getRequestPathInfo().getSuffixResource();
            communityContext = suffixResource.adaptTo(CommunityContext.class);
        } else {
            communityContext = this.rsc.adaptTo(CommunityContext.class);
        }
        if (communityContext != null) {
            String configNodePath = communityContext.getSitePath();
            Resource configNode = this.resourceResolver.getResource(configNodePath);
            return (String[])configNode.adaptTo(ValueMap.class).get(TAG_NAMESPACES, String[].class);
        }
        return null;
    }

    @Override
    public boolean isEnforcedOrderEnabled() {
        return false;
    }

    @Override
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<PrerequisiteLearningPath> getPrerequisites() {
        return null;
    }
}

