/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.enablement.model;

import com.adobe.cq.social.enablement.model.api.EnablementContentContact;
import com.adobe.cq.social.ugcbase.SocialUtils;
import com.adobe.cq.social.ugcbase.core.SocialResourceUtils;
import com.adobe.granite.security.user.UserProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import javax.jcr.RepositoryException;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnablementContentContactImpl
implements EnablementContentContact {
    private final ResourceResolver resolver;
    private UserProperties userProperties;
    private static final Logger LOG = LoggerFactory.getLogger(EnablementContentContactImpl.class);

    public EnablementContentContactImpl(UserProperties properties, ResourceResolver resolver) {
        this.userProperties = properties;
        this.resolver = resolver;
    }

    @Override
    public String getPrincipalName() {
        try {
            return this.userProperties != null ? this.userProperties.getDisplayName() : null;
        }
        catch (RepositoryException e) {
            LOG.error("failed to get displayname for {}", (Object)this.getAuthorizableId());
            return null;
        }
    }

    @Override
    public String getProfilePath() {
        try {
            return this.userProperties != null ? this.userProperties.getNode().getPath() : null;
        }
        catch (RepositoryException e) {
            LOG.error("failed to get the profile path for {}", (Object)this.getAuthorizableId());
            return null;
        }
    }

    @Override
    public String getProfileImage() {
        Resource image;
        String url = SocialResourceUtils.getAvatar(this.userProperties, "/etc/designs/default/images/social/avatar.png", SocialUtils.AVATAR_SIZE.FOURTY_EIGHT);
        if (!"/etc/designs/default/images/social/avatar.png".equals(url) && !StringUtils.startsWith((CharSequence)url, (CharSequence)SocialResourceUtils.GRAVATAR_PREFIX) && StringUtils.lastIndexOf((CharSequence)url, (CharSequence)".prof.thumbnail.") > 0 && (image = this.resolver.resolve(url.substring(0, url.lastIndexOf(".prof.thumbnail.")))) != null && image.getResourceMetadata() != null && image.getResourceMetadata().getModificationTime() > 0L) {
            url = url + "?ck=" + image.getResourceMetadata().getModificationTime() / 1000L;
        }
        return url;
    }

    @Override
    public String getAuthorizableId() {
        return this.userProperties != null ? this.userProperties.getAuthorizableID() : null;
    }

    @Override
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getEmail() {
        try {
            return this.userProperties != null ? this.userProperties.getProperty("email") : null;
        }
        catch (RepositoryException e) {
            LOG.error("failed to get email for {}", (Object)this.getAuthorizableId());
            return null;
        }
    }
}

