/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.enablement.model;

import com.adobe.cq.social.community.api.CommunityContext;
import com.adobe.cq.social.enablement.exception.AmbiguityInContainedEnablementResource;
import com.adobe.cq.social.enablement.exception.ContainedEnablementResourceNotFound;
import com.adobe.cq.social.enablement.exception.ResourceNotALinkedResource;
import com.adobe.cq.social.enablement.model.EnablementLearningPathItemInfo;
import com.adobe.cq.social.enablement.model.EnablementResource;
import com.adobe.cq.social.enablement.model.LinkedResource;
import com.adobe.cq.social.enablement.model.LinkedResourceInfoImpl;
import com.adobe.cq.social.enablement.services.api.ResourceDetailsImpl;
import com.adobe.cq.social.enablement.utils.BundleUtils;
import com.adobe.cq.social.enablement.utils.SlingResourceUtils;
import com.adobe.cq.social.tally.client.api.TallyException;
import com.day.cq.replication.ReplicationActionType;
import com.day.cq.search.Predicate;
import com.day.cq.search.PredicateGroup;
import com.day.cq.search.Query;
import com.day.cq.search.QueryBuilder;
import com.day.cq.search.result.Hit;
import com.day.cq.search.result.SearchResult;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinkedResourceImpl
extends LinkedResourceInfoImpl
implements LinkedResource {
    private EnablementResource enablementResource;
    private static final Logger log = LoggerFactory.getLogger(LinkedResourceImpl.class);

    public LinkedResourceImpl(Resource resource, ResourceResolver resourceResolver) throws RepositoryException, ResourceNotALinkedResource, ContainedEnablementResourceNotFound, AmbiguityInContainedEnablementResource {
        super(resource, resourceResolver);
        Session session = resourceResolver.adaptTo(Session.class);
        PredicateGroup queryPredicate = new PredicateGroup();
        Predicate uuidPredicate = new Predicate("property");
        uuidPredicate.set("property", "ec-uuid");
        uuidPredicate.set("value", this.getEnablementResourceIdentifier());
        queryPredicate.add(uuidPredicate);
        if (!BundleUtils.isPublishedInstance()) {
            Predicate publishPredicate = new Predicate("property");
            publishPredicate.set("property", "cq:lastReplicationAction");
            publishPredicate.set("value", ReplicationActionType.ACTIVATE.getName());
            queryPredicate.add(publishPredicate);
        }
        Predicate pathPredicate = new Predicate("path");
        CommunityContext context = resource.adaptTo(CommunityContext.class);
        pathPredicate.set("path", context.getSiteResourcesPath());
        queryPredicate.add(pathPredicate);
        QueryBuilder queryBuilder = resourceResolver.adaptTo(QueryBuilder.class);
        Query query = queryBuilder.createQuery(queryPredicate, session);
        SearchResult searchResult = query.getResult();
        List<Hit> hits = searchResult.getHits();
        if (hits.size() < 1) {
            log.info("This may be the case where original resource got deleted, or given resource resolver don't have sufficent permission to access the corresponding EnablementResource");
            throw new ContainedEnablementResourceNotFound(this.getEnablementResourceIdentifier());
        }
        if (hits.size() > 1) {
            ArrayList<String> ambiguousPaths = new ArrayList<String>();
            for (int i = 0; i < hits.size(); ++i) {
                ambiguousPaths.add(hits.get(0).getPath());
            }
            throw new AmbiguityInContainedEnablementResource(this.getEnablementResourceIdentifier(), ambiguousPaths);
        }
        this.enablementResource = hits.get(0).getResource().adaptTo(EnablementResource.class);
    }

    public LinkedResourceImpl(ResourceResolver resourceResolver, EnablementResource srcEnablementResource, Resource destResource) throws PersistenceException, RepositoryException {
        this.enablementResource = srcEnablementResource;
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("sling:resourceType", " social/enablement/components/learningpath/linkedresource");
        properties.put("ec-link", this.enablementResource.getECUUID());
        properties.put("mandatory", true);
        this.resource = SlingResourceUtils.CreateUniqueResource(resourceResolver, destResource, this.enablementResource.getECUUID(), properties);
    }

    @Override
    public EnablementResource getEnablementResource() {
        return this.enablementResource;
    }

    @Override
    public JSONObject detail() throws JSONException, RepositoryException {
        ResourceDetailsImpl rdi = new ResourceDetailsImpl();
        try {
            JSONObject result = rdi.getResourceDetails(this.enablementResource.getResource());
            result.put("type", (Object)EnablementLearningPathItemInfo.ENABLEMENT_LEARNINGPATH_ITEM_TYPE.LINKED_RESOURCE);
            return result;
        }
        catch (TallyException te) {
            throw new RepositoryException((Throwable)te);
        }
    }
}

