/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.enablement.utils;

import com.adobe.cq.social.enablement.model.EnablementResource;
import com.adobe.cq.social.enablement.model.resourceAsset.ResourceAsset;
import io.sightly.java.api.Use;
import javax.script.Bindings;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.request.RequestPathInfo;
import org.apache.sling.api.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CourseData
implements Use {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private boolean isValid;
    private boolean isSupported;
    private EnablementResource resource;
    private ResourceAsset asset;

    @Override
    public void init(Bindings bindings) {
        try {
            this.internalInit(bindings);
            this.isValid = this.resource != null;
        }
        catch (Exception e) {
            this.logger.error("Couldn't initialize object", (Throwable)e);
            this.isValid = false;
        }
    }

    private void internalInit(Bindings bindings) throws Exception {
        SlingHttpServletRequest slingRequest = (SlingHttpServletRequest)bindings.get("request");
        RequestPathInfo rpi = slingRequest.getRequestPathInfo();
        Resource suffixResource = rpi.getSuffixResource();
        this.resource = suffixResource.adaptTo(EnablementResource.class);
        try {
            this.asset = this.resource.getAssets().next();
            boolean assetIsCaptivate = this.asset.isCaptivate();
            boolean assetIsSWF = this.asset.isSWF();
            boolean assetIsPDF = this.asset.isPDF();
            boolean assetIsMP3 = this.asset.isMP3();
            boolean assetIsVideo = this.asset.isMP4();
            boolean assetIsImage = this.asset.isImage();
            boolean assetIsPresenter = this.asset.isPresenter();
            boolean assetIsGenericScorm = this.asset.isGenericScorm();
            this.isSupported = assetIsCaptivate || assetIsSWF || assetIsPDF || assetIsMP3 || assetIsVideo || assetIsImage || assetIsPresenter || assetIsGenericScorm;
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public EnablementResource getResource() {
        return this.resource;
    }

    public ResourceAsset getAsset() {
        return this.asset;
    }

    public boolean hasAsset() {
        return this.asset != null;
    }

    public boolean getIsValid() {
        return this.isValid;
    }

    public boolean getIsSupportedAsset() {
        return this.isSupported;
    }
}

