/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.enablement.utils;

import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;

public class EnablementContentUUIDUtils {
    private static final int MAX_UUID_LENGTH = 200;
    public static final String EC_UUID = "ec-uuid";

    public static String getEcUUID(Resource resource) {
        String uuid = (String)((Object)resource.adaptTo(ValueMap.class).get(EC_UUID, String.class));
        return uuid;
    }

    public static String createOrGetEcUUID(Resource resource) {
        String uuid = EnablementContentUUIDUtils.getEcUUID(resource);
        if (uuid == null) {
            String uniquePrefix = "_" + Integer.toString(resource.getPath().hashCode()) + System.currentTimeMillis();
            int charsAllowedForResourceName = 200 - uniquePrefix.length();
            uuid = resource.getName().substring(0, resource.getName().length() > charsAllowedForResourceName ? charsAllowedForResourceName : resource.getName().length()) + uniquePrefix;
            resource.adaptTo(ModifiableValueMap.class).put(EC_UUID, uuid);
        }
        return uuid;
    }
}

