/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.enablement.utils;

import com.adobe.cq.social.enablement.model.EnablementLearningPath;
import com.adobe.cq.social.enablement.model.EnablementLearningPathItem;
import com.adobe.cq.social.enablement.model.EnablementLearningPathItemInfo;
import com.adobe.cq.social.enablement.model.EnablementResource;
import com.adobe.cq.social.enablement.model.LinkedResource;
import java.util.List;
import javax.jcr.RepositoryException;
import org.apache.sling.commons.json.JSONArray;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;

public class EnablementLearningPathUtils {
    public static final String LINKED_RESOURCE_NAME = "name";
    public static final String LINKED_RESOURCE_SIZE = "size";
    public static final String LINKED_RESOURCE_PATH = "path";
    public static final String LINKED_RESOURCE_ASSET_TYPE = "asset-type";
    public static final String LINKED_RESOURCE_CARD_IMG_PATH = "card-img";

    public static JSONArray getEnablementLearningPathItems(EnablementLearningPath enablementLearningPath) throws JSONException, RepositoryException {
        JSONArray itemsJson = new JSONArray();
        if (enablementLearningPath != null) {
            List<EnablementLearningPathItem> items = enablementLearningPath.getItems();
            for (int ctr = 0; ctr < items.size(); ++ctr) {
                EnablementLearningPathItem item = items.get(ctr);
                JSONObject itemJson = new JSONObject();
                itemJson.put("type", (Object)item.getType());
                if (item.getType() == EnablementLearningPathItemInfo.ENABLEMENT_LEARNINGPATH_ITEM_TYPE.LINKED_RESOURCE) {
                    LinkedResource linkedResource = (LinkedResource)item;
                    EnablementResource enablementResource = linkedResource.getEnablementResource();
                    itemJson.put(LINKED_RESOURCE_NAME, enablementResource.getTitle());
                    itemJson.put(LINKED_RESOURCE_PATH, enablementResource.getPath());
                    itemJson.put(LINKED_RESOURCE_SIZE, enablementResource.getSize());
                    itemJson.put(LINKED_RESOURCE_ASSET_TYPE, enablementResource.getAssetType());
                    itemJson.put(LINKED_RESOURCE_CARD_IMG_PATH, enablementResource.getCardImagePath(null));
                }
                itemsJson.put(ctr, itemJson);
            }
        }
        return itemsJson;
    }
}

