/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.enablement.utils;

import com.adobe.cq.social.enablement.model.EnablementLearningPath;
import com.adobe.cq.social.enablement.model.EnablementResource;
import com.adobe.cq.social.enablement.model.resourceAsset.ResourceAsset;
import com.adobe.cq.social.tally.RatingComponent;
import com.adobe.cq.social.tally.client.api.Rating;
import com.adobe.cq.social.tally.client.api.TallyException;
import com.adobe.granite.ui.components.Value;
import java.util.Iterator;
import javax.jcr.AccessDeniedException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.commons.json.JSONArray;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;

public class ResourceUtils {
    public static final String RATINGS_AVG = "average";
    public static final String RATINGS_USER = "user-rating";
    public static final String RATINGS_USER_STRING = "user-rating-string";
    public static final String RATINGS_COUNT = "count";

    public static final EnablementResource getEnablementResourceFromContentPath(SlingHttpServletRequest request) {
        ResourceResolver resourceResolver = request.getResourceResolver();
        String valueResourcePath = (String)request.getAttribute(Value.CONTENTPATH_ATTRIBUTE);
        if (valueResourcePath != null) {
            Resource valueResource = resourceResolver.getResource(valueResourcePath);
            EnablementResource enablementResource = valueResource.adaptTo(EnablementResource.class);
            return enablementResource;
        }
        return null;
    }

    public static final EnablementLearningPath getEnablementLearningPathFromContentPath(SlingHttpServletRequest request) {
        ResourceResolver resourceResolver = request.getResourceResolver();
        String valueResourcePath = (String)request.getAttribute(Value.CONTENTPATH_ATTRIBUTE);
        if (valueResourcePath != null) {
            Resource valueResource = resourceResolver.getResource(valueResourcePath);
            EnablementLearningPath enablementLearningPath = valueResource.adaptTo(EnablementLearningPath.class);
            return enablementLearningPath;
        }
        return null;
    }

    public static final EnablementResource getEnablementEnrollableContentFromContentPath(SlingHttpServletRequest request) {
        ResourceResolver resourceResolver = request.getResourceResolver();
        String valueResourcePath = (String)request.getAttribute(Value.CONTENTPATH_ATTRIBUTE);
        if (valueResourcePath != null) {
            Resource valueResource = resourceResolver.getResource(valueResourcePath);
            EnablementResource enablementEnrollableContent = valueResource.adaptTo(EnablementResource.class);
            return enablementEnrollableContent;
        }
        return null;
    }

    public static final EnablementResource getEnablementContentFromContentPath(SlingHttpServletRequest request) {
        ResourceResolver resourceResolver = request.getResourceResolver();
        String valueResourcePath = (String)request.getAttribute(Value.CONTENTPATH_ATTRIBUTE);
        if (valueResourcePath != null) {
            Resource valueResource = resourceResolver.getResource(valueResourcePath);
            EnablementResource enablementContent = valueResource.adaptTo(EnablementResource.class);
            return enablementContent;
        }
        return null;
    }

    public static boolean isEnablementResource(Resource resource) throws RepositoryException {
        return resource.adaptTo(EnablementResource.class) != null;
    }

    public static boolean isResourceEditMode(SlingHttpServletRequest slingRequest) throws RepositoryException {
        Resource suffixResource = slingRequest.getRequestPathInfo().getSuffixResource();
        return ResourceUtils.isEnablementResource(suffixResource);
    }

    public static JSONArray getResourceAssets(EnablementResource resource) throws RepositoryException, JSONException {
        JSONArray ret = new JSONArray();
        Iterator<ResourceAsset> iter = resource.getAssets();
        while (iter.hasNext()) {
            ResourceAsset asset = iter.next();
            JSONObject obj = new JSONObject(asset.getPropertyMap());
            ret.put(obj);
        }
        return ret;
    }

    public static JSONObject getResourceRating(EnablementResource resource) throws RepositoryException, TallyException, JSONException {
        JSONObject ratingsObj = new JSONObject();
        RatingComponent ratingsComponent = resource.getRating();
        if (ratingsComponent != null) {
            Float average = ratingsComponent.getAverageRating();
            Long count = ratingsComponent.getTotalNumberOfResponses();
            ratingsObj.put(RATINGS_AVG, average);
            ratingsObj.put(RATINGS_COUNT, count);
            Rating rating = null;
            try {
                rating = (Rating)ratingsComponent.getCurrentUserResponse();
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            if (rating != null) {
                Float userRating = ((Rating)ratingsComponent.getCurrentUserResponse()).getRating();
                String userRatingStr = ((Rating)ratingsComponent.getCurrentUserResponse()).getResponseValue();
                ratingsObj.put(RATINGS_USER, userRating);
                ratingsObj.put(RATINGS_USER_STRING, userRatingStr);
            }
        }
        return ratingsObj;
    }

    public static Node getResourceFromAssetNode(Node assetNode) {
        try {
            return assetNode.getParent().getParent();
        }
        catch (AccessDeniedException e) {
            return null;
        }
        catch (ItemNotFoundException e) {
            return null;
        }
        catch (RepositoryException e) {
            return null;
        }
    }

    public static boolean isResourceSearchableUpon(String prop) {
        return prop.equalsIgnoreCase("jcr:title");
    }
}

