/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.enablement.utils;

import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;

public class Utils {
    public static void deleteNodeIfExists(Node parentNode, String childNodeName) throws RepositoryException {
        if (parentNode.hasNode(childNodeName)) {
            parentNode.getNode(childNodeName).remove();
        }
    }

    public static void deleteNodeChildren(Node parentNode, String nodeType) throws RepositoryException {
        NodeIterator nodeItr = parentNode.getNodes();
        while (nodeItr.hasNext()) {
            Node child = nodeItr.nextNode();
            if (nodeType == null || !nodeType.equals(child.getPrimaryNodeType().getName())) continue;
            child.remove();
        }
    }

    public static Calendar parseDate(String dateStr, String dateFormat) throws ParseException {
        if (null != dateStr && !"".equals(dateStr)) {
            SimpleDateFormat dateFormatter = new SimpleDateFormat(dateFormat);
            dateFormatter.parse(dateStr);
            return dateFormatter.getCalendar();
        }
        return null;
    }

    public static String readableFileSize(long size) {
        if (size <= 0L) {
            return "0";
        }
        String[] units = new String[]{"B", "KB", "MB", "GB", "TB"};
        int digitGroups = (int)(Math.log10(size) / Math.log10(1024.0));
        return new DecimalFormat("#,##0.#").format((double)size / Math.pow(1024.0, digitGroups)) + " " + units[digitGroups];
    }

    public static String normalizeUrl(String url) {
        if (!url.startsWith("http://") && !url.startsWith("https://")) {
            return "http://" + url;
        }
        return url;
    }
}

