/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.filelibrary.client.api;

import com.adobe.cq.social.commons.comments.api.AbstractComment;
import com.adobe.cq.social.commons.comments.listing.CommentSocialComponentListProviderManager;
import com.adobe.cq.social.filelibrary.client.api.AbstractFileLibraryConfiguration;
import com.adobe.cq.social.filelibrary.client.api.Asset;
import com.adobe.cq.social.filelibrary.client.api.FileLibraryConfiguration;
import com.adobe.cq.social.filelibrary.client.api.FileLibraryUtils;
import com.adobe.cq.social.scf.ClientUtilities;
import com.adobe.cq.social.scf.CollectionPagination;
import com.adobe.cq.social.scf.QueryRequestInfo;
import com.adobe.cq.social.scf.SocialComponent;
import com.adobe.cq.social.scf.core.DefaultResourceID;
import com.adobe.cq.social.scf.core.ResourceID;
import javax.jcr.RepositoryException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAsset<T extends FileLibraryConfiguration>
extends AbstractComment<T>
implements Asset<T> {
    private static final String TOPIC_HTML_SUFFIX = ".asset.html";
    private final String name;
    private final Resource parent;
    protected ValueMap properties;
    protected final boolean isFolder;
    private CommentSocialComponentListProviderManager listProviderManager;
    private static final Logger LOG = LoggerFactory.getLogger(AbstractAsset.class);

    public AbstractAsset(Resource resource, ClientUtilities clientUtils, CommentSocialComponentListProviderManager listProviderManager) throws RepositoryException {
        this(resource, clientUtils, QueryRequestInfo.DEFAULT_QUERY_INFO_FACTORY.create(), listProviderManager);
    }

    public AbstractAsset(Resource resource, ClientUtilities clientUtils, QueryRequestInfo queryInfo, CommentSocialComponentListProviderManager listProviderManager) throws RepositoryException {
        super(resource, clientUtils, queryInfo, listProviderManager);
        this.properties = ResourceUtil.getValueMap(resource);
        this.name = (String)((Object)this.properties.get("jcr:title", String.class));
        this.parent = FileLibraryUtils.getParent(resource, false);
        this.isFolder = resource.getResourceResolver().isResourceType(resource, "social/filelibrary/components/hbs/folder");
        this.listProviderManager = listProviderManager;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isFolder() {
        return this.isFolder;
    }

    @Override
    public String getFileLibraryId() {
        return this.getParentId();
    }

    @Override
    public boolean isFileLibraryClosed() {
        return false;
    }

    @Override
    public String getFriendlyUrl() {
        String pagePath = this.clientUtils.getSocialUtils().getContainingPage(this.parent).getPath();
        ResourceID urlid = this.id;
        if (!this.isFolder()) {
            urlid = new DefaultResourceID(this.getResource());
        }
        return this.clientUtils.externalLink(pagePath, false) + TOPIC_HTML_SUFFIX + urlid + ".html";
    }

    @Override
    public void setPagination(CollectionPagination pagination) {
        super.setPagination(pagination);
    }

    @Override
    public T createConfiguration(Resource resource, Resource cs) {
        return (T)new AbstractFileLibraryConfiguration(cs);
    }

    @Override
    public String getParentName() {
        SocialComponent parent = this.getParentComponent();
        if (parent == null || !(parent instanceof Asset)) {
            return null;
        }
        Asset parentAsset = (Asset)this.getParentComponent();
        return parentAsset.getName();
    }

    @Override
    public String getParentFriendlyUrl() {
        SocialComponent parent = this.getParentComponent();
        if (parent == null) {
            return null;
        }
        return parent.getFriendlyUrl();
    }
}

