/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.filelibrary.client.api;

import com.adobe.cq.social.ugcbase.SocialUtils;
import com.adobe.cq.social.ugcbase.core.SocialResourceUtils;
import com.adobe.granite.security.user.UserProperties;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileLibraryUtils {
    private static final Logger LOG = LoggerFactory.getLogger(FileLibraryUtils.class);

    public static Resource getParent(Resource resource, boolean forceLibrary) {
        if (resource == null) {
            return null;
        }
        ResourceResolver resolver = resource.getResourceResolver();
        if (SocialResourceUtils.isSocialResource(resource)) {
            Resource parent;
            if (forceLibrary) {
                for (parent = resource.getParent(); parent != null; parent = parent.getParent()) {
                    if (!resolver.isResourceType(parent, "social/filelibrary/components/hbs/filelibrary")) continue;
                    return parent;
                }
            }
            return parent;
        }
        Resource parent = resource.getParent();
        while (parent != null) {
            try {
                Property primaryType = parent.adaptTo(Node.class).getProperty("jcr:primaryType");
                if (!forceLibrary || resolver.isResourceType(parent, "social/filelibrary/components/hbs/filelibrary")) break;
                parent = parent.getParent();
            }
            catch (RepositoryException e) {
                LOG.error("Error getParent for " + resource.getPath(), (Throwable)e);
            }
        }
        return parent;
    }

    public static UserProperties getUserProperties(ResourceResolver resolver, String userId) {
        SocialUtils socialUtils = resolver.adaptTo(SocialUtils.class);
        UserProperties userProperties = socialUtils.getUserProperties(resolver, userId);
        return userProperties;
    }
}

