/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.filelibrary.client.endpoints;

import com.adobe.cq.social.scf.core.servlets.AbstractSessionServlet;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=true, label="AEM Social Communities FilelibraryDownloadGetServlet", description="This servlet serves the GET request for social components")
@Service(value={Servlet.class})
@Properties(value={@Property(name="sling.servlet.resourceTypes", value={"sling/servlet/default"}, propertyPrivate=true), @Property(name="sling.servlet.methods", value={"GET"}, propertyPrivate=true), @Property(name="sling.servlet.selectors", value={"download"}, propertyPrivate=false), @Property(name="sling.servlet.extensions", value={"json"}, propertyPrivate=false)})
public class FilelibraryDownloadGetServlet
extends AbstractSessionServlet {
    protected static final String CONTENT_TYPE = "application/json";
    protected static final String ENCODING = "utf-8";
    private static final long serialVersionUID = 351915124629267812L;
    private static final Logger LOG = LoggerFactory.getLogger(FilelibraryDownloadGetServlet.class);
    public static final String DOWNLOAD = "download";

    @Override
    protected final void doPost(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        this.handleMethodNotImplemented(request, response);
    }

    @Override
    protected final void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        Resource fileResource = request.getResource();
        InputStream inStream = fileResource.adaptTo(InputStream.class);
        ServletContext context = this.getServletContext();
        String mimeType = context.getMimeType(fileResource.getPath());
        if (mimeType == null) {
            mimeType = "application/octet-stream";
        }
        response.setContentType(mimeType);
        String headerKey = "Content-Disposition";
        String headerValue = String.format("attachment; filename*=UTF-8''%s", URLEncoder.encode(fileResource.getName(), "UTF-8"));
        response.setHeader(headerKey, headerValue);
        ServletOutputStream outStream = response.getOutputStream();
        byte[] buffer = new byte[4096];
        int bytesRead = -1;
        while ((bytesRead = inStream.read(buffer)) != -1) {
            outStream.write(buffer, 0, bytesRead);
        }
        inStream.close();
        outStream.close();
    }
}

