/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.forum.client.api;

import com.adobe.cq.social.commons.CommentSystem;
import com.adobe.cq.social.commons.comments.api.AbstractComment;
import com.adobe.cq.social.commons.comments.listing.CommentSocialComponentListProviderManager;
import com.adobe.cq.social.forum.client.api.BaseForumConfiguration;
import com.adobe.cq.social.forum.client.api.Forum;
import com.adobe.cq.social.forum.client.api.ForumConfiguration;
import com.adobe.cq.social.forum.client.api.Post;
import com.adobe.cq.social.forum.client.impl.ForumUtils;
import com.adobe.cq.social.forum.client.impl.PostImpl;
import com.adobe.cq.social.scf.ClientUtilities;
import com.adobe.cq.social.scf.CollectionPagination;
import com.adobe.cq.social.scf.QueryRequestInfo;
import com.adobe.cq.social.scf.SocialComponent;
import com.adobe.cq.social.scf.User;
import com.adobe.cq.social.scf.core.DefaultResourceID;
import com.adobe.cq.social.scf.core.ResourceID;
import com.adobe.cq.social.ugcbase.SocialUtils;
import com.day.cq.wcm.api.Page;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPost<T extends ForumConfiguration>
extends AbstractComment<T>
implements Post<T> {
    private static final String CQ_META_NODE_NAME = "cq:meta";
    private static final String PROP_VIEWS = "views";
    private static final String SEARCH_SUFFIX_LONG = "_tl";
    private static final String TOPIC_HTML_SUFFIX = ".topic.html";
    private Resource latestPost;
    private final Resource parent;
    private int numReplies;
    private ValueMap properties;
    private boolean isTopic;
    private final int numParticipants = -1;
    private User lastModifiedUser;
    private CommentSocialComponentListProviderManager listProviderManager;
    private boolean isAnalyticsEnabled;
    private static final Logger LOG = LoggerFactory.getLogger(PostImpl.class);

    public AbstractPost(Resource resource, ClientUtilities clientUtils, CommentSocialComponentListProviderManager listProviderManager) throws RepositoryException {
        this(resource, clientUtils, QueryRequestInfo.DEFAULT_QUERY_INFO_FACTORY.create(), listProviderManager);
    }

    public AbstractPost(Resource resource, ClientUtilities clientUtils, QueryRequestInfo queryInfo, CommentSocialComponentListProviderManager listProviderManager) throws RepositoryException {
        super(resource, clientUtils, queryInfo, listProviderManager);
        this.properties = ResourceUtil.getValueMap(resource);
        this.isTopic = this.isTopLevel();
        this.parent = ForumUtils.getParent((Resource)resource, (boolean)this.isTopic, (boolean)false);
        this.listProviderManager = listProviderManager;
        this.isAnalyticsEnabled = clientUtils.isAnalyticsServiceConfigured(resource);
    }

    public AbstractPost(Resource resource, ClientUtilities clientUtils, QueryRequestInfo queryInfo, Resource latestPost, int numReplies, CommentSocialComponentListProviderManager listProviderManager) throws RepositoryException {
        this(resource, clientUtils, queryInfo, listProviderManager);
        this.latestPost = latestPost;
        this.numReplies = numReplies;
        this.listProviderManager = listProviderManager;
    }

    @Override
    public String getSubject() {
        String subject = (String)((Object)this.properties.get("jcr:title", String.class));
        if (this.isTopic) {
            return subject;
        }
        if (StringUtils.isEmpty((CharSequence)subject)) {
            return (String)((Object)this.properties.get("jcr:title", String.class));
        }
        return subject;
    }

    @Override
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public User getLastModifiedUser() {
        if (this.lastModifiedUser == null) {
            String userId = null;
            if (this.latestPost != null) {
                try {
                    PostImpl lpost = new PostImpl(this.latestPost, this.clientUtils, this.getQueryRequestInfo(), this.listProviderManager);
                    userId = lpost.getAuthor().getAuthorizableId();
                }
                catch (RepositoryException e) {
                    LOG.error("error getting latest post.", (Throwable)e);
                }
            }
            if (userId == null) {
                userId = super.getAuthor().getAuthorizableId();
            }
            this.lastModifiedUser = this.clientUtils.getUser(userId, this.resource.getResourceResolver());
        }
        return this.lastModifiedUser;
    }

    @Override
    public boolean isPinned() {
        return this.properties.get("pinned", false);
    }

    @Override
    public boolean isClosed() {
        return this.isForumClosed() || this.isTopicClosed();
    }

    @Override
    public boolean isTopicClosed() {
        return super.isClosed();
    }

    @Override
    public boolean isForumClosed() {
        SocialComponent sc = this.getSourceComponent();
        if (sc == null) {
            return false;
        }
        return ((Forum)sc).isClosed();
    }

    @Override
    public boolean isTopic() {
        return this.isTopic;
    }

    @Override
    public String getForumId() {
        SocialComponent sc = this.getSourceComponent();
        if (sc == null) {
            return null;
        }
        return sc.getId().getResourceIdentifier();
    }

    @Override
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getLatestPost() {
        return this.latestPost == null ? null : this.latestPost.getPath();
    }

    @Override
    public void setLatestPost(Resource post) {
        this.latestPost = post;
    }

    @Override
    public void setNumReplies(int replies) {
        this.numReplies = replies;
    }

    @Override
    public String getFriendlyUrl() {
        String pagePath;
        Page page;
        Page page2 = page = this.parent == null ? null : this.clientUtils.getSocialUtils().getContainingPage(this.parent);
        if (page != null) {
            pagePath = page.getPath();
        } else {
            if (this.parent == null) {
                LOG.error("Can not find containing page because parent is null.");
            } else {
                LOG.error("Can not find containing page for {}.", (Object)this.parent.getPath());
            }
            pagePath = null;
        }
        ResourceID urlid = this.id;
        if (!this.isTopic) {
            Resource topicResource = ForumUtils.getParent((Resource)this.getResource(), (boolean)this.isTopic, (boolean)true);
            urlid = new DefaultResourceID(topicResource);
        }
        return this.clientUtils.externalLink(pagePath + TOPIC_HTML_SUFFIX + "/" + StringUtils.substringAfterLast((String)urlid.getResourceIdentifier(), (String)"/"), false) + ".html";
    }

    @Override
    public void setPagination(CollectionPagination pagination) {
        super.setPagination(pagination);
    }

    @Override
    protected T createConfiguration(Resource resource, Resource commentSystem) {
        return (T)new BaseForumConfiguration(commentSystem);
    }

    @Override
    public Map<String, Integer> getViewCounts() {
        Resource analyticsMetaData;
        HashMap<String, Integer> viewCounts = new HashMap<String, Integer>();
        if (this.isAnalyticsEnabled && (analyticsMetaData = this.resource.getChild(CQ_META_NODE_NAME)) != null) {
            for (Resource reportConfig : analyticsMetaData.getChildren()) {
                ValueMap vm = reportConfig.getValueMap();
                viewCounts.put(reportConfig.getName(), vm.get("views_" + reportConfig.getName() + SEARCH_SUFFIX_LONG, 0));
            }
        }
        return viewCounts;
    }

    @Override
    protected boolean canUserReply(boolean userIsLoggedIn, CommentSystem cs, Session session) {
        if (!userIsLoggedIn) {
            return false;
        }
        boolean mayPost = false;
        SocialUtils socialUtils = this.clientUtils.getSocialUtils();
        if (socialUtils == null) {
            return false;
        }
        String aclPath = socialUtils.resourceToACLPath(cs.getResource());
        mayPost = this.clientUtils.getSocialUtils().canAddNode(session, aclPath == null ? "/content/usergenerated" : aclPath);
        if (this.isTopLevel()) {
            return !this.isClosed() && mayPost;
        }
        return cs.allowsReplies() && !this.isClosed() && mayPost;
    }
}

