/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.forum.client.endpoints;

import com.adobe.cq.social.commons.Comment;
import com.adobe.cq.social.commons.CommentSystem;
import com.adobe.cq.social.commons.comments.endpoints.AbstractCommentOperationService;
import com.adobe.cq.social.forum.client.api.Post;
import com.adobe.cq.social.scf.Operation;
import com.adobe.cq.social.scf.OperationException;
import com.adobe.cq.social.scf.OperationExtension;
import com.adobe.cq.social.scf.SocialComponent;
import com.adobe.cq.social.scf.SocialComponentFactory;
import com.adobe.cq.social.scf.SocialComponentFactoryManager;
import com.adobe.cq.social.ugcbase.core.SocialResourceUtils;
import com.day.cq.wcm.api.designer.Designer;
import com.day.cq.wcm.api.designer.Style;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;

@Component(metatype=false, componentAbstract=true)
public abstract class AbstractForumOperationsService<T extends OperationExtension, U extends Operation, S extends Post>
extends AbstractCommentOperationService<T, U, S> {
    @Override
    protected boolean mayReply(Resource root, CommentSystem cs) throws OperationException {
        ResourceResolver resolver;
        boolean retVal = false;
        if (root != null && !(retVal = (resolver = root.getResourceResolver()).isResourceType(root, "social/forum/components/hbs/topic")) && resolver.isResourceType(root, "social/forum/components/hbs/post")) {
            retVal = cs.allowsReplies();
        }
        return retVal;
    }

    @Override
    protected boolean mayPost(SlingHttpServletRequest request, CommentSystem cs, String userId) {
        boolean retVal = super.mayPost(request, cs, userId);
        boolean isClosed = cs.getProperty("closed", false);
        boolean bl = retVal = retVal && !isClosed;
        if (cs.getResource().getPath().equals(request.getResource().getPath())) {
            retVal = retVal && this.isUserPrivileged(cs, this.getRequestSession(request), userId);
        }
        return retVal;
    }

    @Override
    protected void getDefaultProperties(SlingHttpServletRequest request, Map<String, Object> props, Session session) throws RepositoryException, OperationException {
        super.getDefaultProperties(request, props, session);
        String subject = request.getParameter("subject");
        if (!StringUtils.isBlank((String)subject)) {
            props.put("jcr:title", subject);
        }
    }

    @Override
    protected String getResourceType(Resource root) {
        if (ResourceUtil.isA(root, "social/forum/components/hbs/forum")) {
            return this.getForumTopicResourceType(root);
        }
        Comment comment = root.adaptTo(Comment.class);
        CommentSystem cs = comment.getCommentSystem();
        return this.getForumPostResourceType(cs.getResource());
    }

    private String getForumPostResourceType(Resource root) {
        Style currentStyle;
        String postResourceType = this.getForumPostResourceType();
        Designer forumDesign = root.getResourceResolver().adaptTo(Designer.class);
        ValueMap forumProperties = root.adaptTo(ValueMap.class);
        if (null != forumDesign && null != (currentStyle = forumDesign.getStyle(root)) && StringUtils.equals((String)((String)currentStyle.get("sling:resourceType")), (String)((String)((Object)forumProperties.get("sling:resourceType", String.class))))) {
            postResourceType = currentStyle != null ? currentStyle.get(this.getPostDesignResourceType(), postResourceType) : postResourceType;
        }
        return postResourceType;
    }

    protected String getForumPostResourceType() {
        return "social/forum/components/hbs/post";
    }

    private String getForumTopicResourceType(Resource resource) {
        Style currentStyle;
        String topicResourceType = this.getForumTopicResourceType();
        Designer forumDesign = resource.getResourceResolver().adaptTo(Designer.class);
        if (null != forumDesign && null != (currentStyle = forumDesign.getStyle(resource)) && StringUtils.equals((String)((String)currentStyle.get("sling:resourceType")), (String)resource.getResourceType())) {
            topicResourceType = currentStyle != null ? currentStyle.get(this.getTopicDesignResourceType(), topicResourceType) : topicResourceType;
        }
        return topicResourceType;
    }

    protected String getForumTopicResourceType() {
        return "social/forum/components/hbs/topic";
    }

    @Override
    protected void validateParameters(SlingHttpServletRequest request) throws OperationException {
        String message;
        super.validateParameters(request);
        if (request.getResource().isResourceType("social/forum/components/hbs/forum") && ((message = request.getParameter("subject")) == null || "".equals(message))) {
            throw new OperationException("Topic Subject may not be empty", 400);
        }
    }

    @Override
    protected String getEntityUrl(Resource resource) {
        Post post;
        SocialComponent sc;
        SocialComponentFactory scf = this.getSocialComponentFactoryManager().getSocialComponentFactory(resource);
        if (scf != null && SocialResourceUtils.isSocialResource(resource) && (sc = scf.getSocialComponent(resource)) != null && (post = (Post)sc) != null) {
            return post.getFriendlyUrl();
        }
        return super.getEntityUrl(resource);
    }

    @Override
    protected abstract S getSocialComponentForResource(Resource var1);

    public abstract String getTopicDesignResourceType();

    public abstract String getPostDesignResourceType();

    public abstract SocialComponentFactoryManager getSocialComponentFactoryManager();
}

