/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.graph.client.api;

import com.adobe.cq.social.graph.Edge;
import com.adobe.cq.social.graph.SocialGraph;
import com.adobe.cq.social.graph.Vertex;
import com.adobe.cq.social.graph.client.api.MutableFollowing;
import com.adobe.cq.social.scf.ClientUtilities;
import com.adobe.cq.social.scf.QueryRequestInfo;
import com.adobe.cq.social.scf.SocialComponent;
import com.adobe.cq.social.scf.SocialComponentFactory;
import com.adobe.cq.social.scf.SocialComponentFactoryManager;
import com.adobe.cq.social.scf.User;
import com.adobe.cq.social.scf.core.BaseSocialComponent;
import com.adobe.granite.socialgraph.Direction;
import org.apache.commons.lang.StringUtils;
import org.apache.jackrabbit.util.Text;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractFollowing
extends BaseSocialComponent
implements MutableFollowing {
    private final ResourceResolver resolver;
    private final SocialGraph graph;
    private String userId;
    private String otherId;
    private boolean isFollowed;
    private final Edge edge;
    private final Vertex vertex;
    private final Vertex otherVertex;
    private final boolean isFollowedUser;
    private final boolean mayFollow;
    private static final Logger LOG = LoggerFactory.getLogger(AbstractFollowing.class);

    public AbstractFollowing(Resource resource, ClientUtilities clientUtils, QueryRequestInfo q) {
        super(resource, clientUtils);
        SlingHttpServletRequest request = clientUtils.getRequest();
        if (request != null) {
            this.userId = clientUtils.getUserId(request.getParameter("userId"));
            this.otherId = clientUtils.getUserId(request.getParameter("followedId"));
        }
        ValueMap properties = null;
        if (StringUtils.isBlank((String)this.userId)) {
            properties = resource.getValueMap();
            String value = properties.get("userId", "");
            this.userId = StringUtils.isNotEmpty((String)value) ? value : resource.getResourceResolver().getUserID();
        }
        if (StringUtils.isBlank((String)this.otherId)) {
            if (properties == null) {
                properties = resource.getValueMap();
            }
            this.otherId = properties.get("followedId", "");
            if (StringUtils.isBlank((String)this.otherId)) {
                String resourceId = resource.getPath();
                this.otherId = resourceId.startsWith("/social/authors/") ? clientUtils.getUserId(resourceId) : Text.getRelativeParent(resourceId, 1);
            }
        }
        if (StringUtils.isBlank((String)this.userId)) {
            throw new IllegalArgumentException("Invalid value of userId.");
        }
        if (StringUtils.isBlank((String)this.otherId)) {
            throw new IllegalArgumentException("Invalid value of followedId.");
        }
        this.resolver = resource.getResourceResolver();
        this.mayFollow = !this.userId.equals(this.otherId);
        this.graph = this.resolver.adaptTo(SocialGraph.class);
        this.vertex = this.graph.getVertex(this.userId);
        this.otherVertex = this.graph.getVertex(this.otherId);
        this.edge = (Edge)this.vertex.getRelationship(Direction.OUTGOING, this.otherVertex, this.getRelationshipType());
        this.isFollowed = this.edge != null;
        this.isFollowedUser = this.otherId.startsWith("/social/authors/") || !this.otherId.startsWith("/");
    }

    @Override
    public User getUser() {
        return this.clientUtils.getUser(this.userId, this.resolver);
    }

    @Override
    public boolean getIsFollowed() {
        return this.isFollowed;
    }

    @Override
    public SocialGraph socialGraph() {
        return this.graph;
    }

    @Override
    public Edge edge() {
        return this.edge;
    }

    @Override
    public Vertex userNode() {
        return this.vertex;
    }

    @Override
    public Vertex followedNode() {
        return this.otherVertex;
    }

    @Override
    public boolean getIsFollowedUser() {
        return this.isFollowedUser;
    }

    protected String getRelationshipType() {
        return "following";
    }

    private SocialComponent createFollowedSocialComponent(String id) {
        Resource resource;
        SocialComponentFactory scf;
        if (this.isFollowedUser) {
            return this.clientUtils.getUser(id, this.resolver);
        }
        SocialComponentFactoryManager scfMgr = this.clientUtils.getSocialComponentFactoryManager();
        if (scfMgr != null && (scf = scfMgr.getSocialComponentFactory(resource = this.resolver.getResource(id))) != null) {
            try {
                return scf.getSocialComponent(resource, this.clientUtils, QueryRequestInfo.DEFAULT_QUERY_INFO_FACTORY.create());
            }
            catch (Throwable e) {
                LOG.error("Failed to retrieve social component.", e);
            }
        }
        return null;
    }

    @Override
    public boolean getMayFollow() {
        return this.mayFollow;
    }

    @Override
    public void setFollowingState(boolean newState) {
        this.isFollowed = newState;
    }

    @Override
    public String getFollowedId() {
        return this.otherId;
    }

    @Override
    public String getFollowedResourceType() {
        return this.isFollowedUser ? "social/commons/components/author" : (String)((Object)this.otherVertex.get("sling:resourceType", String.class));
    }
}

