/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.group.api;

import com.adobe.cq.social.community.api.CommunityContext;
import com.adobe.cq.social.group.client.api.CommunityGroup;
import com.adobe.cq.social.scf.OperationException;
import com.adobe.cq.social.site.api.SiteConfiguration;
import com.adobe.granite.security.user.UserProperties;
import com.adobe.granite.security.user.UserPropertiesManager;
import com.adobe.granite.security.user.UserPropertiesService;
import com.adobe.granite.socialgraph.Direction;
import com.adobe.granite.socialgraph.GraphNode;
import com.adobe.granite.socialgraph.Relationship;
import com.adobe.granite.socialgraph.SocialGraph;
import com.adobe.granite.xss.XSSAPI;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import java.util.ArrayList;
import java.util.List;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.security.Privilege;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Reference;
import org.apache.jackrabbit.api.JackrabbitSession;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupUtil {
    public static final int DEFAULT_MAX_WAIT_TIME = 2000;
    public static final int DEFAULT_WAIT_BETWEEN_RETRIES = 100;
    public static final int WARN_WAIT_TIME = 120000;
    public static final int WARN_RETRY_DELAY = 1000;
    private static final String ANONYMOUS_USER = "anonymous";
    private static final Logger log = LoggerFactory.getLogger(GroupUtil.class);
    @Reference
    private static XSSAPI xssAPI;

    public static boolean canEveryoneCreateGroup(Resource resource) {
        CommunityContext context = resource.adaptTo(CommunityContext.class);
        ResourceResolver resolver = resource.getResourceResolver();
        Resource configure = resolver.getResource(context.getSitePath());
        if (configure == null) {
            return false;
        }
        ValueMap values = configure.adaptTo(ValueMap.class);
        String groupCreationType = (String)((Object)values.get("createGroupPermission", String.class));
        return StringUtils.equalsIgnoreCase((String)groupCreationType, (String)SiteConfiguration.GroupManagementConfiguration.CreatePermission.EVERYONE.name());
    }

    public static boolean validateGroupName(ResourceResolver resolver, String name, String groupRoot) {
        if (name.startsWith("_")) {
            log.info("Group name {} begins with invalid charactor", (Object)name);
            return false;
        }
        PageManager pm = resolver.adaptTo(PageManager.class);
        Page childPage = pm.getPage(groupRoot + "/" + name);
        if (childPage != null) {
            log.info("Page {} already exists in {}", (Object)name, (Object)groupRoot);
            return false;
        }
        CommunityContext site = resolver.getResource(groupRoot).adaptTo(CommunityContext.class);
        String memberGroup = name + "-members";
        if (site != null) {
            memberGroup = site.getTenantUserGroupName(site.getSiteId() + '-' + memberGroup);
        }
        try {
            Session session = resolver.adaptTo(Session.class);
            UserManager um = ((JackrabbitSession)session).getUserManager();
            Authorizable group = um.getAuthorizable(memberGroup);
            if (group != null) {
                log.info("Authorizable {} already exists", (Object)memberGroup);
                return false;
            }
        }
        catch (RepositoryException e) {
            log.error("Failed to validate user group " + memberGroup, (Throwable)e);
            return false;
        }
        return true;
    }

    public static int getNumberOfMembers(UserPropertiesService userPropertiesService, ResourceResolver resourceResolver, String groupId) {
        List<UserProperties> relations = GroupUtil.establishMemberRelation(userPropertiesService, resourceResolver, groupId);
        if (relations != null) {
            return relations.size();
        }
        return 0;
    }

    public static boolean isMember(UserPropertiesService userPropertiesService, ResourceResolver resourceResolver, String authId, String groupId) {
        if (StringUtils.isEmpty((String)authId) || StringUtils.isEmpty((String)groupId)) {
            return false;
        }
        SocialGraph socialGraph = resourceResolver.adaptTo(SocialGraph.class);
        GraphNode group = socialGraph.getNode(groupId);
        GraphNode user = socialGraph.getNode(authId);
        if (group == null || user == null) {
            return false;
        }
        String relation = "member";
        Direction direction = Direction.INCOMING;
        return group.getRelationship(direction, user, "member") != null;
    }

    private static List<UserProperties> establishMemberRelation(UserPropertiesService userPropertiesService, ResourceResolver resourceResolver, String groupId) {
        ArrayList<UserProperties> results = new ArrayList<UserProperties>();
        if (StringUtils.isEmpty((String)groupId)) {
            return results;
        }
        try {
            UserPropertiesManager upm = userPropertiesService.createUserPropertiesManager(resourceResolver);
            SocialGraph socialGraph = resourceResolver.adaptTo(SocialGraph.class);
            GraphNode group = socialGraph.getNode(groupId);
            if (group == null) {
                return results;
            }
            String relation = "member";
            Direction direction = Direction.INCOMING;
            for (Relationship r : group.getRelationships(direction, "member")) {
                String authId = r.getOtherNode(group).getId();
                UserProperties memberProperties = upm.getUserProperties(authId, "profile");
                if (memberProperties == null || memberProperties.getNode().getPath().contains("groups")) continue;
                results.add(memberProperties);
            }
        }
        catch (RepositoryException e) {
            log.error("establishMemberRelation: error while establish relation for [{}]", (Object)groupId);
            log.error("", (Throwable)e);
        }
        return results;
    }

    public static void waitForPageCreation(ResourceResolver resolver, String pagePath, long maxWaitTime, long waitInterval) throws RepositoryException {
        log.debug("Wait for page creation at {}", (Object)pagePath);
        if (resolver == null || StringUtils.isEmpty((String)pagePath)) {
            return;
        }
        if (maxWaitTime <= 0L) {
            log.warn("Invalid maxWaitTime [{}]. Resetting.", (Object)maxWaitTime);
            maxWaitTime = 2000L;
        }
        if (maxWaitTime > 120000L) {
            log.warn("Very large number of retries configured [{}]. This may cause thread contention.", (Object)maxWaitTime);
        }
        if (waitInterval <= 0L) {
            log.warn("Invalid wait interval [{}]. Resetting.", (Object)waitInterval);
            waitInterval = 100L;
        }
        if (waitInterval > 1000L) {
            log.warn("Very large wait interval configured [{}]. This may cause thread contention.", (Object)waitInterval);
        }
        long start = System.currentTimeMillis();
        boolean wait = false;
        do {
            Resource res;
            if ((res = resolver.resolve(pagePath + "/" + "jcr:content")) != null && !ResourceUtil.isNonExistingResource(res)) {
                if (wait) {
                    log.debug("Page content successfully created at {} after waiting for {} milliseconds", (Object)pagePath, (Object)(System.currentTimeMillis() - start));
                } else {
                    log.debug("Page content successfully created at {} already", (Object)pagePath);
                }
                return;
            }
            wait = true;
            try {
                Thread.sleep(waitInterval);
            }
            catch (InterruptedException ignore) {
                // empty catch block
            }
            resolver.adaptTo(Session.class).refresh(true);
            resolver.refresh();
        } while (System.currentTimeMillis() - start < maxWaitTime);
        log.debug("Page content failed to be created at {} ", (Object)pagePath);
    }

    public static Object toObject(String value, Class clazz) {
        if (Boolean.class == clazz || Boolean.TYPE == clazz) {
            return Boolean.valueOf(value);
        }
        if (Byte.class == clazz || Byte.TYPE == clazz) {
            try {
                return Long.valueOf(value).byteValue();
            }
            catch (NumberFormatException e) {
                return Double.valueOf(value).byteValue();
            }
        }
        if (Short.class == clazz || Short.TYPE == clazz) {
            try {
                return Long.valueOf(value).shortValue();
            }
            catch (NumberFormatException e) {
                return Double.valueOf(value).shortValue();
            }
        }
        if (Integer.class == clazz || Integer.TYPE == clazz) {
            try {
                return Long.valueOf(value).intValue();
            }
            catch (NumberFormatException e) {
                return Double.valueOf(value).intValue();
            }
        }
        if (Long.class == clazz || Long.TYPE == clazz) {
            try {
                return (long)Long.valueOf(value);
            }
            catch (NumberFormatException e) {
                return Double.valueOf(value).longValue();
            }
        }
        if (Float.class == clazz || Float.TYPE == clazz) {
            try {
                return Float.valueOf(Double.valueOf(value).floatValue());
            }
            catch (NumberFormatException e) {
                return Float.valueOf(Long.valueOf(value).floatValue());
            }
        }
        if (Double.class == clazz || Double.TYPE == clazz) {
            try {
                return (double)Double.valueOf(value);
            }
            catch (NumberFormatException e) {
                return Long.valueOf(value).doubleValue();
            }
        }
        return value;
    }

    public static boolean isMember(UserManager um, String groupId, String userId) throws RepositoryException {
        if (StringUtils.isNotEmpty((String)groupId) && StringUtils.isNotEmpty((String)userId)) {
            Authorizable user = um.getAuthorizable(userId);
            Authorizable group = um.getAuthorizable(groupId);
            if (group instanceof Group && user != null) {
                return ((Group)group).isMember(user);
            }
        }
        return false;
    }

    public static boolean isGroupAdmin(Session session, Resource resource) throws OperationException {
        CommunityContext context;
        if (resource == null || session == null) {
            return false;
        }
        ResourceResolver resolver = resource.getResourceResolver();
        Resource configure = resolver.getResource((context = resource.adaptTo(CommunityContext.class)).getSitePath());
        if (configure == null) {
            return false;
        }
        ValueMap values = configure.adaptTo(ValueMap.class);
        String groupCreationType = (String)((Object)values.get("createGroupPermission", String.class));
        if (StringUtils.equalsIgnoreCase((String)groupCreationType, (String)SiteConfiguration.GroupManagementConfiguration.CreatePermission.EVERYONE.name())) {
            return !ANONYMOUS_USER.equals(session.getUserID());
        }
        try {
            Privilege[] userPrivs = session.getAccessControlManager().getPrivileges(resource.getPath());
            return userPrivs.length == 1 && "jcr:all".equalsIgnoreCase(userPrivs[0].getName());
        }
        catch (RepositoryException e) {
            log.error("Error Check If User Is Group Admin " + session.getUserID(), (Throwable)e);
            return false;
        }
    }

    public static boolean canInviteGroupMember(ResourceResolver resolver, CommunityContext context) {
        Session session = resolver.adaptTo(Session.class);
        if (context == null) {
            return false;
        }
        String groupPath = context.getCommunityGroupPath();
        if (StringUtils.isEmpty((String)groupPath)) {
            return false;
        }
        Resource groupRes = resolver.resolve(groupPath);
        Resource groupConfig = groupRes.getChild("configuration");
        if (groupConfig == null) {
            return false;
        }
        ValueMap values = groupConfig.adaptTo(ValueMap.class);
        if (values == null) {
            return false;
        }
        String type = (String)((Object)values.get("type", String.class));
        String owner = (String)((Object)values.get("owner", String.class));
        if (!"Secret".equals(type)) {
            return false;
        }
        Resource siteConfigure = resolver.getResource(context.getSitePath());
        if (siteConfigure == null) {
            return false;
        }
        ValueMap siteValues = siteConfigure.adaptTo(ValueMap.class);
        String groupCreationType = (String)((Object)siteValues.get("createGroupPermission", String.class));
        if (StringUtils.equalsIgnoreCase((String)groupCreationType, (String)SiteConfiguration.GroupManagementConfiguration.CreatePermission.EVERYONE.name()) && session.getUserID().equals(owner)) {
            return true;
        }
        try {
            Privilege[] userPrivs = session.getAccessControlManager().getPrivileges(groupRes.getPath());
            return userPrivs.length == 1 && "jcr:all".equalsIgnoreCase(userPrivs[0].getName());
        }
        catch (RepositoryException e) {
            log.error("Error Check If User Is Group Admin " + session.getUserID(), (Throwable)e);
            return false;
        }
    }

    public static boolean canLeaveGroup(ResourceResolver resolver, CommunityContext context) {
        Session session = resolver.adaptTo(Session.class);
        if (context == null) {
            return false;
        }
        String groupPath = context.getCommunityGroupPath();
        if (StringUtils.isEmpty((String)groupPath)) {
            return false;
        }
        Resource groupRes = resolver.resolve(groupPath);
        Resource groupConfig = groupRes.getChild("configuration");
        if (groupConfig == null) {
            return false;
        }
        ValueMap values = groupConfig.adaptTo(ValueMap.class);
        if (values == null) {
            return false;
        }
        String owner = (String)((Object)values.get("owner", String.class));
        Resource siteConfigure = resolver.getResource(context.getSitePath());
        if (siteConfigure == null) {
            return false;
        }
        ValueMap siteValues = siteConfigure.adaptTo(ValueMap.class);
        String groupCreationType = (String)((Object)siteValues.get("createGroupPermission", String.class));
        if (StringUtils.equalsIgnoreCase((String)groupCreationType, (String)SiteConfiguration.GroupManagementConfiguration.CreatePermission.EVERYONE.name()) && session.getUserID().equals(owner)) {
            return true;
        }
        try {
            Privilege[] userPrivs = session.getAccessControlManager().getPrivileges(groupRes.getPath());
            return userPrivs.length == 1 && "jcr:all".equalsIgnoreCase(userPrivs[0].getName());
        }
        catch (RepositoryException e) {
            log.error("Error Check If User Is Group Admin " + session.getUserID(), (Throwable)e);
            return false;
        }
    }

    public static boolean canPromoteGroupMember(ResourceResolver resolver, CommunityContext context) {
        Session session = resolver.adaptTo(Session.class);
        if (context == null) {
            return false;
        }
        String groupPath = context.getCommunityGroupPath();
        if (StringUtils.isEmpty((String)groupPath)) {
            return false;
        }
        Resource groupRes = resolver.resolve(groupPath);
        Resource groupConfig = groupRes.getChild("configuration");
        if (groupConfig == null) {
            return false;
        }
        ValueMap values = groupConfig.adaptTo(ValueMap.class);
        if (values == null) {
            return false;
        }
        String type = (String)((Object)values.get("type", String.class));
        if (!"Secret".equals(type)) {
            return false;
        }
        Resource siteConfigure = resolver.getResource(context.getSitePath());
        if (siteConfigure == null) {
            return false;
        }
        ValueMap siteValues = siteConfigure.adaptTo(ValueMap.class);
        String groupCreationType = (String)((Object)siteValues.get("createGroupPermission", String.class));
        if (StringUtils.equalsIgnoreCase((String)groupCreationType, (String)SiteConfiguration.GroupManagementConfiguration.CreatePermission.EVERYONE.name())) {
            return false;
        }
        try {
            Privilege[] userPrivs = session.getAccessControlManager().getPrivileges(groupRes.getPath());
            return userPrivs.length == 1 && "jcr:all".equalsIgnoreCase(userPrivs[0].getName());
        }
        catch (RepositoryException e) {
            log.error("Error Check If User Is Group Admin " + session.getUserID(), (Throwable)e);
            return false;
        }
    }

    public static boolean canAccessCommunityGroup(ResourceResolver resolver, CommunityGroup group) {
        if ("Open".equalsIgnoreCase(group.getType())) {
            return true;
        }
        String membergroup = group.getMemberGroupId();
        String currentUser = resolver.adaptTo(Session.class).getUserID();
        return GroupUtil.isMember(null, resolver, currentUser, membergroup);
    }
}

