/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.group.client.api;

import com.adobe.cq.social.SocialException;
import com.adobe.cq.social.blueprint.api.SiteActivationService;
import com.adobe.cq.social.blueprint.api.TemplateRolloutService;
import com.adobe.cq.social.group.api.GroupException;
import com.adobe.cq.social.group.client.api.CommunityGroupService;
import com.adobe.cq.social.scf.OperationException;
import com.adobe.cq.social.scf.SocialComponentFactoryManager;
import com.adobe.cq.social.serviceusers.internal.ServiceUserWrapper;
import com.day.cq.commons.jcr.JcrUtil;
import com.day.cq.replication.ReplicationException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.jcr.Binary;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.observation.Event;
import javax.jcr.observation.EventIterator;
import javax.jcr.observation.EventListener;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.jcr.api.SlingRepository;
import org.apache.sling.settings.SlingSettingsService;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.detect.Detector;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service
@Component(immediate=true, metatype=false)
@Properties(value={@Property(name="service.description", value={"CommunityGroup Author Event Listener"})})
public class CommunityGroupAuthorEventListener
implements EventListener {
    private static final String MSM_SERVICE = "msm-service";
    private static final String USER_ADMIN = "user-admin";
    private static final Logger LOG = LoggerFactory.getLogger(CommunityGroupAuthorEventListener.class);
    private Session userAdminSession;
    private ResourceResolver userAdminResolver;
    @Reference
    private TemplateRolloutService templateRolloutService;
    @Reference
    private CommunityGroupService communityGroupService;
    @Reference
    private SiteActivationService siteActivateService;
    @Reference
    private ResourceResolverFactory resourceResolverFactory;
    @Reference
    private SlingRepository repository;
    @Reference
    private SlingSettingsService settingsService;
    @Reference
    private SocialComponentFactoryManager componentFactoryManager;
    @Reference
    private ServiceUserWrapper serviceUserWrapper;
    private static final String[] LISTEN_TO_NODE_TYPE = new String[]{"oak:Unstructured", "sling:Folder"};
    private static final String LISTEN_TO_NODE_PROPERTY = "path";
    private static final String[] LISTEN_TO_ROOT_PATH_AUTHOR = new String[]{"/var/tenants", "/var/community/create"};
    private static final List<String> LISTEN_TO_NODE_NAME = Arrays.asList("created");
    private static final String EXCLUDE_NODE_NAME = "image";

    @Activate
    public void activate(ComponentContext context) throws SocialException, OperationException {
        LOG.info("activating CommunityGroupAuthorEventListener");
        if (!this.isPublishMode()) {
            try {
                this.userAdminSession = this.serviceUserWrapper.loginService(this.repository, USER_ADMIN);
                HashMap<String, Object> authInfo = new HashMap<String, Object>();
                authInfo.put("user.jcr.session", this.userAdminSession);
                this.userAdminResolver = this.resourceResolverFactory.getResourceResolver(authInfo);
                this.userAdminSession.getWorkspace().getObservationManager().addEventListener((EventListener)this, 1, LISTEN_TO_ROOT_PATH_AUTHOR[0], true, null, LISTEN_TO_NODE_TYPE, true);
                this.userAdminSession.getWorkspace().getObservationManager().addEventListener((EventListener)this, 1, LISTEN_TO_ROOT_PATH_AUTHOR[1], true, null, LISTEN_TO_NODE_TYPE, true);
            }
            catch (LoginException e) {
                throw new OperationException("Cannot login", e, 403);
            }
            catch (RepositoryException e) {
                throw new SocialException("unable to register session", e);
            }
        }
    }

    @Deactivate
    public void deactivate() {
        if (this.userAdminResolver != null) {
            this.userAdminResolver.close();
        }
        if (this.userAdminSession != null && this.userAdminSession.isLive()) {
            this.userAdminSession.logout();
        }
    }

    private boolean isPublishMode() {
        return this.settingsService != null && this.settingsService.getRunModes().contains("publish");
    }

    public void onEvent(EventIterator eventIterator) {
        while (eventIterator.hasNext()) {
            try {
                this.processEvent(eventIterator.nextEvent());
            }
            catch (RepositoryException e) {
                LOG.error("Error while treating events", (Throwable)e);
            }
            catch (OperationException e) {
                LOG.error("Error while treating events", (Throwable)e);
            }
            catch (SocialException e) {
                LOG.error("Error while treating events", (Throwable)e);
            }
            catch (PersistenceException e) {
                LOG.error("Error while treating events", (Throwable)e);
            }
        }
    }

    protected void processEvent(Event event) throws SocialException, RepositoryException, OperationException, PersistenceException {
        ValueMap properties;
        LOG.info("process site publish event at : {}", (Object)event.getPath());
        String payload = event.getPath();
        if (StringUtils.endsWith((String)payload, (String)EXCLUDE_NODE_NAME)) {
            return;
        }
        Resource resource = this.userAdminResolver.getResource(payload);
        if (resource == null) {
            throw new SocialException("unable to find event payload " + payload);
        }
        String path = (String)((Object)resource.adaptTo(ValueMap.class).get(LISTEN_TO_NODE_PROPERTY, String.class));
        if (LISTEN_TO_NODE_NAME.contains(resource.getName()) && resource.getResourceType().equals(LISTEN_TO_NODE_TYPE[0]) && (payload.startsWith(LISTEN_TO_ROOT_PATH_AUTHOR[0]) && payload.contains("/create") || payload.startsWith(LISTEN_TO_ROOT_PATH_AUTHOR[1])) && "Create Community Group".equals((properties = resource.adaptTo(ValueMap.class)).get("action"))) {
            this.createCommunityGroup(path, properties);
            this.userAdminResolver.delete(resource.getParent());
            this.userAdminSession.save();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void createCommunityGroup(String groupsRoot, ValueMap properties) throws SocialException, RepositoryException, OperationException {
        if (StringUtils.isEmpty((String)groupsRoot)) {
            throw new SocialException("Node property path is missing. ");
        }
        if (this.communityGroupService == null) {
            throw new SocialException("Failed to get CommunityGroupService.");
        }
        if (this.siteActivateService == null) {
            throw new SocialException("Failed to get GroupService.");
        }
        ResourceResolver msmResolver = null;
        ResourceResolver userAdminResolver = null;
        try {
            msmResolver = this.serviceUserWrapper.getServiceResourceResolver(this.resourceResolverFactory, Collections.singletonMap("sling.service.subservice", MSM_SERVICE));
            Session session = msmResolver.adaptTo(Session.class);
            String liveCopyName = (String)((Object)properties.get("urlName", String.class));
            String liveCopyTitle = properties.get("name", liveCopyName);
            String bluePrintPath = (String)((Object)properties.get("blueprint", String.class));
            try {
                String pagePath = this.templateRolloutService.rolloutBlueprint(session, bluePrintPath, liveCopyName, liveCopyTitle, groupsRoot);
                Resource groupPage = msmResolver.getResource(pagePath);
                userAdminResolver = this.serviceUserWrapper.getServiceResourceResolver(this.resourceResolverFactory, Collections.singletonMap("sling.service.subservice", USER_ADMIN));
                Resource image = userAdminResolver.getResource(properties.get("formPayload") + "/" + EXCLUDE_NODE_NAME);
                if (image != null) {
                    Node imageNode = image.adaptTo(Node.class);
                    String mimeType = this.getResourceMIMEType(image);
                    if (StringUtils.startsWithIgnoreCase((String)mimeType, (String)EXCLUDE_NODE_NAME)) {
                        Node imageCopy = JcrUtil.createPath(pagePath + "/" + "photos", "sling:Folder", userAdminResolver.adaptTo(Session.class));
                        JcrUtil.copy(imageNode, imageCopy, EXCLUDE_NODE_NAME);
                        try {
                            userAdminResolver.commit();
                        }
                        catch (PersistenceException e) {
                            throw new SocialException("Failed creating a community group", e);
                        }
                    } else {
                        LOG.error("upload invalid image type {}", (Object)mimeType);
                    }
                }
                this.communityGroupService.setCommunityGroupConfigure(msmResolver, pagePath, properties);
                this.communityGroupService.prepareUserGroups(userAdminResolver, groupPage, groupsRoot, properties);
                this.siteActivateService.activateCommunity(userAdminResolver, msmResolver, pagePath);
                return;
            }
            catch (GroupException e) {
                throw new SocialException("Failed to create community group " + liveCopyName + " at " + groupsRoot, e);
            }
            catch (ReplicationException e) {
                throw new SocialException("Failed to replicate community group " + liveCopyName + " at " + groupsRoot, e);
            }
        }
        catch (LoginException e) {
            throw new SocialException("Failed creating a community gropup", e);
        }
        finally {
            if (msmResolver != null) {
                try {
                    msmResolver.commit();
                }
                catch (PersistenceException e) {
                    throw new SocialException("Failed creating a community group", e);
                }
                finally {
                    msmResolver.close();
                }
            }
            if (userAdminResolver != null) {
                userAdminResolver.close();
            }
        }
    }

    private String getResourceMIMEType(Resource res) throws RepositoryException {
        Node node = res.adaptTo(Node.class);
        Node ntResourceNode = node.getNode("jcr:content");
        try {
            Binary bin = ntResourceNode.getProperty("jcr:data").getBinary();
            TikaConfig config = TikaConfig.getDefaultConfig();
            Detector detector = config.getDetector();
            TikaInputStream stream = TikaInputStream.get((InputStream)bin.getStream());
            Metadata metadata = new Metadata();
            metadata.add("resourceName", EXCLUDE_NODE_NAME);
            MediaType mediaType = detector.detect((InputStream)stream, metadata);
            return mediaType.getType();
        }
        catch (PathNotFoundException el) {
            return null;
        }
        catch (IOException e) {
            return ntResourceNode.getProperty("jcr:mimeType").getString();
        }
    }

    protected void bindTemplateRolloutService(TemplateRolloutService templateRolloutService) {
        this.templateRolloutService = templateRolloutService;
    }

    protected void unbindTemplateRolloutService(TemplateRolloutService templateRolloutService) {
        if (this.templateRolloutService == templateRolloutService) {
            this.templateRolloutService = null;
        }
    }

    protected void bindCommunityGroupService(CommunityGroupService communityGroupService) {
        this.communityGroupService = communityGroupService;
    }

    protected void unbindCommunityGroupService(CommunityGroupService communityGroupService) {
        if (this.communityGroupService == communityGroupService) {
            this.communityGroupService = null;
        }
    }

    protected void bindSiteActivateService(SiteActivationService siteActivationService) {
        this.siteActivateService = siteActivationService;
    }

    protected void unbindSiteActivateService(SiteActivationService siteActivationService) {
        if (this.siteActivateService == siteActivationService) {
            this.siteActivateService = null;
        }
    }

    protected void bindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resourceResolverFactory = resourceResolverFactory;
    }

    protected void unbindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resourceResolverFactory == resourceResolverFactory) {
            this.resourceResolverFactory = null;
        }
    }

    protected void bindRepository(SlingRepository slingRepository) {
        this.repository = slingRepository;
    }

    protected void unbindRepository(SlingRepository slingRepository) {
        if (this.repository == slingRepository) {
            this.repository = null;
        }
    }

    protected void bindSettingsService(SlingSettingsService slingSettingsService) {
        this.settingsService = slingSettingsService;
    }

    protected void unbindSettingsService(SlingSettingsService slingSettingsService) {
        if (this.settingsService == slingSettingsService) {
            this.settingsService = null;
        }
    }

    protected void bindComponentFactoryManager(SocialComponentFactoryManager socialComponentFactoryManager) {
        this.componentFactoryManager = socialComponentFactoryManager;
    }

    protected void unbindComponentFactoryManager(SocialComponentFactoryManager socialComponentFactoryManager) {
        if (this.componentFactoryManager == socialComponentFactoryManager) {
            this.componentFactoryManager = null;
        }
    }

    protected void bindServiceUserWrapper(ServiceUserWrapper serviceUserWrapper) {
        this.serviceUserWrapper = serviceUserWrapper;
    }

    protected void unbindServiceUserWrapper(ServiceUserWrapper serviceUserWrapper) {
        if (this.serviceUserWrapper == serviceUserWrapper) {
            this.serviceUserWrapper = null;
        }
    }
}

