/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.group.client.api;

import com.adobe.cq.social.SocialException;
import com.adobe.cq.social.group.api.GroupException;
import com.adobe.cq.social.group.client.api.CommunityGroupService;
import com.adobe.cq.social.scf.OperationException;
import com.adobe.cq.social.scf.SocialComponentFactoryManager;
import com.adobe.cq.social.serviceusers.internal.ServiceUserWrapper;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.observation.Event;
import javax.jcr.observation.EventIterator;
import javax.jcr.observation.EventListener;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.jcr.api.SlingRepository;
import org.apache.sling.settings.SlingSettingsService;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service
@Component(immediate=true, metatype=false)
@Properties(value={@Property(name="service.description", value={"CommunityGroup Publish Event Listener"})})
public class CommunityGroupPublishEventListener
implements EventListener {
    private static final String MSM_SERVICE = "msm-service";
    private static final String USER_ADMIN = "user-admin";
    private static final String TYPE_OAK_UNSTRUCTURED = "oak:Unstructured";
    private static final String SLING_RESOURCETYPE = "sling:resourceType";
    private static final String SUBSCRIPTIONS_NODE_NAME = "subscriptions";
    private static final String SUBSCRIPTIONS_RESOURCE_TYPE = "social/subscriptions/components/hbs/subscriptions";
    private static final Logger LOG = LoggerFactory.getLogger(CommunityGroupPublishEventListener.class);
    private Session userAdminSession;
    private ResourceResolver userAdminResolver;
    @Reference
    private CommunityGroupService communityGroupService;
    @Reference
    private ResourceResolverFactory resourceResolverFactory;
    @Reference
    private SlingRepository repository;
    @Reference
    private SlingSettingsService settingsService;
    @Reference
    private SocialComponentFactoryManager componentFactoryManager;
    @Reference
    private ServiceUserWrapper serviceUserWrapper;
    private static final String[] LISTEN_TO_NODE_TYPE = new String[]{"oak:Unstructured"};
    private static final String LISTEN_TO_NODE_PROPERTY = "path";
    private static final String[] LISTEN_TO_ROOT_PATH_PUBLISH = new String[]{"/var/tenants", "/var/community/publish"};
    private static final List<String> LISTEN_TO_NODE_NAME = Arrays.asList("created");
    private final String delimiters = "[\\s,;]+";

    @Activate
    public void activate(ComponentContext context) throws SocialException, OperationException {
        LOG.info("activating CommunityGroupPublishEventListener");
        if (this.isPublishMode()) {
            try {
                this.userAdminSession = this.serviceUserWrapper.loginService(this.repository, USER_ADMIN);
                HashMap<String, Object> authInfo = new HashMap<String, Object>();
                authInfo.put("user.jcr.session", this.userAdminSession);
                this.userAdminResolver = this.resourceResolverFactory.getResourceResolver(authInfo);
                this.userAdminSession.getWorkspace().getObservationManager().addEventListener((EventListener)this, 1, LISTEN_TO_ROOT_PATH_PUBLISH[0], true, null, LISTEN_TO_NODE_TYPE, true);
                this.userAdminSession.getWorkspace().getObservationManager().addEventListener((EventListener)this, 1, LISTEN_TO_ROOT_PATH_PUBLISH[1], true, null, LISTEN_TO_NODE_TYPE, true);
            }
            catch (LoginException e) {
                throw new OperationException("Cannot login", e, 403);
            }
            catch (RepositoryException e) {
                throw new SocialException("unable to register session", e);
            }
        }
    }

    @Deactivate
    public void deactivate() {
        if (this.userAdminResolver != null) {
            this.userAdminResolver.close();
        }
        if (this.userAdminSession != null) {
            this.userAdminSession.logout();
        }
    }

    private boolean isPublishMode() {
        return this.settingsService != null && this.settingsService.getRunModes().contains("publish");
    }

    public void onEvent(EventIterator eventIterator) {
        while (eventIterator.hasNext()) {
            try {
                this.processEvent(eventIterator.nextEvent());
            }
            catch (RepositoryException e) {
                LOG.error("Error while treating events", (Throwable)e);
            }
            catch (OperationException e) {
                LOG.error("Error while treating events", (Throwable)e);
            }
            catch (SocialException e) {
                LOG.error("Error while treating events", (Throwable)e);
            }
            catch (PersistenceException e) {
                LOG.error("Error while treating events", (Throwable)e);
            }
        }
    }

    protected void processEvent(Event event) throws SocialException, RepositoryException, OperationException, PersistenceException {
        ValueMap properties;
        LOG.info("process site publish event at : {}", (Object)event.getPath());
        String payload = event.getPath();
        Resource resource = this.userAdminResolver.getResource(payload);
        if (resource == null) {
            throw new SocialException("unable to find event payload " + payload);
        }
        if (LISTEN_TO_NODE_NAME.contains(resource.getName()) && resource.getResourceType().equals(LISTEN_TO_NODE_TYPE[0]) && (payload.startsWith(LISTEN_TO_ROOT_PATH_PUBLISH[0]) && payload.contains("/publish") || payload.startsWith(LISTEN_TO_ROOT_PATH_PUBLISH[1])) && "Publish Community Group".equals((properties = resource.adaptTo(ValueMap.class)).get("action"))) {
            String path = (String)((Object)resource.adaptTo(ValueMap.class).get(LISTEN_TO_NODE_PROPERTY, String.class));
            this.publishCommunityGroup(path, properties);
            this.userAdminResolver.delete(resource.getParent());
            this.userAdminSession.save();
        }
    }

    private void publishCommunityGroup(String group, ValueMap properties) throws SocialException, RepositoryException, OperationException {
        if (StringUtils.isEmpty((String)group)) {
            throw new SocialException("Node property path is missing. ");
        }
        if (this.communityGroupService == null) {
            throw new SocialException("Failed to get CommunityGroupService.");
        }
        String liveCopyName = (String)((Object)properties.get("urlName", String.class));
        ResourceResolver msmResolver = null;
        try {
            ModifiableValueMap values;
            String payload;
            msmResolver = this.serviceUserWrapper.getServiceResourceResolver(this.resourceResolverFactory, Collections.singletonMap("sling.service.subservice", MSM_SERVICE));
            Resource resource = msmResolver.getResource(group);
            String groupsRoot = resource.getParent().getPath();
            this.communityGroupService.prepareUserGroups(this.userAdminResolver, resource, groupsRoot, properties);
            Node node = resource.adaptTo(Node.class);
            if (node != null) {
                Node subNode = node.addNode(SUBSCRIPTIONS_NODE_NAME, TYPE_OAK_UNSTRUCTURED);
                subNode.setProperty(SLING_RESOURCETYPE, SUBSCRIPTIONS_RESOURCE_TYPE);
            }
            if (!StringUtils.isEmpty((String)(payload = (String)((Object)(values = resource.getChild("configuration").adaptTo(ModifiableValueMap.class)).get("formPayload", String.class))))) {
                Resource formPayload = this.userAdminResolver.getResource(payload);
                if (formPayload != null) {
                    this.userAdminResolver.delete(formPayload);
                }
                values.remove("formPayload");
            }
            this.userAdminResolver.adaptTo(Session.class).save();
            msmResolver.adaptTo(Session.class).save();
        }
        catch (GroupException e) {
            throw new SocialException("Failed to create community group " + liveCopyName + " at " + group, e);
        }
        catch (PersistenceException e) {
            LOG.error("Failed to clean up form payload " + liveCopyName + " at " + group, (Throwable)e);
        }
        catch (LoginException e) {
            throw new SocialException("Failed to acquire service user resolver while preparingcommunity group user groups");
        }
        finally {
            if (msmResolver != null) {
                msmResolver.close();
            }
        }
    }

    protected void bindCommunityGroupService(CommunityGroupService communityGroupService) {
        this.communityGroupService = communityGroupService;
    }

    protected void unbindCommunityGroupService(CommunityGroupService communityGroupService) {
        if (this.communityGroupService == communityGroupService) {
            this.communityGroupService = null;
        }
    }

    protected void bindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resourceResolverFactory = resourceResolverFactory;
    }

    protected void unbindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resourceResolverFactory == resourceResolverFactory) {
            this.resourceResolverFactory = null;
        }
    }

    protected void bindRepository(SlingRepository slingRepository) {
        this.repository = slingRepository;
    }

    protected void unbindRepository(SlingRepository slingRepository) {
        if (this.repository == slingRepository) {
            this.repository = null;
        }
    }

    protected void bindSettingsService(SlingSettingsService slingSettingsService) {
        this.settingsService = slingSettingsService;
    }

    protected void unbindSettingsService(SlingSettingsService slingSettingsService) {
        if (this.settingsService == slingSettingsService) {
            this.settingsService = null;
        }
    }

    protected void bindComponentFactoryManager(SocialComponentFactoryManager socialComponentFactoryManager) {
        this.componentFactoryManager = socialComponentFactoryManager;
    }

    protected void unbindComponentFactoryManager(SocialComponentFactoryManager socialComponentFactoryManager) {
        if (this.componentFactoryManager == socialComponentFactoryManager) {
            this.componentFactoryManager = null;
        }
    }

    protected void bindServiceUserWrapper(ServiceUserWrapper serviceUserWrapper) {
        this.serviceUserWrapper = serviceUserWrapper;
    }

    protected void unbindServiceUserWrapper(ServiceUserWrapper serviceUserWrapper) {
        if (this.serviceUserWrapper == serviceUserWrapper) {
            this.serviceUserWrapper = null;
        }
    }
}

