/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.group.client.api;

import com.adobe.cq.social.badging.api.BadgingService;
import com.adobe.cq.social.group.client.impl.CommunityGroupUserImpl;
import com.adobe.cq.social.scf.ClientUtilities;
import com.adobe.cq.social.scf.QueryRequestInfo;
import com.adobe.cq.social.scf.SocialComponent;
import com.adobe.cq.social.scf.SocialComponentFactory;
import com.adobe.cq.social.scf.core.AbstractSocialComponentFactory;
import com.adobe.cq.social.scoring.api.ScoringService;
import com.adobe.granite.security.user.UserPropertiesManager;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(label="AEM Communities CommunityGroupUserSocialComponentFactory")
@Service
public class CommunityGroupUserSocialComponentFactory
extends AbstractSocialComponentFactory
implements SocialComponentFactory {
    @Reference
    private ScoringService scoring;
    @Reference
    private BadgingService badging;
    private static final Logger LOG = LoggerFactory.getLogger(CommunityGroupUserSocialComponentFactory.class);

    @Override
    public SocialComponent getSocialComponent(Resource resource) {
        return new CommunityGroupUserImpl(resource, this.getClientUtilities(resource.getResourceResolver()), this.getUserPropertiesManager(resource), this.scoring, this.badging);
    }

    @Override
    public SocialComponent getSocialComponent(Resource resource, SlingHttpServletRequest request) {
        return new CommunityGroupUserImpl(resource, this.getClientUtilities(request), this.getUserPropertiesManager(resource), this.scoring, this.badging);
    }

    @Override
    public SocialComponent getSocialComponent(Resource resource, ClientUtilities clientUtils, QueryRequestInfo requestInfo) {
        return new CommunityGroupUserImpl(resource, clientUtils, this.getUserPropertiesManager(resource), this.scoring, this.badging);
    }

    @Override
    public String getSupportedResourceType() {
        return "social/group/components/hbs/communitygroupmember";
    }

    protected UserPropertiesManager getUserPropertiesManager(Resource resource) {
        return resource.getResourceResolver().adaptTo(UserPropertiesManager.class);
    }

    @Deprecated
    protected ScoringService getScoringService() {
        return this.scoring;
    }

    protected void bindScoring(ScoringService scoringService) {
        this.scoring = scoringService;
    }

    protected void unbindScoring(ScoringService scoringService) {
        if (this.scoring == scoringService) {
            this.scoring = null;
        }
    }

    protected void bindBadging(BadgingService badgingService) {
        this.badging = badgingService;
    }

    protected void unbindBadging(BadgingService badgingService) {
        if (this.badging == badgingService) {
            this.badging = null;
        }
    }
}

