/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.group.client.endpoints;

import com.adobe.cq.social.commons.CollabUtil;
import com.adobe.cq.social.community.api.CommunityConstants;
import com.adobe.cq.social.community.api.CommunityContext;
import com.adobe.cq.social.community.api.CommunityUserGroup;
import com.adobe.cq.social.group.api.GroupException;
import com.adobe.cq.social.group.api.GroupService;
import com.adobe.cq.social.group.api.GroupUtil;
import com.adobe.cq.social.group.bundleactivator.impl.Activator;
import com.adobe.cq.social.group.client.api.CommunityGroup;
import com.adobe.cq.social.group.client.endpoints.CommunityGroupOperations;
import com.adobe.cq.social.group.client.endpoints.impl.CommunityGroupOperationService;
import com.adobe.cq.social.scf.Operation;
import com.adobe.cq.social.scf.OperationException;
import com.adobe.cq.social.scf.OperationExtension;
import com.adobe.cq.social.scf.SocialComponent;
import com.adobe.cq.social.scf.SocialComponentFactory;
import com.adobe.cq.social.scf.SocialComponentFactoryManager;
import com.adobe.cq.social.scf.core.operations.AbstractOperationService;
import com.adobe.cq.social.serviceusers.internal.ServiceUserWrapper;
import com.adobe.cq.social.ugcbase.AsyncReverseReplicator;
import com.day.cq.commons.jcr.JcrUtil;
import com.day.cq.replication.ReplicationActionType;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.activation.DataSource;
import javax.jcr.Binary;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.request.RequestParameter;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.jcr.api.SlingRepository;
import org.apache.sling.settings.SlingSettingsService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=false, componentAbstract=true)
public abstract class AbstractCommunityGroupOperationService<T extends OperationExtension, U extends Operation>
extends AbstractOperationService<T, U, CommunityGroup>
implements CommunityGroupOperations {
    private static final String MSM_SERVICE = "msm-service";
    private static final Logger LOG = LoggerFactory.getLogger(CommunityGroupOperationService.class);
    private static final String PROPERTY_IMAGE_NAME = "image";
    private static final int PARAM_NAME_INDEX = 0;
    private static final int PARAM_CLASS_INDEX = 1;
    private static final int PARAM_REQUIRED_INDEX = 2;
    private static final Object[][] requestParams = new Object[][]{{"jcr:description", String.class, Boolean.FALSE}, {"urlName", String.class, Boolean.TRUE}, {"name", String.class, Boolean.FALSE}, {"type", String.class, Boolean.FALSE}, {"invite", String.class, Boolean.FALSE}, {"blueprint", String.class, Boolean.TRUE}};
    private static final String[] specialParams = new String[]{"file"};
    private static final int ATTACHMENT_FILE_LIMIT = Integer.MAX_VALUE;
    private static final List<String> WHITE_LIST = new ArrayList<String>();
    private static final String[] BLACK_LIST = new String[0];
    private static final String USER_ADMIN = "user-admin";
    private static final String DEFAULT_GROUP_ROOTTEMPLATE_ROOT = "/etc/community/templates/groups";
    private static final String DEFAULT_GROUP_TEMPLATE_ROOT = "/etc/community/templates/groups" + CommunityConstants.REFERENCE_SUBPATH;
    private static final String CUSTOM_GROUP_TEMPLATE_ROOT = "/etc/community/templates/groups" + CommunityConstants.CUSTOM_SUBPATH;
    private static final String PATH = "path";
    private static final String NAME = "name";
    private final String delimiters = "[\\s,;]";
    @Reference
    private SocialComponentFactoryManager componentFactoryManager;
    @Reference
    private AsyncReverseReplicator replicator;
    @Reference
    private GroupService groupService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY, policy=ReferencePolicy.STATIC)
    private SlingRepository repository;
    @Reference
    private ServiceUserWrapper serviceUserWrapper;
    @Reference
    private ResourceResolverFactory resourceResolverFactory;
    @Reference
    protected SlingSettingsService settingsService;
    private ResourceResolverFactory bundleLocalResourceResolverFactory;

    private void cleanupFailure(Session session) {
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Failure cleanup invoked.", new Throwable());
            }
            session.refresh(false);
        }
        catch (RepositoryException e) {
            LOG.info("Failed to refresh the session", (Throwable)e);
        }
    }

    private ResourceResolverFactory getBundleLocalResourceResolverFactory() {
        if (this.bundleLocalResourceResolverFactory == null) {
            this.bundleLocalResourceResolverFactory = (ResourceResolverFactory)Activator.getService(ResourceResolverFactory.class);
        }
        return this.bundleLocalResourceResolverFactory;
    }

    private ServiceUserWrapper getServiceUserWrapper() {
        if (this.serviceUserWrapper == null) {
            this.serviceUserWrapper = (ServiceUserWrapper)Activator.getService(ServiceUserWrapper.class);
        }
        return this.serviceUserWrapper;
    }

    @Override
    public Resource create(SlingHttpServletRequest request) throws OperationException {
        Resource resource = request.getResource();
        ResourceResolver resolver = resource.getResourceResolver();
        Session session = resource.getResourceResolver().adaptTo(Session.class);
        if (!GroupUtil.isGroupAdmin(session, resource)) {
            throw new OperationException("No permission to create a community group.", 500);
        }
        HashMap<String, Object> props = new HashMap<String, Object>();
        try {
            this.getDefaultProperties(request, props, true);
            this.getCustomProperties(request, props, session);
        }
        catch (RepositoryException e) {
            throw new OperationException("Failed to obtain community group parameters.", e, 500);
        }
        String invites = (String)props.get("invite");
        invites = !StringUtils.isEmpty((String)invites) ? invites + "," + session.getUserID() : session.getUserID();
        props.put("invite", invites);
        props.put("owner", session.getUserID());
        String name = (String)props.get("urlName");
        PageManager pm = resolver.adaptTo(PageManager.class);
        Page groupPage = pm.getContainingPage(resource);
        String root = groupPage.getPath();
        Resource groupPageResource = resolver.getResource(root);
        if (!GroupUtil.validateGroupName(resolver, name, root)) {
            throw new OperationException("Community group name is badly formatted " + name, 400);
        }
        List<DataSource> attachments = this.getAttachmentsFromRequest(request, "file");
        ResourceResolver userAdminResolver = null;
        try {
            userAdminResolver = this.getServiceUserWrapper().getServiceResourceResolver(this.getBundleLocalResourceResolverFactory(), Collections.singletonMap("sling.service.subservice", USER_ADMIN));
            Resource resource2 = this.create(groupPageResource, name, props, attachments, userAdminResolver.adaptTo(Session.class));
            return resource2;
        }
        catch (LoginException e) {
            this.cleanupFailure(session);
            throw new OperationException("Failed to join community group.", e, 500);
        }
        finally {
            if (userAdminResolver != null) {
                userAdminResolver.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Resource create(Resource root, String name, Map<String, Object> properties, List<DataSource> attachments, Session session) throws OperationException {
        try {
            boolean hasImage;
            HashMap<String, Object> authInfo = new HashMap<String, Object>();
            authInfo.put("user.jcr.session", session);
            ResourceResolver resolver = this.resourceResolverFactory.getResourceResolver(authInfo);
            U createOperation = this.getCreateOperation();
            this.performBeforeActions(createOperation, session, root, properties);
            String groupPath = root.getPath() + "/" + name;
            CommunityContext context = root.adaptTo(CommunityContext.class);
            String nuggetRoot = context != null ? context.getSitePayloadPath() : "/var/community/publish";
            nuggetRoot = StringUtils.replace((String)nuggetRoot, (String)"/publish", (String)"/create");
            String nuggetPath = nuggetRoot + groupPath;
            Node folder = JcrUtil.createPath(nuggetPath, "sling:Folder", session);
            Node nugget = folder.addNode("created", "oak:Unstructured");
            nugget.setProperty(PATH, root.getPath());
            nugget.setProperty("action", "Create Community Group");
            nugget.setProperty("formPayload", nuggetPath);
            for (Map.Entry<String, Object> property : properties.entrySet()) {
                String key = property.getKey();
                if (this.isSpecialRequestParam(key)) continue;
                JcrUtil.setProperty(nugget, key, property.getValue());
            }
            boolean bl = hasImage = !attachments.isEmpty();
            if (hasImage) {
                DataSource ds = attachments.get(0);
                this.addImage(nuggetPath, resolver, ds.getInputStream(), ds.getContentType());
            }
            session.save();
            if (resolver.getResource(nuggetPath) != null && this.settingsService != null && this.settingsService.getRunModes().contains("publish")) {
                ArrayList<String> paths = new ArrayList<String>(2);
                paths.add(nuggetPath);
                if (hasImage) {
                    paths.add(nuggetPath + "/" + PROPERTY_IMAGE_NAME);
                }
                this.replicator.reverseReplicate(ReplicationActionType.ACTIVATE, paths);
            }
            this.performAfterActions(createOperation, session, null, properties);
            ResourceResolver msmResolver = null;
            try {
                msmResolver = this.getServiceUserWrapper().getServiceResourceResolver(this.getBundleLocalResourceResolverFactory(), Collections.singletonMap("sling.service.subservice", MSM_SERVICE));
                GroupUtil.waitForPageCreation(msmResolver, groupPath, 120000L, 15000L);
            }
            finally {
                if (msmResolver != null) {
                    msmResolver.close();
                }
            }
            return root.getResourceResolver().resolve(groupPath + "/" + "configuration");
        }
        catch (OperationException e) {
            this.cleanupFailure(session);
            throw e;
        }
        catch (Exception e) {
            this.cleanupFailure(session);
            throw new OperationException("Failed to create community group.", e, 500);
        }
    }

    @Override
    public boolean approveJoin(ResourceResolver resolver, CommunityGroup group) throws OperationException {
        Session session = resolver.adaptTo(Session.class);
        if (StringUtils.endsWithIgnoreCase((String)session.getUserID(), (String)"anonymous")) {
            return false;
        }
        return group != null && "Open".equals(group.getType());
    }

    @Override
    public Resource join(SlingHttpServletRequest request) throws OperationException {
        Resource resource = request.getResource();
        ResourceResolver resolver = resource.getResourceResolver();
        Session session = resource.getResourceResolver().adaptTo(Session.class);
        String groupUrl = request.getParameter(PATH);
        if (StringUtils.isBlank((String)groupUrl)) {
            return null;
        }
        Resource groupPageResource = resolver.resolve(groupUrl);
        CommunityGroup group = (CommunityGroup)this.getCommunityGroupComponentForResource(groupPageResource, request);
        return this.join(resolver, group, session);
    }

    protected Resource join(ResourceResolver resolver, CommunityGroup group, Session session) throws OperationException {
        if (resolver == null || group == null || session == null) {
            return null;
        }
        if (!this.approveJoin(resolver, group)) {
            throw new OperationException("Deny " + session.getUserID() + "'s request to join community group " + group.getName(), 406);
        }
        ResourceResolver userAdminResolver = null;
        try {
            String authorizableId = session.getUserID();
            userAdminResolver = this.getServiceUserWrapper().getServiceResourceResolver(this.getBundleLocalResourceResolverFactory(), Collections.singletonMap("sling.service.subservice", USER_ADMIN));
            this.groupService.addGroupMember(userAdminResolver, group.getMemberGroupId(), authorizableId);
            resolver.adaptTo(Session.class).refresh(false);
            resolver.refresh();
        }
        catch (LoginException e) {
            this.cleanupFailure(session);
            throw new OperationException("Failed to login as user admin.", e, 500);
        }
        catch (GroupException e) {
            this.cleanupFailure(session);
            throw new OperationException("Failed to join community group.", e, 500);
        }
        catch (RepositoryException e) {
            this.cleanupFailure(session);
            throw new OperationException("Failed to join community group.", e, 500);
        }
        finally {
            if (userAdminResolver != null) {
                userAdminResolver.close();
            }
        }
        return group.getResource();
    }

    @Override
    public Resource leave(SlingHttpServletRequest request) throws OperationException {
        Resource resource = request.getResource();
        ResourceResolver resolver = resource.getResourceResolver();
        Session session = resource.getResourceResolver().adaptTo(Session.class);
        String groupUrl = request.getParameter(PATH);
        if (StringUtils.isBlank((String)groupUrl)) {
            return null;
        }
        Resource groupPageResource = resolver.resolve(groupUrl);
        CommunityGroup group = (CommunityGroup)this.getCommunityGroupComponentForResource(groupPageResource, request);
        return this.leave(resolver, group, session);
    }

    protected Resource leave(ResourceResolver resolver, CommunityGroup group, Session session) throws OperationException {
        if (resolver == null || group == null || session == null) {
            return null;
        }
        ResourceResolver userAdminResolver = null;
        try {
            String authorizableId = session.getUserID();
            userAdminResolver = this.getServiceUserWrapper().getServiceResourceResolver(this.getBundleLocalResourceResolverFactory(), Collections.singletonMap("sling.service.subservice", USER_ADMIN));
            this.groupService.removeGroupMember(userAdminResolver, group.getMemberGroupId(), authorizableId);
            resolver.adaptTo(Session.class).refresh(false);
            resolver.refresh();
        }
        catch (LoginException e) {
            this.cleanupFailure(session);
            throw new OperationException("Failed to login as user admin.", e, 500);
        }
        catch (GroupException e) {
            this.cleanupFailure(session);
            throw new OperationException("Failed to join community group.", e, 500);
        }
        catch (RepositoryException e) {
            this.cleanupFailure(session);
            throw new OperationException("Failed to join community group.", e, 500);
        }
        finally {
            if (userAdminResolver != null) {
                userAdminResolver.close();
            }
        }
        return group.getResource();
    }

    @Override
    public Resource invite(SlingHttpServletRequest request) throws OperationException {
        Resource resource = request.getResource();
        ResourceResolver resolver = resource.getResourceResolver();
        Session session = resource.getResourceResolver().adaptTo(Session.class);
        String[] inviteList = request.getParameterValues("users");
        CommunityContext context = resource.adaptTo(CommunityContext.class);
        Resource groupPageResource = resolver.resolve(context.getCommunityGroupPath());
        CommunityGroup group = (CommunityGroup)this.getCommunityGroupComponentForResource(groupPageResource, request);
        this.invite(resolver, group, inviteList, context, session);
        return resource;
    }

    protected void invite(ResourceResolver resolver, CommunityGroup group, String[] inviteList, CommunityContext context, Session session) throws OperationException {
        if (resolver == null || group == null || session == null) {
            return;
        }
        if (!GroupUtil.canInviteGroupMember(resolver, context)) {
            throw new OperationException("Deny " + session.getUserID() + "'s request to invite users to community group " + group.getName(), 406);
        }
        ResourceResolver userAdminResolver = null;
        try {
            userAdminResolver = this.getServiceUserWrapper().getServiceResourceResolver(this.getBundleLocalResourceResolverFactory(), Collections.singletonMap("sling.service.subservice", USER_ADMIN));
            this.groupService.addGroupMembers(userAdminResolver, group.getMemberGroupId(), inviteList);
            session.refresh(false);
            resolver.refresh();
        }
        catch (LoginException e) {
            this.cleanupFailure(session);
            throw new OperationException("Failed to login as user admin.", e, 500);
        }
        catch (GroupException e) {
            this.cleanupFailure(session);
            throw new OperationException("Failed to join community group.", e, 500);
        }
        catch (RepositoryException e) {
            this.cleanupFailure(session);
            throw new OperationException("Failed to join community group.", e, 500);
        }
        finally {
            if (userAdminResolver != null) {
                userAdminResolver.close();
            }
        }
    }

    @Override
    public Resource uninvite(SlingHttpServletRequest request) throws OperationException {
        Resource resource = request.getResource();
        ResourceResolver resolver = resource.getResourceResolver();
        Session session = resource.getResourceResolver().adaptTo(Session.class);
        String invite = request.getParameter("users");
        if (StringUtils.isEmpty((String)invite)) {
            return null;
        }
        String[] inviteList = invite.split("[\\s,;]");
        CommunityContext context = resource.adaptTo(CommunityContext.class);
        Resource groupPageResource = resolver.resolve(context.getCommunityGroupPath());
        CommunityGroup group = (CommunityGroup)this.getCommunityGroupComponentForResource(groupPageResource, request);
        this.uninvite(resolver, group, inviteList, context, session);
        return resource;
    }

    protected void uninvite(ResourceResolver resolver, CommunityGroup group, String[] inviteList, CommunityContext context, Session session) throws OperationException {
        if (resolver == null || group == null || session == null) {
            return;
        }
        if (!GroupUtil.canInviteGroupMember(resolver, context)) {
            throw new OperationException("Deny " + session.getUserID() + "'s request to invite users to community group " + group.getName(), 406);
        }
        ResourceResolver userAdminResolver = null;
        try {
            userAdminResolver = this.getServiceUserWrapper().getServiceResourceResolver(this.getBundleLocalResourceResolverFactory(), Collections.singletonMap("sling.service.subservice", USER_ADMIN));
            this.groupService.removeGroupMembers(userAdminResolver, group.getMemberGroupId(), inviteList);
            session.refresh(false);
            resolver.refresh();
        }
        catch (LoginException e) {
            this.cleanupFailure(session);
            throw new OperationException("Failed to login as user admin.", e, 500);
        }
        catch (GroupException e) {
            this.cleanupFailure(session);
            throw new OperationException("Failed to uninvite member from community group.", e, 500);
        }
        catch (RepositoryException e) {
            this.cleanupFailure(session);
            throw new OperationException("Failed to uninvite member from community group.", e, 500);
        }
        finally {
            if (userAdminResolver != null) {
                userAdminResolver.close();
            }
        }
    }

    @Override
    public Resource promoteMember(SlingHttpServletRequest request) throws OperationException {
        Resource resource = request.getResource();
        ResourceResolver resolver = resource.getResourceResolver();
        Session session = resource.getResourceResolver().adaptTo(Session.class);
        String[] inviteList = request.getParameterValues("users");
        CommunityContext context = resource.adaptTo(CommunityContext.class);
        Resource groupPageResource = resolver.resolve(context.getCommunityGroupPath());
        CommunityGroup group = (CommunityGroup)this.getCommunityGroupComponentForResource(groupPageResource, request);
        LOG.debug("promoteMember: resource {} groupPageResource {}", (Object)resource, (Object)groupPageResource);
        LOG.debug("promoteMember: communityGroupPath {}", (Object)context.getCommunityGroupPath());
        this.promoteMember(resolver, group, context, inviteList, session);
        return resource;
    }

    protected void promoteMember(ResourceResolver resolver, CommunityGroup group, CommunityContext context, String[] inviteList, Session session) throws OperationException {
        String groupAdminID = context.getSiteUserGroupName(CommunityUserGroup.GROUP_ADMIN);
        if (LOG.isDebugEnabled()) {
            LOG.debug("promoteMember: {} to {}", Arrays.asList(inviteList), (Object)groupAdminID);
        }
        if (resolver == null) {
            throw new IllegalArgumentException("resolver not allowed to be null");
        }
        if (group == null) {
            throw new IllegalArgumentException("group not allowed to be null");
        }
        if (session == null) {
            throw new IllegalArgumentException("session not allowed to be null");
        }
        if (!GroupUtil.canPromoteGroupMember(resolver, context)) {
            throw new OperationException("Deny " + session.getUserID() + "'s request to invite users to community group " + group.getName(), 406);
        }
        LOG.debug("promoteMember: {} is authorized.", (Object)resolver.getUserID());
        ResourceResolver userAdminResolver = null;
        try {
            userAdminResolver = this.getServiceUserWrapper().getServiceResourceResolver(this.getBundleLocalResourceResolverFactory(), Collections.singletonMap("sling.service.subservice", USER_ADMIN));
            LOG.debug("promoteMember: calling addGroupMembers adding {} to {}.", Arrays.asList(inviteList), (Object)groupAdminID);
            this.groupService.addGroupMembers(userAdminResolver, groupAdminID, inviteList);
            session.refresh(false);
            resolver.refresh();
        }
        catch (LoginException e) {
            this.cleanupFailure(session);
            throw new OperationException("Failed to login as user admin.", e, 500);
        }
        catch (GroupException e) {
            this.cleanupFailure(session);
            throw new OperationException("Failed to join community group.", e, 500);
        }
        catch (RepositoryException e) {
            this.cleanupFailure(session);
            throw new OperationException("Failed to join community group.", e, 500);
        }
        finally {
            if (userAdminResolver != null) {
                userAdminResolver.close();
            }
        }
    }

    @Override
    public Resource demoteMember(SlingHttpServletRequest request) throws OperationException {
        Resource resource = request.getResource();
        ResourceResolver resolver = resource.getResourceResolver();
        Session session = resource.getResourceResolver().adaptTo(Session.class);
        String[] inviteList = request.getParameterValues("users");
        CommunityContext context = resource.adaptTo(CommunityContext.class);
        Resource groupPageResource = resolver.resolve(context.getCommunityGroupPath());
        CommunityGroup group = (CommunityGroup)this.getCommunityGroupComponentForResource(groupPageResource, request);
        this.demoteMember(resolver, group, context, inviteList, session);
        return resource;
    }

    protected void demoteMember(ResourceResolver resolver, CommunityGroup group, CommunityContext context, String[] inviteList, Session session) throws OperationException {
        if (resolver == null || group == null || session == null) {
            return;
        }
        String groupAdminID = context.getSiteUserGroupName(CommunityUserGroup.GROUP_ADMIN);
        if (!GroupUtil.canPromoteGroupMember(resolver, context)) {
            throw new OperationException("Deny " + session.getUserID() + "'s request to invite users to community group " + group.getName(), 406);
        }
        ResourceResolver userAdminResolver = null;
        try {
            userAdminResolver = this.getServiceUserWrapper().getServiceResourceResolver(this.getBundleLocalResourceResolverFactory(), Collections.singletonMap("sling.service.subservice", USER_ADMIN));
            this.groupService.removeGroupMembers(userAdminResolver, groupAdminID, inviteList);
            this.groupService.addGroupMembers(userAdminResolver, group.getMemberGroupId(), inviteList);
            session.refresh(false);
            resolver.refresh();
        }
        catch (LoginException e) {
            this.cleanupFailure(session);
            throw new OperationException("Failed to login as user admin.", e, 500);
        }
        catch (GroupException e) {
            this.cleanupFailure(session);
            throw new OperationException("Failed to join community group.", e, 500);
        }
        catch (RepositoryException e) {
            this.cleanupFailure(session);
            throw new OperationException("Failed to join community group.", e, 500);
        }
        finally {
            if (userAdminResolver != null) {
                userAdminResolver.close();
            }
        }
    }

    private boolean isSpecialRequestParam(String paramName) {
        for (int i = 0; i < specialParams.length; ++i) {
            if (!paramName.equals(specialParams[i])) continue;
            return true;
        }
        return false;
    }

    protected void addImage(String path, ResourceResolver resolver, InputStream imageStream, String contentType) throws OperationException, RepositoryException {
        try {
            if (imageStream != null && imageStream.available() > 0) {
                Resource folder = ResourceUtil.getOrCreateResource(resolver, path, "sling:Folder", null, true);
                Node folderNode = folder.adaptTo(Node.class);
                Node imageNode = folderNode.addNode(PROPERTY_IMAGE_NAME, "nt:file");
                Node imageContentNode = imageNode.addNode("jcr:content", "nt:resource");
                Binary data = resolver.adaptTo(Session.class).getValueFactory().createBinary(imageStream);
                imageContentNode.setProperty("jcr:mimeType", contentType);
                imageContentNode.setProperty("jcr:data", data);
                imageContentNode.setProperty("jcr:lastModified", Calendar.getInstance());
            }
        }
        catch (IOException e) {
            throw new OperationException("IO failure", e, 500);
        }
    }

    protected List<DataSource> getAttachmentsFromRequest(SlingHttpServletRequest request, String requestParameterName) {
        RequestParameter[] fileRequestParameters = request.getRequestParameters(requestParameterName);
        if (fileRequestParameters != null) {
            return CollabUtil.getAttachmentsFromRequest(fileRequestParameters, Integer.MAX_VALUE, WHITE_LIST, BLACK_LIST);
        }
        return Collections.emptyList();
    }

    protected void getDefaultProperties(SlingHttpServletRequest request, Map<String, Object> props, boolean validateRequired) throws RepositoryException, OperationException {
        for (int i = 0; i < requestParams.length; ++i) {
            Object[] params = requestParams[i];
            Class clazz = (Class)params[1];
            String name = (String)params[0];
            if (clazz.isArray()) {
                String[] values = request.getParameterValues(name);
                if (validateRequired && values == null && ((Boolean)params[2]).booleanValue()) {
                    throw new OperationException("Community group value '" + name + "' is empty", 400);
                }
                if (clazz != String[].class || values == null) continue;
                props.put(name, values);
                continue;
            }
            String value = request.getParameter(name);
            if (validateRequired && value == null && ((Boolean)params[2]).booleanValue()) {
                throw new OperationException("Community group value '" + name + "' is empty", 400);
            }
            if (value == null) continue;
            props.put(name, GroupUtil.toObject(value, clazz));
        }
    }

    protected void getCustomProperties(SlingHttpServletRequest request, Map<String, Object> props, Session session) throws RepositoryException, OperationException {
    }

    private void addAllowedTemplate(String path, List<Object> allowedTemplates, ResourceResolver resolver) {
        Resource res = resolver.resolve(path);
        this.addAllowedTemplate(res, allowedTemplates, resolver);
    }

    private void addAllowedTemplate(Resource res, List<Object> allowedTemplates, ResourceResolver resolver) {
        ValueMap v;
        boolean isDisabled;
        if (res != null && !ResourceUtil.isNonExistingResource(res) && !(isDisabled = (v = res.adaptTo(ValueMap.class)).get("isDisabled", false).booleanValue())) {
            HashMap<String, String> data = new HashMap<String, String>();
            data.put(PATH, res.getPath());
            data.put(NAME, (String)v.get("jcr:title"));
            allowedTemplates.add(data);
        }
    }

    private void addTemplatesUnderResource(String path, List<Object> allowedTemplates, ResourceResolver userAdminResolver) {
        Resource templates = userAdminResolver.resolve(path);
        if (templates != null && templates.hasChildren()) {
            for (Resource res : templates.getChildren()) {
                if (res == null || ResourceUtil.isNonExistingResource(res)) continue;
                ValueMap v = res.adaptTo(ValueMap.class);
                HashMap<String, String> data = new HashMap<String, String>();
                data.put(PATH, res.getPath());
                data.put(NAME, (String)v.get("jcr:title"));
                allowedTemplates.add(data);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Object> getAllowedTemplateForEveryone(String[] paths) {
        ArrayList<Object> allowedTemplates = new ArrayList<Object>();
        ResourceResolver msmResolver = null;
        try {
            msmResolver = this.getServiceUserWrapper().getServiceResourceResolver(this.getBundleLocalResourceResolverFactory(), Collections.singletonMap("sling.service.subservice", MSM_SERVICE));
            if (paths != null && paths.length > 0) {
                for (int i = 0; i < paths.length; ++i) {
                    this.addAllowedTemplate(paths[i], allowedTemplates, msmResolver);
                }
            } else {
                this.addTemplatesUnderResource(DEFAULT_GROUP_TEMPLATE_ROOT, allowedTemplates, msmResolver);
                this.addTemplatesUnderResource(CUSTOM_GROUP_TEMPLATE_ROOT, allowedTemplates, msmResolver);
            }
        }
        catch (LoginException e) {
            LOG.error("Failed to login as user admin.", (Throwable)e);
        }
        finally {
            if (msmResolver != null) {
                msmResolver.close();
            }
        }
        return allowedTemplates;
    }

    @Override
    public SocialComponent getCommunityGroupComponentForResource(Resource communityGroup, SlingHttpServletRequest request) {
        Resource resource;
        String path = communityGroup.getPath();
        if (!path.endsWith("configuration")) {
            path = path + "/" + "configuration";
        }
        if ((resource = request.getResourceResolver().getResource(path)) == null) {
            LOG.debug("getCommunityGroupComponentForResource: Resource at {} not found with resolver for user {}", (Object)path, (Object)request.getResourceResolver().getUserID());
            return null;
        }
        SocialComponentFactory factory = this.componentFactoryManager.getSocialComponentFactory(resource);
        if (factory == null) {
            LOG.debug("getCommunityGroupComponentForResource: SocialComponentFactory responsible for {} not found.", (Object)resource.getPath());
            return null;
        }
        SocialComponent sc = factory.getSocialComponent(resource, request);
        if (sc == null) {
            LOG.debug("getCommunityGroupComponentForResource: SocialComponentFactory {} returned null for {}.", (Object)sc, (Object)resource.getPath());
        }
        return sc;
    }

    @Override
    public SocialComponent getCommunityMemberListComponentForResource(Resource communityMembers, SlingHttpServletRequest request) {
        String path = communityMembers.getPath();
        Resource resource = request.getResourceResolver().getResource(path);
        if (resource == null) {
            return null;
        }
        SocialComponentFactory factory = this.componentFactoryManager.getSocialComponentFactory(resource);
        return factory != null ? factory.getSocialComponent(resource, request) : null;
    }

    protected abstract U getCreateOperation();

    protected abstract U getJoinOperation();

    protected abstract U getLeaveOperation();

    protected void bindComponentFactoryManager(SocialComponentFactoryManager socialComponentFactoryManager) {
        this.componentFactoryManager = socialComponentFactoryManager;
    }

    protected void unbindComponentFactoryManager(SocialComponentFactoryManager socialComponentFactoryManager) {
        if (this.componentFactoryManager == socialComponentFactoryManager) {
            this.componentFactoryManager = null;
        }
    }

    protected void bindReplicator(AsyncReverseReplicator asyncReverseReplicator) {
        this.replicator = asyncReverseReplicator;
    }

    protected void unbindReplicator(AsyncReverseReplicator asyncReverseReplicator) {
        if (this.replicator == asyncReverseReplicator) {
            this.replicator = null;
        }
    }

    protected void bindGroupService(GroupService groupService) {
        this.groupService = groupService;
    }

    protected void unbindGroupService(GroupService groupService) {
        if (this.groupService == groupService) {
            this.groupService = null;
        }
    }

    protected void bindRepository(SlingRepository slingRepository) {
        this.repository = slingRepository;
    }

    protected void unbindRepository(SlingRepository slingRepository) {
        if (this.repository == slingRepository) {
            this.repository = null;
        }
    }

    protected void bindServiceUserWrapper(ServiceUserWrapper serviceUserWrapper) {
        this.serviceUserWrapper = serviceUserWrapper;
    }

    protected void unbindServiceUserWrapper(ServiceUserWrapper serviceUserWrapper) {
        if (this.serviceUserWrapper == serviceUserWrapper) {
            this.serviceUserWrapper = null;
        }
    }

    protected void bindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resourceResolverFactory = resourceResolverFactory;
    }

    protected void unbindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resourceResolverFactory == resourceResolverFactory) {
            this.resourceResolverFactory = null;
        }
    }

    protected void bindSettingsService(SlingSettingsService slingSettingsService) {
        this.settingsService = slingSettingsService;
    }

    protected void unbindSettingsService(SlingSettingsService slingSettingsService) {
        if (this.settingsService == slingSettingsService) {
            this.settingsService = null;
        }
    }
}

